/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.message.PrepareMultipleCoreModelCompleted;
import com.nokia.em.bts.coreasset.message.PrepareMultipleCoreModelRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.MultipleCorePrepareListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class MultipleCorePrepareScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private MultipleCorePrepareListener myListener;
    private int mySeqNumber;
    private boolean myRunning;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public MultipleCorePrepareScenario(BTSConnection connection, MultipleCorePrepareListener listener) {
        this.myBTSConnection = connection;
        this.myListener = listener;
    }

    @Override
    public void execute() {
        if (this.isRunning()) {
            this.myLogger.debug((Object)"Illegal state.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.setIsRunning(true);
        CoreAssetThread fileTransferWorker = new CoreAssetThread(){

            protected Object construct() {
                return MultipleCorePrepareScenario.this.runScenario();
            }
        };
        fileTransferWorker.start();
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myBTSConnection.interruptScenario(this.mySeqNumber);
        }
        return true;
    }

    private boolean runScenario() {
        this.mySeqNumber = this.myBTSConnection.createScenario();
        PrepareMultipleCoreModelRequest prepareMultipleCoreModelRequest = new PrepareMultipleCoreModelRequest(this.mySeqNumber);
        this.myBTSConnection.sendToBTS((BTSMessage)prepareMultipleCoreModelRequest);
        this.myListener.prepareMultipleCoreMsgSent();
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myListener.prepareMultipleCoreRequestRejectted();
            } else {
                this.prepareMultipleCoreRequestAcceptted();
            }
        } else if (response instanceof Timeout) {
            this.myListener.multipleCorePrepareFailed(MultipleCorePrepareListener.FailedReason.TIMEOUT);
        } else if (response == null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
            this.myListener.multipleCorePrepareFailed(MultipleCorePrepareListener.FailedReason.UNKNOWN);
        }
        this.myRunning = false;
        this.myBTSConnection.deleteScenario(this.mySeqNumber);
        return false;
    }

    private void prepareMultipleCoreRequestAcceptted() {
        this.myListener.prepareMultipleCoreRequestAccepted();
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber);
        if (response instanceof PrepareMultipleCoreModelCompleted) {
            this.myListener.multipleCoreModelCompletedMsgReceived();
        } else if (response instanceof Timeout) {
            this.myListener.multipleCorePrepareFailed(MultipleCorePrepareListener.FailedReason.TIMEOUT);
        } else if (response == null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. PrepareMultipleCoreModelCompleted expected.");
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. PrepareMultipleCoreModelCompleted expected.");
            this.myListener.multipleCorePrepareFailed(MultipleCorePrepareListener.FailedReason.UNKNOWN);
        }
    }

    private void setIsRunning(boolean value) {
        this.myRunning = value;
    }

    protected boolean isRunning() {
        return this.myRunning;
    }
}

