/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.message.ChangePowerLineStateRequest;
import com.nokia.em.bts.coreasset.message.PowerOperationsCompleted;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.PowerControlListener;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.PowerLineState;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class PowerControlScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private PowerControlListener myListener;
    private int mySeqNumber;
    private boolean myRunning;
    private int mySystemModuleId;
    private String myLineId;
    private PowerLineState myState;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public PowerControlScenario(BTSConnection connection, PowerControlListener listener, int systemModelId, String lineId, PowerLineState state) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myListener = listener;
        this.mySystemModuleId = systemModelId;
        this.myLineId = lineId;
        this.myState = state;
    }

    public PowerControlScenario(BTSConnection connection, PowerControlListener listener, int systemModelId, String lineId, PowerLineState state, BTSMessage.Type type) {
        this(connection, listener, systemModelId, lineId, state);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return PowerControlScenario.this.runScenario();
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myBTSConnection.interruptScenario(this.mySeqNumber);
        }
        return true;
    }

    private Object runScenario() {
        this.mySeqNumber = this.myBTSConnection.createScenario();
        ChangePowerLineStateRequest startRequest = new ChangePowerLineStateRequest(this.mySeqNumber, this.mySystemModuleId, this.myLineId, this.myState, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)startRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myListener.powerChangedFailed(this.mySystemModuleId, this.myLineId, ack.getNackReason());
            } else {
                this.waitPowerOperationCompleted();
            }
        } else if (response instanceof Timeout) {
            this.myListener.powerChangedFailed(this.mySystemModuleId, this.myLineId, 68);
        } else if (response == null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. PowerOperationCompleted expected.");
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
            this.myListener.powerChangedFailed(this.mySystemModuleId, this.myLineId, 28);
        }
        this.myRunning = false;
        this.myBTSConnection.deleteScenario(this.mySeqNumber);
        return false;
    }

    private void waitPowerOperationCompleted() {
        this.myListener.powerChangeRequestAccepted(this.mySystemModuleId, this.myLineId);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber);
        if (response instanceof PowerOperationsCompleted) {
            PowerOperationsCompleted powerOperationsCompleted = (PowerOperationsCompleted)response;
            int successCode = powerOperationsCompleted.getSuccessCode();
            if (successCode == 36) {
                this.myListener.powerChangedSuccess(this.mySystemModuleId, this.myLineId);
            } else {
                this.myListener.powerChangedFailed(this.mySystemModuleId, this.myLineId, successCode);
            }
        } else if (response instanceof Timeout) {
            this.myListener.powerChangedFailed(this.mySystemModuleId, this.myLineId, 68);
        } else if (response == null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. PowerOperationCompleted expected.");
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. PowerOperationCompleted expected.");
            this.myListener.powerChangedFailed(this.mySystemModuleId, this.myLineId, 28);
        }
    }
}

