/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.AutoconnParamsUpdateRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.UpdateAutoConnectionParametersListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import org.apache.log4j.Logger;

public class UpdateAutoConnectionParametersScenario
implements Scenario {
    private Logger myLogger;
    private BTSConnection myBTSConnection;
    private UpdateAutoConnectionParametersListener myAutoConnListener;
    private int mySeqNbr;
    private boolean myRunning;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    StringBuffer messageParameters;

    public UpdateAutoConnectionParametersScenario(BTSConnection connection, UpdateAutoConnectionParametersListener listener, int btsId, String siteId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myAutoConnListener = listener;
        this.messageParameters = new StringBuffer();
        this.messageParameters.append("<_btsId>");
        this.messageParameters.append(btsId);
        this.messageParameters.append("</_btsId>");
        if (siteId != null) {
            this.messageParameters.append("<_siteId>");
            this.messageParameters.append(siteId);
            this.messageParameters.append("</_siteId>");
        } else {
            this.messageParameters.append("<_siteId>");
            this.messageParameters.append("</_siteId>");
        }
    }

    public UpdateAutoConnectionParametersScenario(BTSConnection connection, UpdateAutoConnectionParametersListener listener, int btsId, String siteId, BTSMessage.Type type) {
        this(connection, listener, btsId, siteId);
        this.myType = type;
    }

    public UpdateAutoConnectionParametersScenario(BTSConnection connection, UpdateAutoConnectionParametersListener listener, String siteId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myAutoConnListener = listener;
        this.messageParameters = new StringBuffer();
        if (siteId != null) {
            this.messageParameters.append("<_siteId>");
            this.messageParameters.append(XmlUtils.encode((String)siteId));
            this.messageParameters.append("</_siteId>");
        } else {
            this.messageParameters.append("<_siteId>");
            this.messageParameters.append("</_siteId>");
        }
    }

    public UpdateAutoConnectionParametersScenario(BTSConnection connection, UpdateAutoConnectionParametersListener listener, String siteId, BTSMessage.Type type) {
        this(connection, listener, siteId);
        this.myType = type;
    }

    public UpdateAutoConnectionParametersScenario(BTSConnection connection, UpdateAutoConnectionParametersListener listener, int btsId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myAutoConnListener = listener;
        this.messageParameters = new StringBuffer();
        this.messageParameters.append("<_btsId>");
        this.messageParameters.append(btsId);
        this.messageParameters.append("</_btsId>");
    }

    public UpdateAutoConnectionParametersScenario(BTSConnection connection, UpdateAutoConnectionParametersListener listener, int btsId, BTSMessage.Type type) {
        this(connection, listener, btsId);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return UpdateAutoConnectionParametersScenario.this.runScenario();
            }

            protected void finished() {
                UpdateAutoConnectionParametersScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myAutoConnListener.autoConnectionParameterUpdateFailed(85);
            return true;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        AutoconnParamsUpdateRequest request = new AutoconnParamsUpdateRequest(this.mySeqNbr, this.messageParameters.toString(), this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)request);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        this.myBTSConnection.deleteScenario(this.mySeqNbr);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                this.myLogger.debug((Object)"AutoConnection parameters updated.");
                this.myAutoConnListener.autoConnectionParametersUpdated();
            } else {
                this.myLogger.debug((Object)"AutoConnection parameters update failed.");
                this.myAutoConnListener.autoConnectionParameterUpdateFailed(ackResponse.getNackReason());
            }
        } else if (response instanceof Timeout) {
            this.myLogger.debug((Object)"AutoConnection parameters update timeout.");
            this.myAutoConnListener.autoConnectionParameterUpdateFailed(68);
        } else if (response == null) {
            this.myLogger.error((Object)"Null message, aborted or connection lost.");
        } else {
            this.myLogger.error((Object)"Invalid message from BTS.");
            this.myAutoConnListener.autoConnectionParameterUpdateFailed(28);
        }
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

