/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.licencemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.LicenceFileDeleteReply;
import com.nokia.em.bts.coreasset.message.LicenceFileDeleteRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.licencemanagement.LicenceListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class DeleteLicenceScenario
implements Scenario {
    private BTSConnection myConnection;
    private LicenceListener myLicenceListener;
    private String myFileId;
    private boolean myExecution = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public DeleteLicenceScenario(BTSConnection connection, LicenceListener licenceListener, String fileId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myLicenceListener = licenceListener;
        this.myFileId = fileId;
    }

    public DeleteLicenceScenario(BTSConnection connection, LicenceListener licenceListener, String fileId, BTSMessage.Type type) {
        this(connection, licenceListener, fileId);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myExecution) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myExecution = true;
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    DeleteLicenceScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    DeleteLicenceScenario.this.myLicenceListener.deleteFailed(DeleteLicenceScenario.this.myFileId, 10);
                    return true;
                }
                this.seqNumber = DeleteLicenceScenario.this.myConnection.createScenario();
                LicenceFileDeleteRequest licenceFileDeleteRequest = new LicenceFileDeleteRequest(this.seqNumber, DeleteLicenceScenario.this.myFileId, DeleteLicenceScenario.this.myType);
                DeleteLicenceScenario.this.myConnection.sendToBTS((BTSMessage)licenceFileDeleteRequest);
                BTSMessage response = DeleteLicenceScenario.this.myConnection.receiveFromBTS(this.seqNumber);
                if (response instanceof LicenceFileDeleteReply) {
                    LicenceFileDeleteReply licenceFileDeleteReply = (LicenceFileDeleteReply)response;
                    int operationResult = licenceFileDeleteReply.getOperationResult();
                    if (operationResult == 36) {
                        DeleteLicenceScenario.this.myLogger.debug((Object)"Delete successful.");
                        DeleteLicenceScenario.this.myLicenceListener.deleteSuccessful(DeleteLicenceScenario.this.myFileId);
                        return true;
                    }
                    if (operationResult == 82) {
                        DeleteLicenceScenario.this.myLogger.debug((Object)"Delete failed, operation failed.");
                        DeleteLicenceScenario.this.myLicenceListener.deleteFailed(DeleteLicenceScenario.this.myFileId, 7);
                    } else if (operationResult == 77) {
                        DeleteLicenceScenario.this.myLogger.debug((Object)"Delete failed, missing licence.");
                        DeleteLicenceScenario.this.myLicenceListener.deleteFailed(DeleteLicenceScenario.this.myFileId, 1);
                    } else {
                        DeleteLicenceScenario.this.myLogger.error((Object)"Invalid message value from BTS.");
                        DeleteLicenceScenario.this.myLicenceListener.deleteFailed(DeleteLicenceScenario.this.myFileId, 5);
                    }
                } else {
                    DeleteLicenceScenario.this.myLogger.error((Object)"Invalid message from BTS or connection lost.");
                    DeleteLicenceScenario.this.myLicenceListener.deleteFailed(DeleteLicenceScenario.this.myFileId, 5);
                }
                return false;
            }

            protected void finished() {
                DeleteLicenceScenario.this.myConnection.deleteScenario(this.seqNumber);
                DeleteLicenceScenario.this.myExecution = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

