/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.licencemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.LicenceQueryReply;
import com.nokia.em.bts.coreasset.message.LicenceQueryRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.licencemanagement.LicenceListener;
import com.nokia.em.bts.coreasset.scenario.licencemanagement.LicenceQueryData;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class QueryLicenceScenario
implements Scenario,
SnapshotSaver {
    private BTSConnection myConnection;
    private LicenceListener myLicenceListener;
    private String myFileId;
    private long myFeatureCode;
    private boolean myExecution = false;
    private String myData = "";
    private static final String SNAPSHOT_TASK = "Licences";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_Licences";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    protected static final long LICENSE_QUERY_TIMEOUT = 120000L;
    private int myRequestSeqNumber;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public QueryLicenceScenario(BTSConnection connection, LicenceListener licenceListener, String fileId, long featureCode) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myLicenceListener = licenceListener;
        this.myFileId = fileId;
        this.myFeatureCode = featureCode;
    }

    public QueryLicenceScenario(BTSConnection connection, LicenceListener licenceListener, String fileId, long featureCode, BTSMessage.Type type) {
        this(connection, licenceListener, fileId, featureCode);
        this.myType = type;
    }

    private void openSnapshot() {
        String licenceFile = String.valueOf(CoreAsset.getSnapshotOpenLocation().getFile()) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml";
        Element root = Tools.parseElement((String)licenceFile);
        if (root == null) {
            this.myLogger.error((Object)"Cannot parse licence snapshot.");
            try {
                CoreAssetThread.sleep((long)200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myLicenceListener.queryFailed(10);
            return;
        }
        try {
            LicenceQueryReply reply = new LicenceQueryReply(0, root);
            LicenceQueryData[] licenceQueryData = reply.getData();
            this.myLicenceListener.querySuccessful(licenceQueryData);
        }
        catch (Exception e) {
            this.myLogger.error((Object)"Cannot create licence data.", (Throwable)e);
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myLicenceListener.queryFailed(10);
        }
    }

    @Override
    public void execute() {
        if (this.myExecution) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        CoreAsset.removeSnapshotSaver(this);
        this.myExecution = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    QueryLicenceScenario.this.myLogger.debug((Object)"Opening snapshot.");
                    QueryLicenceScenario.this.openSnapshot();
                    return true;
                }
                try {
                    QueryLicenceScenario.this.myRequestSeqNumber = QueryLicenceScenario.this.myConnection.createScenario();
                    LicenceQueryRequest licenceQueryRequest = new LicenceQueryRequest(QueryLicenceScenario.this.myRequestSeqNumber, QueryLicenceScenario.this.myFileId, QueryLicenceScenario.this.myFeatureCode, QueryLicenceScenario.this.myType);
                    QueryLicenceScenario.this.myConnection.sendToBTS((BTSMessage)licenceQueryRequest);
                    BTSMessage response = QueryLicenceScenario.this.myConnection.receiveFromBTS(QueryLicenceScenario.this.myRequestSeqNumber, 120000L);
                    QueryLicenceScenario.this.myConnection.deleteScenario(QueryLicenceScenario.this.myRequestSeqNumber);
                    if (response instanceof LicenceQueryReply) {
                        LicenceQueryReply licenceQueryReply = (LicenceQueryReply)response;
                        int operationResult = licenceQueryReply.getOperationResult();
                        if (operationResult == 36) {
                            LicenceQueryData[] licenceQueryData = licenceQueryReply.getData();
                            CoreAsset.addSnapshotSaver(QueryLicenceScenario.this);
                            QueryLicenceScenario.this.myData = licenceQueryReply.getCodedMessage();
                            QueryLicenceScenario.this.myLicenceListener.querySuccessful(licenceQueryData);
                            return true;
                        }
                        if (operationResult == 77) {
                            QueryLicenceScenario.this.myLicenceListener.queryFailed(1);
                        } else if (operationResult == 78) {
                            QueryLicenceScenario.this.myLicenceListener.queryFailed(2);
                        } else if (operationResult == 83) {
                            QueryLicenceScenario.this.myLicenceListener.queryFailed(8);
                        } else {
                            QueryLicenceScenario.this.myLogger.debug((Object)("Unknown operation result in licence query: " + operationResult));
                            QueryLicenceScenario.this.myLicenceListener.queryFailed(5);
                        }
                        return false;
                    }
                    QueryLicenceScenario.this.myLicenceListener.queryFailed(5);
                    QueryLicenceScenario.this.myLogger.debug((Object)("Wrong reply received from BTS. LicenceQueryReply expected, " + (response == null ? null : response.getClass()) + " received."));
                    return false;
                }
                catch (Exception e) {
                    QueryLicenceScenario.this.myLogger.error((Object)"Unknown Error occurred.", (Throwable)e);
                    QueryLicenceScenario.this.myLicenceListener.queryFailed(9);
                    return false;
                }
            }

            protected void finished() {
                QueryLicenceScenario.this.myConnection.deleteScenario(QueryLicenceScenario.this.myRequestSeqNumber);
                QueryLicenceScenario.this.myExecution = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myLicenceListener = new LicenceListener(){

            @Override
            public void deleteFailed(String fileId, int reason) {
            }

            @Override
            public void deleteSuccessful(String fileId) {
            }

            @Override
            public void queryFailed(int reason) {
            }

            @Override
            public void querySuccessful(LicenceQueryData[] licenceData) {
            }

            @Override
            public void updateAccepted(String fileId) {
            }

            @Override
            public void updateDenied(String fileId) {
            }

            @Override
            public void updateFailed(String fileId, int reason) {
            }

            @Override
            public void updateSuccessful(String fileId) {
            }
        };
        if (this.myConnection != null) {
            this.myLogger.debug((Object)"Trying to interrupt LicenceQueryReply receiving...");
            this.myConnection.interruptScenario(this.myRequestSeqNumber);
        }
        return true;
    }

    public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(SNAPSHOT_TASK_NAME);
        return l;
    }

    public boolean isLocalisationRequired() {
        return true;
    }

    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                QueryLicenceScenario.this.runSave(url, sp);
                return null;
            }
        };
        worker.start();
    }

    private void runSave(String url, SaverProgressListener sp) {
        block11: {
            sp.taskStarted(SNAPSHOT_TASK_NAME, 7, 10000, this.isLocalisationRequired());
            File dir = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK);
            dir.mkdir();
            File f = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml");
            OutputStreamWriter out = null;
            try {
                try {
                    out = new OutputStreamWriter(new FileOutputStream(f, false));
                    out.write(this.myData);
                }
                catch (IOException e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)"Failed to save licence snapshot information");
                    try {
                        out.close();
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                        this.myLogger.debug((Object)"Licence snapshot file successfully created");
                    }
                    catch (Exception e2) {
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)"Failed to close licence snapshot file");
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                    this.myLogger.debug((Object)"Licence snapshot file successfully created");
                }
                catch (Exception e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)"Failed to close licence snapshot file");
                }
                throw throwable;
            }
            try {
                out.close();
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                this.myLogger.debug((Object)"Licence snapshot file successfully created");
            }
            catch (Exception e) {
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                this.myLogger.error((Object)"Failed to close licence snapshot file");
            }
        }
        sp.saveCompleted((SnapshotSaver)this);
    }

    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled((SnapshotSaver)this);
    }

    public int getSavingPriority() {
        return 2;
    }

    public void stopProcess(int process) {
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    public String getData() {
        return this.myData;
    }
}

