/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.licencemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.LicenceUpToDate;
import com.nokia.em.bts.coreasset.message.LicenceUpdateRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.licencemanagement.LicenceListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.io.File;
import org.apache.log4j.Logger;

public class UpdateLicenceScenario
implements Scenario {
    private BTSConnection myConnection;
    private LicenceListener myLicenceListener;
    private String myFileId;
    private boolean myExecution = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public UpdateLicenceScenario(BTSConnection connection, LicenceListener licenceListener, String fileId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myLicenceListener = licenceListener;
        this.myFileId = fileId;
    }

    public UpdateLicenceScenario(BTSConnection connection, LicenceListener licenceListener, String fileId, BTSMessage.Type type) {
        this(connection, licenceListener, fileId);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myExecution) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myExecution = true;
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    UpdateLicenceScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 10);
                    return true;
                }
                try {
                    String strThisIp = UpdateLicenceScenario.this.myConnection.getLocalIPAddress();
                    File file = new File(UpdateLicenceScenario.this.myFileId);
                    this.seqNumber = UpdateLicenceScenario.this.myConnection.createScenario();
                    FileTransferServer server = UpdateLicenceScenario.this.myConnection.getFileTransferFactory().getFileTransferServer();
                    server.initListenerAndPath((FileTransferListener)new FileTransferAdapter(), file.getParent());
                    FTPTransferInfo ftpTransferInfo = new FTPTransferInfo(file.getName(), strThisIp, server.getUserName(), server.getPassword().toCharArray());
                    try {
                        int port = server.startServer();
                        if (port != 21) {
                            ftpTransferInfo.setServerAddress(String.valueOf(ftpTransferInfo.getServerAddress()) + ":" + port);
                        }
                    }
                    catch (Exception ftpEx) {
                        UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 6);
                        UpdateLicenceScenario.this.myLogger.error((Object)"Unable to start FTP Server.", (Throwable)ftpEx);
                        return false;
                    }
                    LicenceUpdateRequest licenceUpdateRequest = new LicenceUpdateRequest(this.seqNumber, ftpTransferInfo, UpdateLicenceScenario.this.myType);
                    UpdateLicenceScenario.this.myConnection.sendToBTS((BTSMessage)licenceUpdateRequest);
                    BTSMessage response = UpdateLicenceScenario.this.myConnection.receiveFromBTS(this.seqNumber);
                    if (response instanceof Ack) {
                        Ack ack = (Ack)response;
                        if (!ack.getAck()) {
                            UpdateLicenceScenario.this.myLicenceListener.updateDenied(UpdateLicenceScenario.this.myFileId);
                            UpdateLicenceScenario.this.myLogger.debug((Object)("BTS Nacked, reason " + ack.getNackReasonString()));
                            return false;
                        }
                    } else {
                        UpdateLicenceScenario.this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
                        UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 5);
                        return false;
                    }
                    UpdateLicenceScenario.this.myLicenceListener.updateAccepted(UpdateLicenceScenario.this.myFileId);
                    response = UpdateLicenceScenario.this.myConnection.receiveFromBTS(this.seqNumber);
                    if (response instanceof LicenceUpToDate) {
                        LicenceUpToDate licenceUpToDate = (LicenceUpToDate)response;
                        int operationResult = licenceUpToDate.getUpdateResult();
                        if (operationResult == 36) {
                            UpdateLicenceScenario.this.myLicenceListener.updateSuccessful(UpdateLicenceScenario.this.myFileId);
                            server.stopServer();
                            return true;
                        }
                        if (operationResult == 77) {
                            UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 1);
                        } else if (operationResult == 79) {
                            UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 3);
                        } else if (operationResult == 80) {
                            UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 4);
                        } else if (operationResult == 82) {
                            UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 7);
                        } else if (operationResult == 83) {
                            UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 8);
                        } else if (operationResult == 139) {
                            UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 12);
                        } else {
                            UpdateLicenceScenario.this.myLogger.debug((Object)("Wrong response code received from BTS, " + operationResult + " received."));
                            UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 5);
                        }
                        server.stopServer();
                        return false;
                    }
                    UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 5);
                    UpdateLicenceScenario.this.myLogger.debug((Object)("Wrong reply received from BTS, LicenceUpToDate expected, " + (response == null ? null : response.getClass()) + " received."));
                    server.stopServer();
                }
                catch (Exception e) {
                    UpdateLicenceScenario.this.myLogger.error((Object)("Unknown Error occurred." + e.getMessage()));
                    UpdateLicenceScenario.this.myLicenceListener.updateFailed(UpdateLicenceScenario.this.myFileId, 9);
                }
                return false;
            }

            protected void finished() {
                UpdateLicenceScenario.this.myConnection.deleteScenario(this.seqNumber);
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

