/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.performancemanagement;

import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMFileHandler;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PMGenericFileHandler
implements PMFileHandler {
    private Logger myLogger = Logger.getLogger(this.getClass());

    @Override
    public boolean isValidFileName(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.matches("PM\\..+\\.gz") || fileName.matches("PM\\..+\\.xz");
    }

    @Override
    public File unzipFile(File archivedFile) {
        try {
            return this.unzipArchive(archivedFile);
        }
        catch (IOException e) {
            this.myLogger.error((Object)("Exception happned when decompressing file: " + archivedFile.getName() + ". " + e.getMessage()));
            this.myLogger.error((Object)("Not a gz or xz file: " + archivedFile.getName()));
            return null;
        }
    }

    private File unzipArchive(File archivedFile) throws IOException {
        if (Tools.isGZipFile((File)archivedFile)) {
            return Tools.gunZip((File)archivedFile);
        }
        if (Tools.isXZipFile((File)archivedFile)) {
            return Tools.xunZip((File)archivedFile);
        }
        return null;
    }
}

