/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.performancemanagement;

import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMCounterData;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMCounterDataDateComparator;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMCounterDataImpl;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMCounterDataNameComparator;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMDataCell;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMResult;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMResultComparator;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class PMResultImpl
implements PMResult {
    private Map myPMDataCells;
    private Comparator myCounterNameComparator;
    private Comparator myCounterDateComparator;
    private final String myGroupMappingName;
    private static String myBTSName = "";

    public PMResultImpl(String groupMappingName) {
        this.myGroupMappingName = groupMappingName;
        this.myPMDataCells = new HashMap();
        this.myCounterNameComparator = new PMCounterDataNameComparator();
        this.myCounterDateComparator = new PMCounterDataDateComparator();
    }

    protected void addData(String cellId, PMCounterData data) {
        if (!this.myPMDataCells.containsKey(cellId)) {
            this.myPMDataCells.put(cellId, new PMDataCell());
        }
        PMDataCell dataCell = (PMDataCell)this.myPMDataCells.get(cellId);
        dataCell.addCounterData(data);
    }

    public void addData(String cellId, String counterNodeName, Date startDateObject, Number value) {
        if (!this.myPMDataCells.containsKey(cellId)) {
            this.myPMDataCells.put(cellId, new PMDataCell());
        }
        PMDataCell dataCell = (PMDataCell)this.myPMDataCells.get(cellId);
        dataCell.addCounterData(counterNodeName, startDateObject, value);
    }

    public static String getMyBTSName() {
        return myBTSName;
    }

    public static void setMyBTSName(String myBTSName) {
        PMResultImpl.myBTSName = myBTSName;
    }

    @Override
    public String[] getCellNames() {
        TreeSet cellSet = new TreeSet(new PMResultComparator());
        cellSet.addAll(this.myPMDataCells.keySet());
        return cellSet.toArray(new String[0]);
    }

    @Override
    public String[] getCounterNames(String cellName) {
        PMDataCell dataCell;
        if (cellName != null && (dataCell = (PMDataCell)this.myPMDataCells.get(cellName)) != null) {
            TreeSet counterNamesSet = new TreeSet(this.myCounterNameComparator);
            counterNamesSet.addAll(dataCell.getCounterNames());
            return counterNamesSet.toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public Date[] getTimes(String cellName) {
        PMDataCell dataCell;
        if (cellName != null && (dataCell = (PMDataCell)this.myPMDataCells.get(cellName)) != null) {
            TreeSet counterTimesSet = new TreeSet(this.myCounterDateComparator);
            counterTimesSet.addAll(dataCell.getCounterTimes());
            return counterTimesSet.toArray(new Date[0]);
        }
        return new Date[0];
    }

    @Override
    public PMCounterData getCounters(String cellName, String counterName) {
        PMDataCell dataCell;
        if (cellName != null && counterName != null && (dataCell = (PMDataCell)this.myPMDataCells.get(cellName)) != null) {
            return dataCell.getCounterData(counterName);
        }
        return new PMCounterDataImpl(counterName);
    }

    @Override
    public PMCounterData[] getCounters(String cellName, Date timeDate) {
        PMDataCell dataCell;
        if (cellName != null && timeDate != null && (dataCell = (PMDataCell)this.myPMDataCells.get(cellName)) != null) {
            TreeSet counterTimeSet = new TreeSet(this.myCounterNameComparator);
            counterTimeSet.addAll(dataCell.getCounterData(timeDate));
            return counterTimeSet.toArray(new PMCounterData[0]);
        }
        return new PMCounterData[0];
    }

    @Override
    public String getGroupMappingName() {
        return this.myGroupMappingName;
    }

    @Override
    public void setCounterNameComparator(Comparator comparator) {
        this.myCounterNameComparator = comparator;
    }
}

