/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.performancemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMResult;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMResultImpl;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PerformanceDataListener;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.parser.PMFileParserListener;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.parser.PMFileStAXParser;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class PerformanceDataBuilder
implements PMFileParserListener {
    private static final int NO_COUNTER_ERROR = -1;
    private SortedMap<String, File> myFilesData;
    private boolean myStoreOldResults;
    private Map<String, String> myGroupMap;
    private Map<String, PMResultImpl> myPMResults;
    private final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private String myTechType = "Unknown";
    private static final String SNAPSHOT_TASK = "PM";
    private Logger myLogger = Logger.getLogger(this.getClass());
    private static TimeZone myTimeZone = TimeZone.getDefault();

    protected PerformanceDataBuilder(String groupName, SortedMap filesData, boolean storeOldResults, Map techType, FileTransferListener ftpListener, PerformanceDataListener perfListener) {
        this.myTechType = groupName;
        this.myStoreOldResults = storeOldResults;
        this.myGroupMap = techType;
        if (this.myGroupMap == null) {
            this.myGroupMap = new HashMap<String, String>();
        }
        this.myPMResults = new HashMap<String, PMResultImpl>();
        if (CoreAsset.isSnapshotOpening()) {
            this.openSnapshot(ftpListener, perfListener);
        } else {
            this.myFilesData = filesData;
        }
        this.checkOlderFilesForRemoval();
        this.parseData();
        this.checkCounterErrorWhenInSnapshotMode(perfListener);
    }

    protected PerformanceDataBuilder(String techType, SortedMap filesData, boolean storeOldResults, Map groupMap) {
        this(techType, filesData, storeOldResults, groupMap, null, null);
    }

    public static void setTimeZone(TimeZone timeZone) {
        myTimeZone = timeZone;
    }

    public File getLatestCounterFile() {
        return (File)this.myFilesData.get(this.myFilesData.lastKey());
    }

    protected void processNewResult(String timeDate, File file) {
        this.myFilesData.put(timeDate, file);
        this.checkOlderFilesForRemoval();
        this.parseData();
    }

    protected PMResult[] getResults() {
        return this.myPMResults.values().toArray(new PMResult[0]);
    }

    protected Collection<PMResultImpl> getPMResults() {
        return Collections.unmodifiableCollection(this.myPMResults.values());
    }

    protected int hasCounterError() {
        Collection<PMResultImpl> data = this.getPMResults();
        boolean hasCounter = false;
        boolean isAllTRSCounters = true;
        boolean hasCellName = false;
        if (data != null) {
            for (PMResult pMResult : data) {
                if (this.hasValidCounter(hasCounter, pMResult)) {
                    hasCounter = true;
                }
                String[] stringArray = pMResult.getCellNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cellName = stringArray[n2];
                    hasCellName = true;
                    if (cellName.indexOf("FTM") < 0) {
                        isAllTRSCounters = false;
                        break;
                    }
                    ++n2;
                }
                if (!isAllTRSCounters) break;
            }
        }
        if (isAllTRSCounters && hasCellName) {
            return 1;
        }
        if (!hasCounter) {
            return 9;
        }
        return -1;
    }

    private boolean hasValidCounter(boolean hasCounter, PMResult element) {
        return !hasCounter && element.getCellNames().length > 0 && (this.myGroupMap.isEmpty() || !element.getGroupMappingName().equals("Coreasset_Unknown"));
    }

    private void checkOlderFilesForRemoval() {
        if (!this.myStoreOldResults) {
            Calendar oneDayOldCalendar = this.getOneDayOldCalendar();
            this.myLogger.debug((Object)("One day old reference date is " + new Date(oneDayOldCalendar.getTimeInMillis())));
            Iterator<String> keys = this.myFilesData.keySet().iterator();
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            while (keys.hasNext()) {
                String key = keys.next();
                if (!this.getParsedTimeDate(key).before(oneDayOldCalendar)) continue;
                toBeRemoved.add(key);
            }
            for (String key : toBeRemoved) {
                this.myLogger.debug((Object)("Removed PM entry with date " + key));
                if (!((File)this.myFilesData.get(key)).delete()) {
                    ((File)this.myFilesData.get(key)).deleteOnExit();
                }
                this.myFilesData.remove(key);
            }
        }
    }

    private Calendar getOneDayOldCalendar() {
        Calendar calendar = null;
        for (String key : this.myFilesData.keySet()) {
            Calendar c = this.getParsedTimeDate(key);
            if (calendar != null && !calendar.before(c)) continue;
            calendar = c;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.add(5, -1);
        calendar.add(12, 1);
        return calendar;
    }

    private Calendar getNewestCalendar() {
        Calendar calendar = null;
        Iterator<String> keyIter = this.myFilesData.keySet().iterator();
        while (keyIter.hasNext()) {
            Calendar c = Calendar.getInstance();
            try {
                c.setTime(this.FILE_DATE_FORMAT.parse(keyIter.next()));
            }
            catch (ParseException e) {
                this.myLogger.error((Object)"Error in the PM file, continuing to next file. ", (Throwable)e);
                continue;
            }
            if (calendar != null && !calendar.before(c)) continue;
            calendar = c;
        }
        return calendar;
    }

    private void openSnapshot(FileTransferListener ftpListener, PerformanceDataListener perfListener) {
        File pmFolder = new File(String.valueOf(CoreAsset.getSnapshotOpenLocation().getFile()) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR);
        String[] pmFiles = pmFolder.list();
        if (pmFiles == null) {
            return;
        }
        ArrayList<String> fileNameArray = new ArrayList<String>();
        ArrayList<String> fileDateTimeArray = new ArrayList<String>();
        int i = 0;
        while (i < pmFiles.length) {
            String[] parts = pmFiles[i].split("\\.");
            if (parts.length > 5) {
                String date = parts[2];
                String time = parts[3];
                String techType = parts[4];
                if (techType.equals(this.myTechType)) {
                    fileNameArray.add(String.valueOf(pmFolder.getAbsolutePath()) + CoreAsset.FILE_SEPARATOR + pmFiles[i]);
                    fileDateTimeArray.add(String.valueOf(date) + time);
                }
            }
            ++i;
        }
        File[] xmlFiles = new File[fileNameArray.size()];
        int i2 = 0;
        while (i2 < fileNameArray.size()) {
            String fileName = (String)fileNameArray.get(i2);
            xmlFiles[i2] = fileName.endsWith(".gz") ? Tools.gunZip((File)new File(fileName)) : (fileName.endsWith(".xz") ? Tools.xunZip((File)new File(fileName)) : new File(fileName));
            ++i2;
        }
        TreeMap<String, File> map = new TreeMap<String, File>();
        int i3 = 0;
        while (i3 < xmlFiles.length) {
            if (xmlFiles[i3] != null) {
                map.put((String)fileDateTimeArray.get(i3), xmlFiles[i3]);
            }
            ++i3;
        }
        if (!map.isEmpty()) {
            int size = map.size();
            perfListener.performanceDataFileAmountToFetch(size);
            ftpListener.fileSetTransferStarted();
            int i4 = 0;
            while (i4 < size) {
                try {
                    Thread.sleep(20L);
                    ftpListener.fileTransferStarted("pmFakeFile" + i4, 1000L);
                    Thread.sleep(20L);
                    ftpListener.fileTransferSucceeded("pmFakeFile" + i4);
                }
                catch (InterruptedException e) {
                    this.myLogger.warn((Object)e);
                }
                ++i4;
            }
            ftpListener.fileSetTransferCompleted(null);
        }
        this.myFilesData = map;
    }

    private void checkCounterErrorWhenInSnapshotMode(PerformanceDataListener listener) {
        int hasCounterError;
        if (CoreAsset.isSnapshotOpening() && (hasCounterError = this.hasCounterError()) != -1) {
            listener.performanceDataFailed(hasCounterError);
        }
    }

    private Calendar getParsedTimeDate(String timeDate) {
        Calendar dateTime = Calendar.getInstance();
        try {
            dateTime.setTime(this.FILE_DATE_FORMAT.parse(timeDate));
            dateTime.setLenient(true);
        }
        catch (ParseException pE) {
            this.myLogger.error((Object)("Cannot parse Calendar from filename " + timeDate + ". Will use current time."));
        }
        return dateTime;
    }

    private void parseData() {
        int timeZoneDSTMillis = 0;
        Calendar dateLowerLimit = null;
        Calendar dateUpperLimit = null;
        int success = 0;
        int ignored = 0;
        try {
            if (!this.myFilesData.isEmpty()) {
                Calendar dstCalendar = this.getParsedTimeDate(this.myFilesData.lastKey());
                dstCalendar.setTimeZone(myTimeZone);
                timeZoneDSTMillis = dstCalendar.get(16);
                this.myLogger.debug((Object)("DST offset now " + timeZoneDSTMillis));
                dateUpperLimit = this.getNewestCalendar();
                this.myLogger.debug((Object)("Newest date with DST is " + new Date(dateUpperLimit.getTimeInMillis())));
                dateLowerLimit = (Calendar)dateUpperLimit.clone();
                dateLowerLimit.add(5, -1);
                dateLowerLimit.add(12, 15);
            }
            this.myPMResults.clear();
            for (String groupMap : this.myGroupMap.values()) {
                this.myPMResults.put(groupMap, new PMResultImpl(groupMap));
            }
            this.myPMResults.put("Coreasset_Unknown", new PMResultImpl("Coreasset_Unknown"));
            for (String curKey : this.myFilesData.keySet()) {
                Calendar c = Calendar.getInstance();
                try {
                    c.setTime(this.FILE_DATE_FORMAT.parse(curKey));
                }
                catch (ParseException e) {
                    this.myLogger.error((Object)"Error in the PM file, continuing to next file. ", (Throwable)e);
                    continue;
                }
                Date dateObject = c.getTime();
                if ((c.before(dateLowerLimit) || c.after(dateUpperLimit)) && !this.myStoreOldResults) {
                    this.myLogger.trace((Object)("Stopped processing PM file, date of PM file (" + dateObject + ") is over 24h than it should."));
                    ++ignored;
                    continue;
                }
                this.myLogger.trace((Object)("Processing PM file, date (" + dateObject + ") is ok."));
                ++success;
                PMFileStAXParser parser = new PMFileStAXParser(this);
                try {
                    parser.parse((File)this.myFilesData.get(curKey));
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Error while parsing PM File data. ", (Throwable)e);
                }
            }
            if (((PMResult)this.myPMResults.get("Coreasset_Unknown")).getCellNames().length == 0) {
                this.myPMResults.remove("Coreasset_Unknown");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.myLogger.error((Object)"Cannot parse data, ", (Throwable)e);
        }
        this.myLogger.debug((Object)("Successfully parsed " + success + " PM datas, ignored " + ignored));
    }

    @Override
    public void counterData(Date startDateObject, String btsName, String cellName, String counterName, String counterValue) {
        Number value;
        try {
            value = Long.valueOf(counterValue);
        }
        catch (NumberFormatException ex) {
            try {
                value = Double.valueOf(counterValue);
            }
            catch (NumberFormatException numEx) {
                this.myLogger.error((Object)("Cannot parse data [" + counterValue + "] to a long or double value, continuing to next counter. "), (Throwable)numEx);
                return;
            }
        }
        String groupMapName = this.myGroupMap.get(counterName);
        PMResultImpl resultsImpl = groupMapName != null ? this.myPMResults.get(groupMapName) : this.myPMResults.get("Coreasset_Unknown");
        PMResultImpl.setMyBTSName(btsName);
        resultsImpl.addData(cellName, counterName, startDateObject, value);
    }

    public boolean savePMFiles(File targetFile) {
        File tempDir = PFileUtils.createTempDir((String)"PMtemp");
        ArrayList<File> fileList = new ArrayList<File>();
        for (Map.Entry<String, File> entry : this.myFilesData.entrySet()) {
            File pmFile = entry.getValue();
            File newfile = new File(String.valueOf(tempDir.getAbsolutePath()) + CoreAsset.FILE_SEPARATOR + pmFile.getName());
            try {
                PFileUtils.copyFile((File)newfile, (File)pmFile);
                fileList.add(newfile);
            }
            catch (IOException e1) {
                this.myLogger.error((Object)("Can not open PM file : " + pmFile + " and " + newfile));
                return false;
            }
        }
        try {
            PFileUtils.zip((File)targetFile, fileList);
        }
        catch (IOException e) {
            this.myLogger.error((Object)"Can not finish ZIP operation:", (Throwable)e);
            return false;
        }
        Iterator deleteIterator = fileList.iterator();
        while (deleteIterator.hasNext()) {
            PFileUtils.delete((File)((File)deleteIterator.next()));
        }
        return true;
    }

    protected void clearMyFilesData() {
        this.myFilesData.clear();
    }

    public int getFileCount() {
        return this.myFilesData.size();
    }
}

