/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.performancemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMDataListener;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMFileHandler;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMResult;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PMResultImpl;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PerformanceDataBuilder;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PerformanceDataListener;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PerformanceDataScenarioHandler;
import com.nokia.em.bts.coreasset.scenario.performancemanagement.PerformanceMonitoringScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPClientAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.PerformanceDataRequest;
import com.nokia.em.bts.rp.master.message.PerformanceDataResponse;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.log4j.Logger;

public class PerformanceDataScenario
implements Scenario {
    private Optional<PerformanceMonitoringScenarioListener> myScenarioListener = Optional.empty();
    private FileTransferListener myFtpListener;
    private BTSConnection myConnection;
    private Optional<PerformanceDataListener> myPerformanceListener;
    private PerformanceDataScenarioHandler myScenarioHandler;
    private String myTechType;
    private boolean myRunning = false;
    private boolean myExecuted = false;
    private final boolean myStoreOldResults;
    private final Map myGroupMap;
    private FileTransferClient myFileTransferClient;
    private PerformanceDataBuilder myPerformanceDataBuilder;
    private int mySeqNumber = -1;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private PMFileHandler myPMFileHandler;

    public PerformanceDataScenario(BTSConnection connection, PerformanceDataListener perfListener, FileTransferListener ftpListener, PerformanceDataScenarioHandler scenarioHandler, String techType, Map groupMap, boolean storeOldResults) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myStoreOldResults = storeOldResults;
        this.myGroupMap = groupMap;
        this.myConnection = connection;
        this.myFtpListener = ftpListener;
        this.myPerformanceListener = Optional.of(perfListener);
        this.myScenarioHandler = scenarioHandler;
        this.myScenarioHandler.setPeformanceListener(perfListener);
        this.myTechType = techType;
        this.myPMFileHandler = scenarioHandler.getPMFileHandler();
    }

    public PerformanceDataScenario(BTSConnection connection, PerformanceDataListener perfListener, FileTransferListener ftpListener, PerformanceDataScenarioHandler scenarioHandler, String techType, Map groupMap, boolean storeOldResults, BTSMessage.Type type) {
        this(connection, perfListener, ftpListener, scenarioHandler, techType, groupMap, storeOldResults);
        this.myType = type;
    }

    public PerformanceDataScenario(BTSConnection connection, PerformanceDataListener perfListener, PerformanceMonitoringScenarioListener scenarioListener, FileTransferListener ftpListener, PerformanceDataScenarioHandler scenarioHandler, String techType, Map groupMap, boolean storeOldResults, BTSMessage.Type type) {
        this(connection, perfListener, ftpListener, scenarioHandler, techType, groupMap, storeOldResults, type);
        this.myScenarioListener = Optional.ofNullable(scenarioListener);
    }

    protected void processPerformanceData(final String timeDate, final File performanceData) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return PerformanceDataScenario.this.startProcessingPerformanceData(timeDate, performanceData);
            }
        };
        worker.start();
    }

    protected Object startProcessingPerformanceData(String timeDate, File xmlFile) {
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (xmlFile == null) {
            this.myLogger.debug((Object)"Failed to process Performance Data.");
            this.informListener(l -> l.performanceDataFailed(10));
            return false;
        }
        if (this.myPerformanceDataBuilder == null || !this.isPMDataRecieved()) {
            TreeMap<String, File> map = new TreeMap<String, File>();
            map.put(timeDate, xmlFile);
            this.myPerformanceDataBuilder = new PerformanceDataBuilder(this.myTechType, map, this.myStoreOldResults, this.myGroupMap);
            this.informListener(l -> l.performanceDataFileAmountToFetch(map.size()));
        }
        this.myPerformanceDataBuilder.processNewResult(timeDate, xmlFile);
        if (this.myPerformanceDataBuilder.hasCounterError() != -1) {
            this.informListener(l -> l.performanceDataFailed(10));
            return false;
        }
        if (this.myPerformanceListener.isPresent() && this.myPerformanceListener.get() instanceof PMDataListener) {
            PMDataListener listener = (PMDataListener)this.myPerformanceListener.get();
            listener.setFileCount(this.myPerformanceDataBuilder.getFileCount());
            listener.setLatestCounterFile(this.myPerformanceDataBuilder.getLatestCounterFile());
            listener.performanceDataReceived(this.myPerformanceDataBuilder.getPMResults());
        } else {
            this.informListener(l -> l.performanceDataReceived(this.myPerformanceDataBuilder.getResults()));
        }
        return Boolean.TRUE;
    }

    protected FileTransferListener getFTPListener() {
        return this.myFtpListener;
    }

    protected void sendPerformanceDataUpdating() {
        this.myLogger.debug((Object)"Send performanceDataUpdating");
        this.informListener(l -> l.performanceDataUpdating());
    }

    protected void sendPerformanceDataFailed(int reason) {
        this.myLogger.debug((Object)("Send performanceDataFailed Reason: " + reason));
        this.informListener(l -> l.performanceDataFailed(reason));
    }

    protected void sendPerfomanceDataInitialized() {
        this.myLogger.debug((Object)"Send performanceDataInitializing");
        this.informListener(l -> l.perfomanceDataInitialized());
    }

    private void openSnapshot() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                File pmFolder = new File(String.valueOf(CoreAsset.getSnapshotOpenLocation().getFile()) + CoreAsset.FILE_SEPARATOR + "PM" + CoreAsset.FILE_SEPARATOR);
                if (!pmFolder.exists()) {
                    PerformanceDataScenario.this.informListener(l -> l.performanceDataFailed(1));
                    return false;
                }
                PerformanceDataScenario.this.myPerformanceDataBuilder = new PerformanceDataBuilder(PerformanceDataScenario.this.myTechType, null, PerformanceDataScenario.this.myStoreOldResults, PerformanceDataScenario.this.myGroupMap, PerformanceDataScenario.this.myFtpListener, (PerformanceDataListener)PerformanceDataScenario.this.myPerformanceListener.get());
                if (PerformanceDataScenario.this.myPerformanceListener.isPresent() && PerformanceDataScenario.this.myPerformanceListener.get() instanceof PMDataListener) {
                    Collection<PMResultImpl> pmResults = PerformanceDataScenario.this.myPerformanceDataBuilder.getPMResults();
                    if (pmResults.size() > 0) {
                        ((PMDataListener)PerformanceDataScenario.this.myPerformanceListener.get()).performanceDataReceived(pmResults);
                    } else {
                        PerformanceDataScenario.this.informListener(l -> l.performanceDataFailed(1));
                    }
                } else {
                    PMResult[] results = PerformanceDataScenario.this.myPerformanceDataBuilder.getResults();
                    if (results.length > 0) {
                        PerformanceDataScenario.this.informListener(l -> l.performanceDataReceived(results));
                    } else {
                        PerformanceDataScenario.this.informListener(l -> l.performanceDataFailed(1));
                    }
                }
                return true;
            }

            protected void finished() {
                super.finished();
            }
        };
        worker.start();
    }

    @Override
    public void execute() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Opening in snapshot mode.");
            this.openSnapshot();
            return;
        }
        if (this.myExecuted) {
            throw new IllegalStateException("This scenario can not be executed more than once.");
        }
        this.myExecuted = true;
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                PerformanceDataScenario.this.myScenarioListener.ifPresent(PerformanceMonitoringScenarioListener::fileFetchStarted);
                return PerformanceDataScenario.this.runScenario();
            }

            protected void finished() {
                try {
                    this.get();
                }
                catch (Exception e) {
                    PerformanceDataScenario.this.myLogger.error((Object)"Unknown error.");
                    PerformanceDataScenario.this.informListener(l -> l.performanceDataFailed(5));
                }
                PerformanceDataScenario.this.setIsRunning(false);
                PerformanceDataScenario.this.myScenarioListener.ifPresent(PerformanceMonitoringScenarioListener::fileFetchFinished);
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        try {
            this.mySeqNumber = this.myConnection.createScenario();
            PerformanceDataRequest performanceDataRequest = new PerformanceDataRequest(this.mySeqNumber, this.myType);
            this.myConnection.sendToBTS((BTSMessage)performanceDataRequest);
            this.myScenarioHandler.addPerformanceScenario(this.myTechType, this);
            BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
            this.myConnection.deleteScenario(this.mySeqNumber);
            if (response instanceof PerformanceDataResponse) {
                File[] files;
                PerformanceDataResponse performanceDataOperResponse = (PerformanceDataResponse)response;
                int operationResult = performanceDataOperResponse.getOperationResult();
                if (operationResult != -1 && operationResult != 36) {
                    if (operationResult == 1) {
                        this.informListener(l -> l.performanceDataFailed(2));
                    } else {
                        this.informListener(l -> l.performanceDataFailed(5));
                    }
                    return false;
                }
                List ftpTransferInfo = performanceDataOperResponse.getFTPTransferInformations();
                if (ftpTransferInfo.isEmpty() || ((FTPTransferInfo)ftpTransferInfo.get(0)).getFileId().equals("Coreasset_Unknown") || ((FTPTransferInfo)ftpTransferInfo.get(0)).getFileId().length() == 0) {
                    this.myLogger.debug((Object)"Empty ftpTransferInfo received");
                    this.informListener(l -> l.performanceDataFailed(1));
                    FileLoadCompleted message = new FileLoadCompleted(this.mySeqNumber, new String[0]);
                    this.myConnection.sendToBTS((BTSMessage)message);
                    return false;
                }
                this.myFileTransferClient = this.myConnection.getFileTransferFactory().getFileTransferClient();
                String serverFileName = "";
                boolean useOldFTP = this.myFileTransferClient instanceof FTPClientAdapter;
                if (useOldFTP) {
                    this.myFileTransferClient = new FTPClientAdapter((FTPTransferInfo)ftpTransferInfo.get(0));
                }
                try {
                    serverFileName = ((FTPTransferInfo)ftpTransferInfo.get(0)).getFileId();
                    ArrayList<String> fileNameArray = new ArrayList<String>();
                    ArrayList<String> fileDateTimeArray = new ArrayList<String>();
                    Iterator fileIterator = ftpTransferInfo.iterator();
                    while (fileIterator.hasNext()) {
                        String fileNameCandidate = ((FTPTransferInfo)fileIterator.next()).getFileId().trim();
                        String fileName = fileNameCandidate.substring(fileNameCandidate.lastIndexOf("/") + 1);
                        StringTokenizer tokenizer = new StringTokenizer(fileName, ".");
                        String date = "";
                        String time = "";
                        if (this.myPMFileHandler.isValidFileName(fileName) && (tokenizer.countTokens() == 8 || tokenizer.countTokens() == 7)) {
                            tokenizer.nextToken();
                            tokenizer.nextToken();
                            date = tokenizer.nextToken();
                            time = tokenizer.nextToken();
                            String fileNameEnd = String.valueOf(tokenizer.nextToken()) + "." + tokenizer.nextToken() + "." + tokenizer.nextToken();
                            if (tokenizer.hasMoreTokens()) {
                                fileNameEnd = String.valueOf(fileNameEnd) + "." + tokenizer.nextToken();
                            }
                        }
                        fileNameArray.add(fileNameCandidate);
                        fileDateTimeArray.add(String.valueOf(date) + time);
                    }
                    if (fileNameArray.size() == 0) {
                        this.informListener(l -> l.performanceDataFailed(1));
                        if (useOldFTP) {
                            try {
                                ((FTPClientAdapter)this.myFileTransferClient).disconnect();
                            }
                            catch (FtpException ftpExeption) {
                                this.myLogger.debug((Object)"Failed to close ftp client.");
                            }
                        }
                        FileLoadCompleted message = new FileLoadCompleted(this.mySeqNumber, new String[]{serverFileName});
                        this.myConnection.sendToBTS((BTSMessage)message);
                        return false;
                    }
                    this.informListener(l -> l.performanceDataFileAmountToFetch(fileNameArray.size()));
                    files = new File[fileNameArray.size()];
                    int counter = 0;
                    for (FTPTransferInfo transferInfo : ftpTransferInfo) {
                        block41: {
                            if (!fileNameArray.contains(transferInfo.getFileId().trim())) continue;
                            this.myFileTransferClient = this.myConnection.getFileTransferFactory().getFileTransferClient();
                            this.myFileTransferClient.setFTPTransferInfo(transferInfo);
                            try {
                                files[counter] = this.myFileTransferClient.getFile(this.myFtpListener);
                            }
                            catch (FileTransferException ftE) {
                                if (useOldFTP && ftE.getErrorResponseCode() != Integer.parseInt("550")) {
                                    throw ftE;
                                }
                                if (useOldFTP || ftE.getErrorResponseCode() == 404) break block41;
                                this.informListener(l -> l.performanceDataFailed(8));
                                this.myLogger.debug((Object)("Error occurred while fetching file - " + transferInfo.getFileId()));
                                return false;
                            }
                        }
                        ++counter;
                    }
                    FileLoadCompleted message = new FileLoadCompleted(this.mySeqNumber, fileNameArray);
                    this.myConnection.sendToBTS((BTSMessage)message);
                    File[] xmlFiles = new File[files.length];
                    int i = 0;
                    while (i < files.length) {
                        if (!this.isRunning()) {
                            this.informListener(l -> l.performanceDataFailed(2));
                            return false;
                        }
                        if (files[i] != null) {
                            xmlFiles[i] = this.myPMFileHandler.unzipFile(files[i]);
                            if (xmlFiles[i] != null) {
                                String fileName = this.getExtractedFilename((String)fileNameArray.get(i));
                                xmlFiles[i] = PFileUtils.renameFile((File)xmlFiles[i], (String)fileName);
                            }
                        } else {
                            xmlFiles[i] = null;
                            this.myLogger.error((Object)"Null file from FTP server, continuing to next.");
                        }
                        ++i;
                    }
                    TreeMap<String, File> map = new TreeMap<String, File>();
                    boolean isAllEmptyFile = true;
                    int i2 = 0;
                    while (i2 < files.length) {
                        File file = xmlFiles[i2];
                        if (file != null) {
                            isAllEmptyFile = false;
                            String date = (String)fileDateTimeArray.get(i2);
                            map.put(date, file);
                            this.myScenarioListener.ifPresent(c -> c.fileFetched(date, file));
                        }
                        ++i2;
                    }
                    if (isAllEmptyFile) {
                        this.informListener(l -> l.performanceDataFailed(9));
                        return false;
                    }
                    this.myPerformanceDataBuilder = new PerformanceDataBuilder(this.myTechType, map, this.myStoreOldResults, this.myGroupMap);
                }
                catch (FileTransferException ftpE) {
                    this.myLogger.error((Object)"FTP Error occurred, ", (Throwable)ftpE);
                    if (this.myConnection.isBTSConnected()) {
                        FileLoadCompleted message = new FileLoadCompleted(this.mySeqNumber, new String[]{serverFileName});
                        this.myConnection.sendToBTS((BTSMessage)message);
                    }
                    this.informListener(l -> l.performanceDataFailed(3));
                    return false;
                }
                if (this.isRunning()) {
                    int hasCounterError = this.myPerformanceDataBuilder.hasCounterError();
                    if (hasCounterError != -1) {
                        this.informListener(l -> l.performanceDataFailed(hasCounterError));
                        return false;
                    }
                    if (this.myPerformanceListener.isPresent() && this.myPerformanceListener.get() instanceof PMDataListener) {
                        ((PMDataListener)this.myPerformanceListener.get()).performanceDataReceived(this.myPerformanceDataBuilder.getPMResults());
                    } else {
                        this.informListener(l -> l.performanceDataReceived(this.myPerformanceDataBuilder.getResults()));
                    }
                }
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file != null && !file.delete()) {
                        file.deleteOnExit();
                    }
                    ++n2;
                }
            } else if (response instanceof Timeout) {
                this.myLogger.error((Object)"No reply received from BTS.");
                this.informListener(l -> l.performanceDataFailed(6));
            } else if (response == null) {
                this.informListener(l -> l.performanceDataFailed(2));
            } else {
                this.myLogger.error((Object)("Wrong reply received from BTS. PerformanceDataOperResponse expected, " + response.getClass() + " received."));
                this.informListener(l -> l.performanceDataFailed(0));
            }
            return true;
        }
        catch (Exception eee) {
            this.myLogger.error((Object)"Unknown Error occurred. ", (Throwable)eee);
            return false;
        }
    }

    private String getExtractedFilename(String archivedFileDirectory) {
        File file = new File(archivedFileDirectory);
        return PFileUtils.getFileNameWithoutExtension((File)file);
    }

    @Override
    public boolean abort() {
        if (!this.isRunning()) {
            return true;
        }
        this.myLogger.debug((Object)"unregistering listener");
        this.myPerformanceListener = Optional.empty();
        this.myLogger.debug((Object)("trying to abort performance monitoring scenario " + this.myTechType));
        this.myFtpListener = new FileTransferAdapter();
        if (this.myConnection != null) {
            this.myLogger.debug((Object)"Trying to interrupt message receiving...");
            this.myConnection.interruptScenario(this.mySeqNumber);
        }
        this.setIsRunning(false);
        this.myScenarioHandler.removePerformanceScenario(this.myTechType);
        if (this.myFileTransferClient != null) {
            this.myLogger.debug((Object)"Trying to interrupt file transfer...");
            this.myFileTransferClient.abort();
        }
        this.myLogger.debug((Object)("Performance monitoring scenario " + this.myTechType + " aborted successfully"));
        return true;
    }

    public boolean savePMFile(File targetFile) {
        if (this.myPerformanceDataBuilder == null) {
            this.myLogger.warn((Object)("PMDataBuilder is null, cannot save PM counter " + this.myTechType));
            return false;
        }
        return this.myPerformanceDataBuilder.savePMFiles(targetFile);
    }

    public void clearPMFiles() {
        if (this.myPerformanceDataBuilder != null) {
            this.myPerformanceDataBuilder.clearMyFilesData();
        }
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    public boolean isPMDataRecieved() {
        return this.myPerformanceListener.map(l -> l.isPMDataRecieved()).orElse(false);
    }

    protected synchronized void setIsRunning(boolean value) {
        this.myRunning = value;
    }

    public synchronized boolean isRunning() {
        return this.myRunning;
    }

    protected void setIsExecuted(boolean value) {
        this.myExecuted = value;
    }

    private void informListener(Consumer<PerformanceDataListener> listenerConsumer) {
        this.myPerformanceListener.ifPresent(listenerConsumer::accept);
        if (!this.myPerformanceListener.isPresent()) {
            this.myLogger.debug((Object)"skipped informing listener");
        }
    }
}

