/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.performancemanagement.parser;

import com.nokia.em.bts.coreasset.scenario.performancemanagement.parser.PMFileParserListener;
import com.nokia.em.poseidon.util.file.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class PMFileStAXParser {
    private final SimpleDateFormat DATA_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private PMFileParserListener myListener;
    private Map<String, TimeZone> myTimeZoneMap = new HashMap<String, TimeZone>();

    public PMFileStAXParser(PMFileParserListener listener) {
        this.myListener = listener;
    }

    public void parse(File xmlFile) throws Exception {
        this.doParsing(xmlFile);
    }

    private void doParsing(File xmlFile) throws Exception {
        boolean isSucceedingStartElementCounter = false;
        Date startDateObject = null;
        String startTime = "";
        String btsName = "";
        String cellName = "";
        String counterName = "";
        String counterValue = "";
        URL url = new URL("file:///" + xmlFile.getAbsolutePath());
        InputStream in = null;
        try {
            in = url.openStream();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(in);
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if ("PMSetup".equals(reader.getLocalName())) {
                            startTime = reader.getAttributeValue(null, "startTime");
                            startDateObject = this.calculateStartTime(startTime);
                            break;
                        }
                        if ("baseId".equals(reader.getLocalName()) && btsName.length() == 0) {
                            btsName = reader.getElementText();
                            break;
                        }
                        if ("localMoid".equals(reader.getLocalName())) {
                            cellName = reader.getElementText();
                            break;
                        }
                        if (reader.getLocalName().startsWith("NE-WBTS")) {
                            isSucceedingStartElementCounter = true;
                            break;
                        }
                        if (!isSucceedingStartElementCounter) break;
                        counterName = reader.getLocalName();
                        counterValue = reader.getElementText();
                        this.myListener.counterData(startDateObject, btsName, cellName, counterName, counterValue);
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().startsWith("NE-WBTS")) break;
                        isSucceedingStartElementCounter = false;
                        break;
                    }
                }
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    private Date calculateStartTime(String startTime) throws ParseException {
        TimeZone timeZoneFromPMFile = this.getTimeZoneFromPMFile(startTime);
        this.DATA_DATE_FORMAT.setTimeZone(timeZoneFromPMFile != null ? timeZoneFromPMFile : TimeZone.getTimeZone("GMT"));
        Date tempStartDateObject = this.DATA_DATE_FORMAT.parse(startTime);
        Calendar tempCalendarObject = Calendar.getInstance();
        tempCalendarObject.setLenient(true);
        tempCalendarObject.setTime(tempStartDateObject);
        Date startDateObject = tempCalendarObject.getTime();
        return startDateObject;
    }

    private TimeZone getTimeZoneFromPMFile(String startTime) {
        TimeZone timeZone = this.myTimeZoneMap.get(startTime);
        if (timeZone != null) {
            return timeZone;
        }
        String regEx = "([+-]\\d+):(\\d+):\\d+$";
        Matcher matcher = Pattern.compile(regEx).matcher(startTime);
        if (matcher.find()) {
            timeZone = TimeZone.getTimeZone("GMT" + matcher.group(1) + matcher.group(2));
            this.myTimeZoneMap.put(startTime, timeZone);
            return timeZone;
        }
        return null;
    }
}

