/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.remoteselftest;

import com.nokia.em.bts.coreasset.scenario.remoteselftest.CPU;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Board {
    private static final String CPU = "cpu";
    private static final String NAME = "name";
    private static final String PRODUCT_NUMBER = "prodNr";
    private static final String SERIAL_NUMBER = "serialNr";
    private List<CPU> myCPUs = new ArrayList<CPU>();
    private String myBoardName;
    private String myBoardSerialNumber;
    private String myBoardProductNumber;

    public Board(NodeList node) {
        this.readBoardFromNode(node);
    }

    public List<CPU> getCPUs() {
        return this.myCPUs;
    }

    public void setName(String boardName) {
        this.myBoardName = boardName;
    }

    public void setSerialNumber(String boardSerialNumber) {
        this.myBoardSerialNumber = boardSerialNumber;
    }

    public void setProductNumber(String boardProductNumber) {
        this.myBoardProductNumber = boardProductNumber;
    }

    public String generateBoardDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\nBoard");
        sb.append("\r\nName: ");
        sb.append(this.myBoardName);
        sb.append("\r\nProduct number: ");
        sb.append(this.myBoardProductNumber);
        sb.append("\r\nSerial number: ");
        sb.append(this.myBoardSerialNumber);
        for (CPU cpu : this.myCPUs) {
            sb.append(cpu.generateCPUDetails());
        }
        return sb.toString();
    }

    private void readBoardFromNode(NodeList node) {
        int j = 0;
        while (j < node.getLength()) {
            Node childNode2 = node.item(j);
            if (NAME.equals(childNode2.getNodeName())) {
                this.setName(childNode2.getFirstChild().getNodeValue().trim());
            } else if (PRODUCT_NUMBER.equals(childNode2.getNodeName())) {
                this.setProductNumber(childNode2.getFirstChild().getNodeValue().trim());
            } else if (SERIAL_NUMBER.equals(childNode2.getNodeName())) {
                this.setSerialNumber(childNode2.getFirstChild().getNodeValue().trim());
            } else if (CPU.equals(childNode2.getNodeName())) {
                NodeList n2List = childNode2.getChildNodes();
                CPU cpu = new CPU(n2List);
                this.getCPUs().add(cpu);
            }
            ++j;
        }
    }
}

