/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.remoteselftest;

import com.nokia.em.bts.coreasset.message.ActiveTestListRequest;
import com.nokia.em.bts.coreasset.message.ActiveTestListResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.remoteselftest.RemoteSelfTestActiveTestListScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;

public class RemoteSelfTestActiveTestListScenario
implements Scenario {
    private BTSConnection myConnection;
    private RemoteSelfTestActiveTestListScenarioListener myScenarioListener;
    private ActiveTestListRequest myRequest;
    private CoreAssetThread myScenarioWorker;
    private int mySequenceNumber;
    private boolean myIsRunning;

    public RemoteSelfTestActiveTestListScenario(BTSConnection connection, RemoteSelfTestActiveTestListScenarioListener scenarioListener) {
        this.myConnection = connection;
        this.myScenarioListener = scenarioListener;
        this.setIsRunning(false);
    }

    @Override
    public void execute() {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot execute RemoteSelfTestActiveTestListScenario because it's currently running.");
        }
        this.setIsRunning(true);
        this.myScenarioWorker = new CoreAssetThread(){

            protected Object construct() {
                return RemoteSelfTestActiveTestListScenario.this.runScenario();
            }

            protected void finished() {
                RemoteSelfTestActiveTestListScenario.this.myConnection.deleteScenario(RemoteSelfTestActiveTestListScenario.this.getSequenceNumber());
                RemoteSelfTestActiveTestListScenario.this.setIsRunning(false);
            }
        };
        this.myScenarioWorker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected Object runScenario() {
        this.myScenarioListener.activeTestListRequestStarted();
        this.setSequenceNumber(this.myConnection.createScenario());
        this.myRequest = new ActiveTestListRequest(this.getSequenceNumber());
        this.myConnection.sendToBTS((BTSMessage)this.myRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.getSequenceNumber(), 60000L);
        if (response instanceof ActiveTestListResponse) {
            ActiveTestListResponse activeTestListResponse = (ActiveTestListResponse)response;
            this.myScenarioListener.activeTestListRequestSucceeded(activeTestListResponse.getActiveTests().isEmpty());
        } else if (response instanceof Timeout) {
            this.myScenarioListener.activeTestListRequestFailed(1);
        } else {
            this.myScenarioListener.activeTestListRequestFailed(2);
        }
        return true;
    }

    public boolean isRunning() {
        return this.myIsRunning;
    }

    public void setIsRunning(boolean isRunning) {
        this.myIsRunning = isRunning;
    }

    public CoreAssetThread getScenarioWorker() {
        return this.myScenarioWorker;
    }

    public int getSequenceNumber() {
        return this.mySequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.mySequenceNumber = sequenceNumber;
    }

    public ActiveTestListRequest getRequest() {
        return this.myRequest;
    }
}

