/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.remoteselftest;

import com.nokia.em.bts.coreasset.scenario.remoteselftest.Board;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoteSelfTestDetails {
    private static final String NAME = "name";
    private static final String PRODUCT_NUMBER = "prodNr";
    private static final String SERIAL_NUMBER = "serialNr";
    private static final String MODULE = "module";
    private static final String SUMMARY = "summary";
    private static final String TIME_STAMP = "timestamp";
    private static final String TEST_RESULT = "testresult";
    private static final String BOARD = "board";
    private String myName = null;
    private String myProductNumber = null;
    private String mySerialNumber = null;
    private String myTimeStamp = null;
    private String myTestResult = null;
    private List<Board> myBoards = new ArrayList<Board>();

    public RemoteSelfTestDetails(NodeList node) {
        this.readSelfTestDetailsFromNode(node);
    }

    public String getMyName() {
        return this.myName;
    }

    public void setMyName(String name) {
        this.myName = name;
    }

    public String getMyProductNumber() {
        return this.myProductNumber;
    }

    public void setMyProductNumber(String productNumber) {
        this.myProductNumber = productNumber;
    }

    public String getMySerialNumber() {
        return this.mySerialNumber;
    }

    public void setMySerialNumber(String serialNumber) {
        this.mySerialNumber = serialNumber;
    }

    public String getMyTimeStamp() {
        return this.myTimeStamp;
    }

    public void setMyTimeStamp(String timeStamp) {
        this.myTimeStamp = timeStamp;
    }

    public String getMyTestResult() {
        return this.myTestResult;
    }

    public void setMyTestResult(String testResult) {
        this.myTestResult = testResult;
    }

    public List<Board> getMyBoards() {
        return this.myBoards;
    }

    public void setMyBoards(List<Board> boards) {
        this.myBoards = boards;
    }

    public String generateSelfTestDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("Module");
        sb.append("\r\nName: ");
        sb.append(this.myName);
        sb.append("\r\nProduct number: ");
        sb.append(this.myProductNumber);
        sb.append("\r\nSerial number: ");
        sb.append(this.mySerialNumber);
        sb.append("\r\n");
        sb.append("\r\nSummary");
        sb.append("\r\nTime: ");
        sb.append(this.myTimeStamp);
        sb.append("\r\nTest result: ");
        sb.append(this.myTestResult);
        sb.append("\r\n");
        for (Board board : this.myBoards) {
            sb.append(board.generateBoardDetails());
        }
        return sb.toString();
    }

    private void readSelfTestDetailsFromNode(NodeList node) {
        int i = 0;
        while (i < node.getLength()) {
            Node childNode2;
            NodeList n1List;
            Node childNode = node.item(i);
            if (MODULE.equals(childNode.getNodeName())) {
                n1List = childNode.getChildNodes();
                int j = 0;
                while (j < n1List.getLength()) {
                    childNode2 = n1List.item(j);
                    if (NAME.equals(childNode2.getNodeName())) {
                        this.setMyName(childNode2.getFirstChild().getNodeValue().trim());
                    } else if (PRODUCT_NUMBER.equals(childNode2.getNodeName())) {
                        this.setMyProductNumber(childNode2.getFirstChild().getNodeValue().trim());
                    } else if (SERIAL_NUMBER.equals(childNode2.getNodeName())) {
                        this.setMySerialNumber(childNode2.getFirstChild().getNodeValue().trim());
                    }
                    ++j;
                }
            } else if (SUMMARY.equals(childNode.getNodeName())) {
                n1List = childNode.getChildNodes();
                int j = 0;
                while (j < n1List.getLength()) {
                    childNode2 = n1List.item(j);
                    if (TIME_STAMP.equals(childNode2.getNodeName())) {
                        this.setMyTimeStamp(childNode2.getFirstChild().getNodeValue().trim());
                    } else if (TEST_RESULT.equals(childNode2.getNodeName())) {
                        this.setMyTestResult(childNode2.getFirstChild().getNodeValue().trim());
                    }
                    ++j;
                }
            } else if (BOARD.equals(childNode.getNodeName())) {
                n1List = childNode.getChildNodes();
                Board board = new Board(n1List);
                this.getMyBoards().add(board);
            }
            ++i;
        }
    }
}

