/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.remoteselftest;

import com.nokia.em.bts.coreasset.message.FileLoadRequest;
import com.nokia.em.bts.coreasset.message.SelfTestReportRequest;
import com.nokia.em.bts.coreasset.message.SelfTestReportResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.remoteselftest.RemoteSelfTestDetails;
import com.nokia.em.bts.coreasset.scenario.remoteselftest.RemoteSelfTestDetailsParser;
import com.nokia.em.bts.coreasset.scenario.remoteselftest.RemoteSelfTestReportScenarioListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileUtils;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.FileLoadPrepare;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.io.File;
import org.apache.log4j.Logger;

public class RemoteSelfTestReportScenario
implements Scenario {
    private BTSConnection myConnection;
    private RemoteSelfTestReportScenarioListener myScenarioListener;
    private SelfTestReportRequest myRequest;
    private CoreAssetThread myScenarioWorker;
    private int mySequenceNumber;
    private boolean myIsRunning;
    private boolean myIsLastMessage;
    private Logger myLogger = Logger.getLogger(RemoteSelfTestReportScenario.class);
    protected FileTransferClient myFtpClientAdapter;
    private Object objectLock = new Object();
    private boolean myIsOngoingReceive = false;
    protected static final int ABORT_TIMEOUT = 30000;

    public RemoteSelfTestReportScenario(BTSConnection connection, RemoteSelfTestReportScenarioListener scenarioListener) {
        this.myConnection = connection;
        this.myScenarioListener = scenarioListener;
        this.myIsRunning = false;
    }

    @Override
    public void execute() {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot execute RemoteSelfTestReportScenario because it's currently running.");
        }
        this.myIsRunning = true;
        this.myScenarioWorker = new CoreAssetThread(){

            protected Object construct() {
                return RemoteSelfTestReportScenario.this.runScenario();
            }

            protected void finished() {
                RemoteSelfTestReportScenario.this.myConnection.deleteScenario(RemoteSelfTestReportScenario.this.getSequenceNumber());
                RemoteSelfTestReportScenario.this.myIsRunning = false;
            }
        };
        this.myScenarioWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abort() {
        if (!this.myIsRunning) {
            return true;
        }
        if (this.myConnection == null) {
            this.myLogger.debug((Object)"BTS connection or File transfer listener is null");
            return true;
        }
        try {
            this.myFtpClientAdapter.abort();
        }
        catch (Exception e) {
            this.myLogger.debug((Object)"Error in cancelling technical log files creation: ", (Throwable)e);
        }
        if (!this.myIsOngoingReceive) {
            this.myIsOngoingReceive = true;
            this.myConnection.receiveFromBTS(this.mySequenceNumber, 30000L);
            Object object = this.objectLock;
            synchronized (object) {
                this.objectLock.notify();
            }
            this.myIsOngoingReceive = false;
        } else {
            Object object = this.objectLock;
            synchronized (object) {
                try {
                    this.objectLock.wait(30000L);
                }
                catch (Exception e) {
                    this.myLogger.debug((Object)"Failed waiting for Ack ", (Throwable)e);
                }
            }
        }
        this.myConnection.interruptScenario(this.mySequenceNumber);
        this.myConnection.deleteScenario(this.mySequenceNumber);
        this.myLogger.debug((Object)"Abort called.");
        return true;
    }

    protected Object runScenario() {
        this.setSequenceNumber(this.myConnection.createScenario());
        this.myRequest = new SelfTestReportRequest(this.getSequenceNumber());
        this.myIsLastMessage = false;
        this.myConnection.sendToBTS((BTSMessage)this.myRequest);
        this.myIsOngoingReceive = true;
        BTSMessage response = this.myConnection.receiveFromBTS(this.getSequenceNumber(), 300000L);
        this.myIsOngoingReceive = false;
        if (response instanceof SelfTestReportResponse) {
            SelfTestReportResponse selfTestReportResponse = (SelfTestReportResponse)response;
            if (selfTestReportResponse.getReportList().isEmpty()) {
                this.myScenarioListener.selfTestReportRequestFailed(3);
                return false;
            }
            this.myScenarioListener.selfTestReportRequestSucceeded(selfTestReportResponse.getReportList());
            return this.isTestDetailsRequestSuccessful();
        }
        if (response instanceof Timeout) {
            this.myScenarioListener.selfTestReportRequestFailed(1);
        } else {
            this.myScenarioListener.selfTestReportRequestFailed(2);
        }
        return false;
    }

    public boolean isRunning() {
        return this.myIsRunning;
    }

    public CoreAssetThread getScenarioWorker() {
        return this.myScenarioWorker;
    }

    public int getSequenceNumber() {
        return this.mySequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.mySequenceNumber = sequenceNumber;
    }

    public SelfTestReportRequest getRequest() {
        return this.myRequest;
    }

    private boolean isTestDetailsRequestSuccessful() {
        this.myConnection.sendToBTS((BTSMessage)new FileLoadRequest(this.mySequenceNumber, 144));
        boolean isFileTransferSuccessful = false;
        while (!this.myIsLastMessage) {
            this.myIsOngoingReceive = true;
            BTSMessage response = this.myConnection.receiveFromBTS(this.mySequenceNumber);
            this.myIsOngoingReceive = false;
            if (response instanceof FileLoadPrepare) {
                isFileTransferSuccessful = this.processFileLoadPrepare(response);
                if (isFileTransferSuccessful) continue;
                break;
            }
            this.myLogger.error((Object)("Wrong reply received from BTS. FileLoadPrepare expected, " + response + " received."));
            this.myScenarioListener.selfTestReportRequestFailed(2);
            return false;
        }
        return isFileTransferSuccessful;
    }

    private boolean processFileLoadPrepare(BTSMessage response) {
        FileLoadPrepare fileLoadPrepare = (FileLoadPrepare)response;
        if (fileLoadPrepare.getCause() == 36 || fileLoadPrepare.getCause() == -1) {
            if (fileLoadPrepare.getFTPTransferInfo().size() > 0) {
                this.processFtpTransferInfo((FTPTransferInfo)fileLoadPrepare.getFTPTransferInfo().get(0));
            }
            if (fileLoadPrepare.isLastFile()) {
                this.myIsLastMessage = true;
                this.myScenarioListener.selfTestResultRequestSucceded();
            }
            return true;
        }
        this.myLogger.debug((Object)"FileLoadPrepare with unsuccessful _cause was received.");
        this.myScenarioListener.selfTestReportRequestFailed(28);
        return false;
    }

    private void processFtpTransferInfo(FTPTransferInfo ftpInfo) {
        File fetchedFile = null;
        String strFileId = ftpInfo.getFileId();
        if (strFileId != null && strFileId.trim().length() != 0) {
            String fileToBeTransferred = strFileId.trim();
            try {
                this.myFtpClientAdapter = this.myConnection.getFileTransferFactory().getFileTransferClient();
                this.myFtpClientAdapter.setFTPTransferInfo(ftpInfo);
                fetchedFile = this.myFtpClientAdapter.getFile(null);
            }
            catch (FileTransferException e) {
                this.myLogger.error((Object)"Fetching BTS log file error.", (Throwable)e);
            }
            FileLoadCompleted message = LogFileUtils.createFileLoadComplete(this.mySequenceNumber, fileToBeTransferred);
            if (fetchedFile != null) {
                this.handleFileReceived(fetchedFile, fileToBeTransferred);
            }
            this.myConnection.sendToBTS((BTSMessage)message);
        } else {
            this.myLogger.debug((Object)"Null fileId received, aborting.");
        }
    }

    private void handleFileReceived(File fetchedFile, String fileToBeTransferred) {
        String serialNumber = this.extractSerialNumberFromFileName(fileToBeTransferred);
        String resultDetails = this.parseFile(fetchedFile);
        if (resultDetails != null) {
            this.myScenarioListener.selfTestResultRequestItemSucceeded(serialNumber, resultDetails);
        }
    }

    private String extractSerialNumberFromFileName(String fileToBeTransferred) {
        return fileToBeTransferred.split("_")[2];
    }

    private String parseFile(File fetchedFile) {
        RemoteSelfTestDetailsParser details = new RemoteSelfTestDetailsParser();
        RemoteSelfTestDetails selfTestDetails = details.parseFile(fetchedFile);
        if (selfTestDetails != null) {
            return selfTestDetails.generateSelfTestDetails();
        }
        return null;
    }
}

