/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.remoteselftest;

import com.nokia.em.bts.coreasset.message.StartTestRequest;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.remoteselftest.RemoteSelfTestStartTestScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;

public class RemoteSelfTestStartTestScenario
implements Scenario {
    private static final String TEST_TYPE = "SelfTest";
    private BTSConnection myConnection;
    private RemoteSelfTestStartTestScenarioListener myScenarioListener;
    private String myTestParameters = "";
    private StartTestRequest myRequest;
    private CoreAssetThread myWorker;
    private int mySequenceNumber;
    private boolean myRunningStatus;

    public RemoteSelfTestStartTestScenario(BTSConnection connection, RemoteSelfTestStartTestScenarioListener scenarioListener) {
        this.myConnection = connection;
        this.myScenarioListener = scenarioListener;
    }

    public RemoteSelfTestStartTestScenario(BTSConnection connection, RemoteSelfTestStartTestScenarioListener scenarioListener, String testParameters) {
        this(connection, scenarioListener);
        this.myTestParameters = testParameters;
    }

    @Override
    public void execute() {
        if (this.myRunningStatus) {
            throw new IllegalStateException("Cannot execute RemoteSelfTestStartTestScenario because it's currently running.");
        }
        this.myRunningStatus = true;
        this.myWorker = new CoreAssetThread(){

            protected void finished() {
                RemoteSelfTestStartTestScenario.this.myConnection.deleteScenario(RemoteSelfTestStartTestScenario.this.getSequenceNumber());
                RemoteSelfTestStartTestScenario.this.myRunningStatus = false;
            }

            protected Object construct() {
                return RemoteSelfTestStartTestScenario.this.runScenario();
            }
        };
        this.myWorker.start();
    }

    protected Object runScenario() {
        this.myScenarioListener.startTestRequestStarted();
        this.setSequenceNumber(this.myConnection.createScenario());
        this.myRequest = this.myTestParameters != null && !this.myTestParameters.isEmpty() ? new StartTestRequest(this.getSequenceNumber(), TEST_TYPE, this.myTestParameters) : new StartTestRequest(this.getSequenceNumber(), TEST_TYPE);
        this.myConnection.sendToBTS((BTSMessage)this.myRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.getSequenceNumber(), 150000L);
        if (response instanceof StartTestResponse) {
            StartTestResponse selfTestReportResponse = (StartTestResponse)response;
            if (selfTestReportResponse.getSuccessCode() == 34) {
                this.myScenarioListener.startTestRequestSucceeded();
            } else if (selfTestReportResponse.getSuccessCode() == 103) {
                this.myScenarioListener.startTestRequestFailed(0);
            }
        } else if (response instanceof Timeout) {
            this.myScenarioListener.startTestRequestFailed(1);
        } else if (this.myConnection.isBTSConnected()) {
            this.myScenarioListener.startTestRequestFailed(2);
        } else {
            this.myScenarioListener.startTestRequestSucceeded();
        }
        return true;
    }

    @Override
    public boolean abort() {
        return true;
    }

    public boolean isRunning() {
        return this.myRunningStatus;
    }

    public CoreAssetThread getScenarioWorker() {
        return this.myWorker;
    }

    public int getSequenceNumber() {
        return this.mySequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.mySequenceNumber = sequenceNumber;
    }

    public StartTestRequest getRequest() {
        return this.myRequest;
    }
}

