/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.reset;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ConfigurationResetRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ResetListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ConfigurationResetScenario
implements Scenario {
    protected ResetListener myResetListener;
    protected int myId = -1;
    protected BTSConnection myBTSConnection;
    protected boolean myRunning;
    private Logger myLogger;
    protected BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ConfigurationResetScenario(BTSConnection btsConnection, ResetListener resetListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myResetListener = resetListener;
        this.myBTSConnection = btsConnection;
        this.myRunning = false;
    }

    public ConfigurationResetScenario(BTSConnection btsConnection, ResetListener resetListener, BTSMessage.Type type) {
        this(btsConnection, resetListener);
        this.myType = type;
    }

    public ConfigurationResetScenario(BTSConnection btsConnection, ResetListener resetListener, int id) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myResetListener = resetListener;
        this.myId = id;
        this.myBTSConnection = btsConnection;
        this.myRunning = false;
    }

    public ConfigurationResetScenario(BTSConnection btsConnection, ResetListener resetListener, int id, BTSMessage.Type type) {
        this(btsConnection, resetListener, id);
        this.myType = type;
    }

    protected ConfigurationResetRequest createConfigurationResetRequest(int seqNumber) {
        return this.myId == -1 ? new ConfigurationResetRequest(seqNumber, this.myType) : new ConfigurationResetRequest(seqNumber, this.myId, this.myType);
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Scenario already executing.");
        }
        this.myRunning = true;
        CoreAssetThread resetWorker = new CoreAssetThread(){
            int seqNumber;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    ConfigurationResetScenario.this.myLogger.debug((Object)"Not supported while opening snapshot.");
                    ConfigurationResetScenario.this.myResetListener.resetFailed(85);
                    return true;
                }
                this.seqNumber = ConfigurationResetScenario.this.myBTSConnection.createScenario();
                ConfigurationResetRequest resetRequest = ConfigurationResetScenario.this.createConfigurationResetRequest(this.seqNumber);
                ConfigurationResetScenario.this.myBTSConnection.sendToBTS((BTSMessage)resetRequest);
                BTSMessage response = ConfigurationResetScenario.this.myBTSConnection.receiveFromBTS(this.seqNumber, 480000L);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        ConfigurationResetScenario.this.myResetListener.resetFailed(ackResponse.getNackReason());
                    } else {
                        ConfigurationResetScenario.this.myResetListener.resetStarted();
                    }
                } else if (response instanceof Timeout) {
                    ConfigurationResetScenario.this.myResetListener.resetFailed(68);
                } else {
                    if (response != null) {
                        ConfigurationResetScenario.this.myLogger.debug((Object)("Received message " + response.getClass() + " instead of Ack"));
                    } else {
                        ConfigurationResetScenario.this.myLogger.debug((Object)"Null message received instead of Ack, maybe lost connection.");
                    }
                    ConfigurationResetScenario.this.myResetListener.resetFailed(28);
                }
                return true;
            }

            protected void finished() {
                ConfigurationResetScenario.this.myBTSConnection.deleteScenario(this.seqNumber);
                try {
                    this.get();
                }
                catch (Exception e) {
                    ConfigurationResetScenario.this.myLogger.error((Object)"Unknown error.", (Throwable)e);
                }
                ConfigurationResetScenario.this.myRunning = false;
            }
        };
        resetWorker.start();
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"This scenario cannot be aborted.");
        return false;
    }
}

