/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.serviceaccount;

import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.serviceaccount.DefaultServiceAccessFailEvent;
import com.nokia.em.bts.coreasset.scenario.serviceaccount.DefaultServiceAccessStartEvent;
import com.nokia.em.bts.coreasset.scenario.serviceaccount.DefaultServiceAccessSuccessEvent;
import com.nokia.em.bts.coreasset.scenario.serviceaccount.ServiceAccessCallBack;
import com.nokia.em.bts.coreasset.scenario.serviceaccount.ServiceAccessPasswordCredentials;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.ModifyUserRequest;
import com.nokia.em.bts.rp.master.message.ModifyUserResponse;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;

public class ServiceAccessChangePasswordScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private String myUsername;
    private String myOldPassword;
    private String myNewPassword;
    private ServiceAccessCallBack mySendRequestCallBack;

    public ServiceAccessChangePasswordScenario(BTSConnection btsConnection, ServiceAccessCallBack sendRequestCallBack, ServiceAccessPasswordCredentials changePasswordDetails) {
        this.handleNullValues(btsConnection, sendRequestCallBack, changePasswordDetails);
        this.myBTSConnection = btsConnection;
        this.mySendRequestCallBack = sendRequestCallBack;
        this.myUsername = changePasswordDetails.getUserName();
        this.myOldPassword = changePasswordDetails.getOldPassword();
        this.myNewPassword = changePasswordDetails.getNewPassword();
    }

    @Override
    public void execute() {
        CoreAssetThread executor = new CoreAssetThread(){

            protected Object construct() throws Exception {
                return ServiceAccessChangePasswordScenario.this.runScenario();
            }
        };
        executor.start();
    }

    @Override
    public boolean abort() {
        return false;
    }

    protected boolean runScenario() {
        int sequenceNo = this.myBTSConnection.createScenario();
        this.sendModificationRequest(sequenceNo);
        return this.handleBTSResponse(sequenceNo);
    }

    private void handleNullValues(BTSConnection btsConnection, ServiceAccessCallBack sendRequestCallback, ServiceAccessPasswordCredentials changePasswordDetails) {
        if (btsConnection == null || sendRequestCallback == null || changePasswordDetails == null) {
            throw new IllegalArgumentException();
        }
    }

    private void sendModificationRequest(int sequenceNo) {
        ModifyUserRequest modifyUserRequest = new ModifyUserRequest(sequenceNo, this.myUsername, this.myOldPassword, this.myNewPassword);
        this.mySendRequestCallBack.onStart(new DefaultServiceAccessStartEvent());
        this.myBTSConnection.sendToBTS((BTSMessage)modifyUserRequest);
    }

    private boolean handleBTSResponse(int sequenceNo) {
        BTSMessage btsMessage = this.myBTSConnection.receiveFromBTS(sequenceNo, 60000L);
        this.myBTSConnection.deleteScenario(sequenceNo);
        if (btsMessage instanceof ModifyUserResponse) {
            return this.handleModifyUserResponse((ModifyUserResponse)btsMessage);
        }
        if (btsMessage instanceof Timeout) {
            this.mySendRequestCallBack.onFail(new DefaultServiceAccessFailEvent(68));
            return false;
        }
        this.mySendRequestCallBack.onFail(new DefaultServiceAccessFailEvent(28));
        return false;
    }

    private boolean handleModifyUserResponse(ModifyUserResponse modifyUserResponse) {
        if (modifyUserResponse.getSuccessCode() == 34) {
            this.mySendRequestCallBack.onSuccess(new DefaultServiceAccessSuccessEvent());
            return true;
        }
        if (this.isValidResponseCode(modifyUserResponse.getSuccessCode())) {
            this.mySendRequestCallBack.onFail(new DefaultServiceAccessFailEvent(modifyUserResponse.getSuccessCode(), modifyUserResponse.getErrorText(), modifyUserResponse.getHwResource()));
            return false;
        }
        this.mySendRequestCallBack.onFail(new DefaultServiceAccessFailEvent(28));
        return false;
    }

    private boolean isValidResponseCode(int responseCode) {
        return responseCode == 75 || responseCode == 76 || responseCode == 138;
    }
}

