/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.softwaremanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.SWRollbackReply;
import com.nokia.em.bts.coreasset.message.SWRollbackRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.SWRollbackListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class SWRollbackScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private Logger myLogger;
    private SWRollbackListener mySWRollbackListener;
    private boolean myRunning;
    private boolean myAborted;
    private int mySeqNbr;
    private static final int ROLLBACK_REPLY_TIMEOUT = 240000;
    public static final String RESPONSE_TIMEOUT = "responseTimeout";
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SWRollbackScenario(BTSConnection btsConnection, SWRollbackListener listener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = btsConnection;
        this.mySWRollbackListener = listener;
        this.myRunning = false;
    }

    public SWRollbackScenario(BTSConnection btsConnection, SWRollbackListener listener, BTSMessage.Type type) {
        this(btsConnection, listener);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SWRollbackScenario.this.runScenario();
            }

            protected void finished() {
                SWRollbackScenario.this.myBTSConnection.deleteScenario(SWRollbackScenario.this.mySeqNbr);
                SWRollbackScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            this.myBTSConnection.interruptScenario(this.mySeqNbr);
        }
        return true;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Operation is not supported in snapshot model.");
            this.mySWRollbackListener.rollbackFailed(85);
            return null;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        SWRollbackRequest request = new SWRollbackRequest(this.mySeqNbr, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)request);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (ack.getAck()) {
                response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 240000L);
                if (response instanceof SWRollbackReply) {
                    SWRollbackReply rollbackResponse = (SWRollbackReply)response;
                    int result = rollbackResponse.getResult();
                    if (result == 36) {
                        this.myLogger.debug((Object)"SW roll back is successful.");
                        this.mySWRollbackListener.rollbackSuccessful();
                    } else {
                        this.myLogger.debug((Object)"SW roll back failed.");
                        String error = rollbackResponse.getError();
                        if (error == null) {
                            this.mySWRollbackListener.rollbackFailed(result);
                        } else {
                            this.mySWRollbackListener.rollbackFailed(result, error);
                        }
                    }
                } else if (response instanceof Timeout) {
                    this.myLogger.error((Object)"There is no response from BTS");
                    this.mySWRollbackListener.rollbackFailed(68, RESPONSE_TIMEOUT);
                } else if (response == null) {
                    if (this.myAborted) {
                        this.myLogger.debug((Object)"Aborted by user.");
                    } else {
                        this.myLogger.debug((Object)"Null message, connection lost.");
                        this.mySWRollbackListener.rollbackFailed(87);
                    }
                } else {
                    this.myLogger.error((Object)"Invalid message from BTS.");
                    this.mySWRollbackListener.rollbackFailed(28);
                }
            } else {
                int reason = ack.getNackReason();
                this.myLogger.debug((Object)("SW roll back rejected, reason = " + reason));
                this.mySWRollbackListener.rollbackRejected(reason);
            }
        } else if (response instanceof Timeout) {
            this.myLogger.error((Object)"There is no response from BTS.");
            this.mySWRollbackListener.rollbackFailed(68);
        } else if (response == null) {
            if (this.myAborted) {
                this.myLogger.debug((Object)"Aborted by user.");
            } else {
                this.myLogger.debug((Object)"Null message, connection lost.");
                this.mySWRollbackListener.rollbackFailed(87);
            }
        } else {
            this.myLogger.error((Object)"Invalid message from BTS.");
            this.mySWRollbackListener.rollbackFailed(28);
        }
        return null;
    }
}

