/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.softwaremanagement;

import com.nokia.em.bts.coreasset.message.SWUpdateReportRequest;
import com.nokia.em.bts.coreasset.message.SWUpdateReportResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.SWOperationFTPListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class SWUpdateReportScenario
implements Scenario {
    private FileTransferListener myFtpListener;
    private BTSConnection myConnection;
    private Logger myLogger;
    private FileTransferClient myFTPClient;
    private int mySeqNumber;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SWUpdateReportScenario(BTSConnection btsConnection, FileTransferListener fileTransferListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = btsConnection;
        this.myFtpListener = fileTransferListener;
    }

    public SWUpdateReportScenario(BTSConnection btsConnection, FileTransferListener fileTransferListener, BTSMessage.Type type) {
        this(btsConnection, fileTransferListener);
        this.myType = type;
    }

    @Override
    public void execute() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                SWUpdateReportScenario.this.mySeqNumber = SWUpdateReportScenario.this.myConnection.createScenario();
                SWUpdateReportRequest reportRequest = new SWUpdateReportRequest(SWUpdateReportScenario.this.mySeqNumber, SWUpdateReportScenario.this.myType);
                SWUpdateReportScenario.this.myConnection.sendToBTS((BTSMessage)reportRequest);
                BTSMessage response = SWUpdateReportScenario.this.myConnection.receiveFromBTS(SWUpdateReportScenario.this.mySeqNumber);
                if (response instanceof SWUpdateReportResponse) {
                    SWUpdateReportScenario.this.myLogger.debug((Object)"SW update report response received.");
                    SWUpdateReportResponse reportResponse = (SWUpdateReportResponse)response;
                    FTPTransferInfo ftpTransferInfo = reportResponse.getFTPInformation();
                    if (ftpTransferInfo == null || ftpTransferInfo.getFileId() == null || ftpTransferInfo.getFileId().trim().length() < 1) {
                        SWUpdateReportScenario.this.myFtpListener.fileTransferFailed("Coreasset_Unknown");
                        return null;
                    }
                    SWUpdateReportScenario.this.myFTPClient = SWUpdateReportScenario.this.myConnection.getFileTransferFactory().getFileTransferClient();
                    SWUpdateReportScenario.this.myFTPClient.setFTPTransferInfo(ftpTransferInfo);
                    try {
                        SWOperationFTPListener localFTPListener = new SWOperationFTPListener(SWUpdateReportScenario.this.myFtpListener);
                        SWUpdateReportScenario.this.myFTPClient.getFile((FileTransferListener)localFTPListener);
                    }
                    catch (FileTransferException e) {
                        SWUpdateReportScenario.this.myLogger.error((Object)"Cannot get file.", (Throwable)e);
                        SWUpdateReportScenario.this.myFtpListener.fileTransferFailed(ftpTransferInfo.getFileId());
                    }
                    SWUpdateReportScenario.this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(SWUpdateReportScenario.this.mySeqNumber, new String[]{ftpTransferInfo.getFileId()}));
                } else {
                    SWUpdateReportScenario.this.myLogger.debug((Object)"SWReport get failed, invalid message or connection lost.");
                    SWUpdateReportScenario.this.myFtpListener.fileTransferFailed("Coreasset_Unknown");
                }
                return null;
            }

            protected void finished() {
                SWUpdateReportScenario.this.myConnection.deleteScenario(SWUpdateReportScenario.this.mySeqNumber);
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myFtpListener = new FileTransferAdapter();
        if (this.myConnection != null) {
            this.myLogger.debug((Object)"Trying to interrupt message receiving...");
            this.myConnection.interruptScenario(this.mySeqNumber);
        }
        if (this.myFTPClient != null) {
            this.myFTPClient.abort();
        }
        return true;
    }
}

