/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.softwaremanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.DownloadProgressNotif;
import com.nokia.em.bts.coreasset.message.SWDLPhaseCompletedNotif;
import com.nokia.em.bts.coreasset.message.SWUpToDate;
import com.nokia.em.bts.coreasset.message.SWUpdateInterruptRequest;
import com.nokia.em.bts.coreasset.message.SWUpdateRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.ResetCoverageAdapter;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.ResetCoverageListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.io.File;
import org.apache.log4j.Logger;

public class SWUpdateScenario
implements Scenario {
    private FileTransferListener myFtpListener;
    private ResetCoverageListener myResetCoverageListener;
    private BTSConnection myConnection;
    private int mySeqNumber;
    private boolean myExecuted = false;
    private File mySWFile;
    private boolean myAutomaticActivation;
    private boolean myAckToStartReceived;
    private boolean myInterruptMessageRequired = false;
    private boolean myAborted = false;
    private Logger myLogger;
    private FileTransferServer myServer;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SWUpdateScenario(BTSConnection connection, FileTransferListener ftpListener, File swFile, boolean automaticActivation) {
        this(connection, ftpListener, new ResetCoverageAdapter(), swFile, automaticActivation);
    }

    public SWUpdateScenario(BTSConnection connection, FileTransferListener ftpListener, File swFile, boolean automaticActivation, BTSMessage.Type type) {
        this(connection, ftpListener, new ResetCoverageAdapter(), swFile, automaticActivation);
        this.myType = type;
    }

    public SWUpdateScenario(BTSConnection connection, FileTransferListener ftpListener, ResetCoverageListener resetCoverageListener, File swFile, boolean automaticActivation) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFtpListener = ftpListener;
        this.myResetCoverageListener = resetCoverageListener;
        this.mySWFile = swFile;
        this.myAutomaticActivation = automaticActivation;
        this.myAckToStartReceived = false;
    }

    public SWUpdateScenario(BTSConnection connection, FileTransferListener ftpListener, ResetCoverageListener resetCoverageListener, File swFile, boolean automaticActivation, BTSMessage.Type type) {
        this(connection, ftpListener, resetCoverageListener, swFile, automaticActivation);
        this.myType = type;
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"Aborting called.");
        if (CoreAsset.isSnapshotOpening()) {
            if (this.myFtpListener != null) {
                this.myFtpListener.fileSetTransferCancelled();
            }
            this.myLogger.debug((Object)"Cannot abort in snapshot mode.");
            return true;
        }
        if (!this.myExecuted) {
            this.myLogger.debug((Object)"Aborting as external sw update.");
            CoreAssetThread worker = new CoreAssetThread(){

                protected Object construct() {
                    return SWUpdateScenario.this.abortScenarioAsExternal();
                }
            };
            worker.start();
            return true;
        }
        this.myAborted = false;
        if (!this.myInterruptMessageRequired) {
            this.myServer.stopServer();
            if (this.myFtpListener != null) {
                this.myFtpListener.fileSetTransferCancelled();
            }
            this.myLogger.debug((Object)"Interrupt message not needed.");
            return true;
        }
        if (!this.myAckToStartReceived) {
            this.myLogger.warn((Object)"Trying to stop the update, but BTS-OM did not confirm the update yet, there has not been ACK for SWUpdateRequest, there is something wrong with OAM replies.");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SWUpdateScenario.this.abortScenario();
            }
        };
        worker.start();
        return true;
    }

    public Object abortScenarioAsExternal() {
        int seqNumber = this.myConnection.createScenario();
        SWUpdateInterruptRequest interruptRequest = new SWUpdateInterruptRequest(seqNumber, this.myType);
        this.myConnection.sendToBTS((BTSMessage)interruptRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(seqNumber);
        this.myConnection.deleteScenario(seqNumber);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                this.myLogger.debug((Object)"SW update stopped.");
                this.myFtpListener.fileSetTransferCancelled();
                return true;
            }
            this.myLogger.debug((Object)"SW update stop failed.");
            this.myFtpListener.fileSetTransferCancellingFailed(302);
            return false;
        }
        this.myLogger.debug((Object)"SW update stop failed, invalid message or connection lost.");
        this.myFtpListener.fileSetTransferCancellingFailed(28);
        return false;
    }

    public Object abortScenario() {
        int seqNumber = this.myConnection.createScenario();
        SWUpdateInterruptRequest interruptRequest = new SWUpdateInterruptRequest(seqNumber, this.myType);
        this.myConnection.sendToBTS((BTSMessage)interruptRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(seqNumber, 60000L);
        this.myConnection.deleteScenario(seqNumber);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myFtpListener.fileSetTransferCancellingFailed(ack.getNackReason());
            } else {
                this.myAborted = true;
            }
        } else if (response instanceof Timeout) {
            this.myFtpListener.fileSetTransferCancellingFailed(68);
        }
        return true;
    }

    @Override
    public void execute() {
        if (this.myExecuted) {
            throw new IllegalStateException("Cannot execute Scenario. This scenario cannot be executed more than once.");
        }
        this.myExecuted = true;
        this.myAckToStartReceived = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SWUpdateScenario.this.runScenario();
            }

            protected void finished() {
            }
        };
        worker.start();
    }

    public Object runScenario() {
        String strThisIp = this.myConnection.getLocalIPAddress();
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myFtpListener.fileSetTransferFailed(85);
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        this.myServer = this.myConnection.getFileTransferFactory().getFileTransferServer();
        this.myServer.initListenerAndPath(this.myFtpListener, this.mySWFile.getParent());
        FTPTransferInfo ftpInfo = new FTPTransferInfo(this.mySWFile.getName(), strThisIp, this.myServer.getUserName(), this.myServer.getPassword().toCharArray());
        try {
            int port = this.myServer.startServer();
            if (port != 21) {
                ftpInfo.setServerAddress(String.valueOf(ftpInfo.getServerAddress()) + ":" + port);
            }
        }
        catch (Exception fte) {
            this.myConnection.deleteScenario(this.mySeqNumber);
            this.myFtpListener.fileSetTransferFailed(300);
            return false;
        }
        if (this.myAborted) {
            this.myLogger.debug((Object)"update aborted, while ftp was starting.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ire) {
                this.myLogger.debug((Object)"sleep interrupted.");
            }
            this.myConnection.deleteScenario(this.mySeqNumber);
            this.myFtpListener.fileSetTransferCancelled();
            return true;
        }
        SWUpdateRequest swUpdtReq = new SWUpdateRequest(this.mySeqNumber, this.myAutomaticActivation, ftpInfo, this.myType);
        this.myInterruptMessageRequired = true;
        this.myConnection.sendToBTS((BTSMessage)swUpdtReq);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber);
        if (response instanceof Ack) {
            Ack updateAck = (Ack)response;
            if (updateAck.getAck()) {
                BTSInboundMessage resp;
                this.myAckToStartReceived = true;
                this.myFtpListener.fileSetTransferStarted();
                while (true) {
                    if ((response = this.myConnection.receiveFromBTS(this.mySeqNumber)) instanceof SWDLPhaseCompletedNotif) {
                        resp = (SWDLPhaseCompletedNotif)response;
                        this.myFtpListener.fileTransferPhaseCompleted(resp.getFileName(), resp.getPhase(), resp.getResult());
                        continue;
                    }
                    if (!(response instanceof DownloadProgressNotif)) break;
                    resp = (DownloadProgressNotif)response;
                    this.myFtpListener.fileSetTransferUpdated(resp.getDLPercentage());
                }
                if (response instanceof SWUpToDate) {
                    this.myConnection.deleteScenario(this.mySeqNumber);
                    this.myServer.stopServer();
                    resp = (SWUpToDate)response;
                    try {
                        this.myResetCoverageListener.resetting(resp.getResetCoverage());
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)"GUIException, resetCoverageListener.resetting, ", (Throwable)e);
                    }
                    if (resp.getUpdateResult() == 36) {
                        try {
                            this.myFtpListener.fileSetTransferCompleted(this.mySWFile.toString());
                        }
                        catch (Exception e) {
                            this.myLogger.error((Object)"GUIException, fileSetTransferCompleted, ", (Throwable)e);
                        }
                        return true;
                    }
                    if (this.myAborted) {
                        try {
                            this.myFtpListener.fileSetTransferCancelled();
                        }
                        catch (Exception e) {
                            this.myLogger.error((Object)"GUIException, fileSetTransferCancelled, ", (Throwable)e);
                        }
                    } else {
                        try {
                            this.myFtpListener.fileSetTransferFailed(301, resp.getUpdateError());
                        }
                        catch (Exception e) {
                            this.myLogger.error((Object)"GUIException, fileSetTransferFailed, ", (Throwable)e);
                        }
                    }
                    return false;
                }
                this.myConnection.deleteScenario(this.mySeqNumber);
                this.myServer.stopServer();
                if (response != null) {
                    this.myFtpListener.fileSetTransferFailed(28);
                    this.myLogger.error((Object)("Wrong reply received from BTS. FilesUpToDate or Ack expected, " + response.getClass() + " received."));
                } else {
                    this.myFtpListener.fileSetTransferFailed(110);
                    this.myLogger.error((Object)"Null reply received from BTS, probably due broken connection. FilesUpToDate or Ack expected.");
                }
                return false;
            }
            this.myServer.stopServer();
            this.myLogger.debug((Object)("BTS refused SW Download with nackReason " + updateAck.getNackReasonString()));
            this.myFtpListener.fileSetTransferRejected(updateAck.getNackReason());
        } else {
            this.myServer.stopServer();
            if (response != null) {
                this.myFtpListener.fileSetTransferFailed(28);
                this.myLogger.error((Object)("Wrong reply received from BTS. Ack expected, " + response.getClass() + " received."));
            } else {
                this.myFtpListener.fileSetTransferFailed(110);
                this.myLogger.error((Object)"Null reply received from BTS. Ack expected.");
            }
        }
        this.myConnection.deleteScenario(this.mySeqNumber);
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

