/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.softwaremanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.SWVersionReply;
import com.nokia.em.bts.coreasset.message.SWVersionRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.softwaremanagement.SWVersionFTPListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class SWVersionScenario
implements Scenario {
    private FileTransferListener myFtpListener;
    private BTSConnection myConnection;
    private boolean myRunning = false;
    private Logger myLogger;
    private FileTransferClient myFTPClient;
    private int mySeqNumber;
    private static final int SWVERSION_TIMEOUT = 240000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SWVersionScenario(BTSConnection connection, FileTransferListener ftpListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFtpListener = ftpListener;
    }

    public SWVersionScenario(BTSConnection connection, FileTransferListener ftpListener, BTSMessage.Type type) {
        this(connection, ftpListener);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already executing.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SWVersionScenario.this.runScenario();
            }

            protected void finished() {
                SWVersionScenario.this.myRunning = false;
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        SWVersionScenario.this.myLogger.error((Object)"Get software version failed.");
                    }
                }
                catch (ExecutionException ite) {
                    Throwable t = ite.getCause();
                    SWVersionScenario.this.myLogger.error((Object)("Get software version failed: " + t));
                }
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myFtpListener.fileTransferFailed(String.valueOf(85));
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        SWVersionRequest swVersionRequest = new SWVersionRequest(this.mySeqNumber, this.myType);
        this.myConnection.sendToBTS((BTSMessage)swVersionRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 240000L);
        this.myConnection.deleteScenario(this.mySeqNumber);
        if (response instanceof SWVersionReply) {
            SWVersionReply temp = (SWVersionReply)response;
            FTPTransferInfo ftpInfo = temp.getFTPTransferInfo();
            String strFileId = ftpInfo.getFileId();
            if (temp.isSuccessful()) {
                SWVersionFTPListener localFTPListener = new SWVersionFTPListener(this.myFtpListener);
                try {
                    this.myFTPClient = this.myConnection.getFileTransferFactory().getFileTransferClient();
                    this.myFTPClient.setFTPTransferInfo(ftpInfo);
                    this.myFTPClient.getFile((FileTransferListener)localFTPListener);
                }
                catch (FileTransferException fte) {
                    this.myLogger.error((Object)("software version transfer failed. file transfer exception " + fte.toString()));
                    this.myFtpListener.fileTransferFailed(strFileId);
                }
                this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(this.mySeqNumber, new String[]{ftpInfo.getFileId()}));
            } else {
                this.myLogger.debug((Object)"software version transfer failed. FileVersionReply was unsuccessful.");
                this.myFtpListener.fileTransferFailed(strFileId);
            }
            return true;
        }
        this.myFtpListener.fileSetTransferFailed(37);
        return false;
    }

    @Override
    public boolean abort() {
        this.myFtpListener = new FileTransferAdapter();
        if (this.myConnection != null) {
            this.myLogger.debug((Object)"Trying to interrupt message receiving...");
            this.myConnection.interruptScenario(this.mySeqNumber);
        }
        if (this.myFTPClient != null) {
            this.myFTPClient.abort();
        }
        return true;
    }
}

