/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.BTSLogListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ExtendedFileTransferListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ZipperThread;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCreateTroubleShootingDataScenario
implements Scenario {
    protected BTSConnection myConnection;
    protected ExtendedFileTransferListener myFileTransferListener;
    protected BTSLogListener myBTSLogListener;
    protected String myLogCoverage;
    protected String myFileName;
    protected boolean myRunning = false;
    protected boolean myZipFiles;
    protected static final int LOG_TIMEOUT = 650000;
    protected static final int TIMER_COUNTER = 1;
    protected int intTimerCounter = 0;
    protected int mySeqNumber;
    protected Map myZipperMapping = Collections.synchronizedMap(new HashMap());
    protected ActionListener myTimerActionListener = null;
    protected ActionListener myOperationFeedbackSender = null;
    protected boolean myIsCancelled;
    protected Logger myLogger;
    protected List<String> myModules;
    protected Object objectLock = new Object();
    protected boolean isOngoingReceive;
    protected static final int ABORT_TIMEOUT = 30000;
    protected int myGetFileRetryDelay = 10000;
    protected static final int OPERATION_FEEDBACK_DELAY = 120000;
    protected BTSMessage.Type myType = BTSMessage.Type.BTS;

    protected abstract Object runScenario();

    @Override
    public abstract boolean abort();

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return AbstractCreateTroubleShootingDataScenario.this.runScenario();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finished() {
                if (AbstractCreateTroubleShootingDataScenario.this.isOngoingReceive) {
                    Object object = AbstractCreateTroubleShootingDataScenario.this.objectLock;
                    synchronized (object) {
                        try {
                            AbstractCreateTroubleShootingDataScenario.this.objectLock.wait(30000L);
                        }
                        catch (InterruptedException e) {
                            AbstractCreateTroubleShootingDataScenario.this.myLogger.debug((Object)"Failed waiting for abort to finish receiving Ack", (Throwable)e);
                        }
                    }
                }
                AbstractCreateTroubleShootingDataScenario.this.myConnection.deleteScenario(AbstractCreateTroubleShootingDataScenario.this.mySeqNumber);
                AbstractCreateTroubleShootingDataScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected void setGetFileRetryDelay(int delay) {
        this.myGetFileRetryDelay = delay;
    }

    protected void joinZipper(ZipperThread zipper, boolean saveFile, int seqNbr) {
        try {
            if (zipper != null) {
                if (!zipper.isStarted()) {
                    zipper.closeFile();
                }
                zipper.done(saveFile);
                zipper.join();
            }
        }
        catch (InterruptedException e) {
            this.myLogger.debug((Object)"Interrupted", (Throwable)e);
        }
        this.myZipperMapping.remove(seqNbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processScenarioWhenFileLoadPrepareOrTimeoutNotReceived(BTSMessage response) {
        if (response == null) {
            this.myLogger.debug((Object)"response is null, user cancelled scenario");
            return false;
        }
        if (response instanceof Ack && this.myIsCancelled) {
            Object object = this.objectLock;
            synchronized (object) {
                this.objectLock.notify();
            }
            return true;
        }
        this.myFileTransferListener.fileSetTransferFailed(28);
        this.myLogger.error((Object)("Wrong reply received from BTS. FileLoadPrepare expected, " + response.getClass() + " received."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processScenarioAfterSendingAbort() {
        if (this.myOperationFeedbackSender != null) {
            TimerService.getInstance().stopTimer(this.myOperationFeedbackSender);
        }
        if (!this.isOngoingReceive) {
            this.isOngoingReceive = true;
            this.myConnection.receiveFromBTS(this.mySeqNumber, 30000L);
            Object object = this.objectLock;
            synchronized (object) {
                this.objectLock.notify();
            }
            this.isOngoingReceive = false;
        } else {
            Object object = this.objectLock;
            synchronized (object) {
                try {
                    this.objectLock.wait(30000L);
                }
                catch (Exception e) {
                    this.myLogger.debug((Object)"Failed waiting for Ack ", (Throwable)e);
                }
            }
        }
    }

    protected void processScenarioWhenAbortCleanup() {
        ZipperThread zipper;
        this.myConnection.interruptScenario(this.mySeqNumber);
        this.myConnection.deleteScenario(this.mySeqNumber);
        this.myFileTransferListener.fileSetTransferCancelled();
        WeakReference weakReference = (WeakReference)this.myZipperMapping.get(this.mySeqNumber);
        if (weakReference != null && (zipper = (ZipperThread)((Object)weakReference.get())) != null) {
            this.joinZipper(zipper, false, this.mySeqNumber);
        }
        if (this.myTimerActionListener != null) {
            TimerService.getInstance().stopTimer(this.myTimerActionListener);
        }
    }

    protected void processScenarioWhenFirstAckNotRecieved(BTSMessage response) {
        if (response == null) {
            this.myLogger.debug((Object)"response is null, user cancelled scenario");
        } else if (response instanceof Timeout) {
            this.myFileTransferListener.fileSetTransferFailed(68);
            this.myLogger.debug((Object)"BTS Log request failed, timeout.");
        } else {
            this.myFileTransferListener.fileSetTransferFailed(28);
            this.myLogger.debug((Object)("Wrong reply received from BTS. Ack expected, " + response.getClass() + " received."));
        }
    }
}

