/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.CreateTroubleShootingData;
import com.nokia.em.bts.coreasset.message.FileLoadRequest;
import com.nokia.em.bts.coreasset.message.OperationFeedback;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.AbstractCreateTroubleShootingDataScenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.AbstractCreateTroubleshootingDataFTPListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.CreateTroubleShootingDataScenarioInfo;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileFetcherThread;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileUtils;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ZipperThread;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadPrepare;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiPredicate;
import org.apache.log4j.Logger;

public class CreateTroubleShootingDataParallelScenario
extends AbstractCreateTroubleShootingDataScenario {
    private final int NUM_CONCURRENT_FILES = 6;
    private ExecutorService myExecutor;
    private Queue<LogFileFetcherThread> myFileThreads;
    private boolean didLogFileFetcherThrowError;
    private BiPredicate<String, Integer> myFileNameChecker;
    private List<Future> myExecutedFutures;
    private List<String> myCells;

    public CreateTroubleShootingDataParallelScenario(BTSConnection connection, CreateTroubleShootingDataScenarioInfo data) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFileTransferListener = data.getExtendedFileTransferListener();
        this.myBTSLogListener = data.getBtsLogListener();
        this.myLogCoverage = data.getLogCoverage();
        this.myFileName = data.getFileName();
        this.myModules = data.getModules();
        this.myCells = data.getCells();
        this.myZipFiles = data.getIsZipFiles();
        this.myExecutor = Executors.newFixedThreadPool(6);
        this.myFileThreads = new ConcurrentLinkedQueue<LogFileFetcherThread>();
        this.myExecutedFutures = new ArrayList<Future>();
        this.myTimerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CreateTroubleShootingDataParallelScenario.this.stopFileTransferWhenTimeout();
            }
        };
        this.myOperationFeedbackSender = ae -> {
            boolean bl = this.myConnection.sendToBTS((BTSMessage)new OperationFeedback(this.mySeqNumber));
        };
    }

    public CreateTroubleShootingDataParallelScenario(BTSConnection connection, CreateTroubleShootingDataScenarioInfo data, BTSMessage.Type type) {
        this(connection, data);
        this.myType = type;
    }

    public CreateTroubleShootingDataParallelScenario(BTSConnection connection, CreateTroubleShootingDataScenarioInfo data, BTSMessage.Type type, BiPredicate<String, Integer> fileNameChecker) {
        this(connection, data, type);
        this.myFileNameChecker = fileNameChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myFileTransferListener.fileSetTransferFailed(85);
            return true;
        }
        this.didLogFileFetcherThrowError = false;
        this.myRunning = true;
        this.myIsCancelled = false;
        this.mySeqNumber = this.myConnection.createScenario();
        ZipperThread zipper = null;
        this.myConnection.sendToBTS((BTSMessage)new CreateTroubleShootingData(this.mySeqNumber, this.myLogCoverage, this.myModules, this.myCells, this.myType));
        BTSMessage response = this.getResponseFromBTS();
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (this.myIsCancelled) {
                Object object = this.objectLock;
                synchronized (object) {
                    this.objectLock.notify();
                }
                return true;
            }
            if (ack.getAck()) {
                boolean isFirstAck = true;
                this.myConnection.sendToBTS((BTSMessage)new FileLoadRequest(this.mySeqNumber, 119));
                while (this.intTimerCounter < 1 && !this.myIsCancelled && !this.didLogFileFetcherThrowError) {
                    this.intTimerCounter = 0;
                    response = this.getResponseFromBTS();
                    if (response instanceof FileLoadPrepare) {
                        FileLoadPrepare fileLoadPrepare = (FileLoadPrepare)response;
                        int cause = fileLoadPrepare.getCause();
                        if (cause != 36 && cause != -1) {
                            this.myFileTransferListener.fileSetTransferFailed(fileLoadPrepare.getCause());
                            this.myLogger.debug((Object)"FileLoadPrepare with unsuccessful _cause was received.");
                            this.safelyShutdownNow();
                            return false;
                        }
                        if (isFirstAck) {
                            TimerService.getInstance().startTimer(this.myOperationFeedbackSender, 120000L);
                            this.myFileTransferListener.fileSetTransferStarted();
                            isFirstAck = false;
                            zipper = this.initializeZipperThread();
                        }
                        this.executeFTPTransfer(zipper, fileLoadPrepare);
                        if (!fileLoadPrepare.isLastFile()) continue;
                        this.safelyShutdown();
                        break;
                    }
                    if (response instanceof Timeout) {
                        this.stopFileTransferWhenTimeout();
                        return false;
                    }
                    this.safelyShutdownNow();
                    return this.processScenarioWhenFileLoadPrepareOrTimeoutNotReceived(response);
                }
                this.waitToFinishAllTransfers();
                TimerService.getInstance().stopTimer(this.myOperationFeedbackSender);
                if (this.myIsCancelled && !this.isOngoingReceive) {
                    this.isOngoingReceive = true;
                    this.myConnection.receiveFromBTS(this.mySeqNumber);
                    this.isOngoingReceive = false;
                    Object object = this.objectLock;
                    synchronized (object) {
                        this.objectLock.notify();
                    }
                    return true;
                }
                this.joinZipper(zipper, true, this.mySeqNumber);
                return true;
            }
            if (response instanceof Timeout) {
                this.stopFileTransferWhenTimeout();
                return false;
            }
            this.myFileTransferListener.fileSetTransferFailed(ack.getNackReason());
            this.myLogger.debug((Object)"Nack was received.");
            return false;
        }
        this.processScenarioWhenFirstAckNotRecieved(response);
        return false;
    }

    private void safelyShutdownNow() {
        try {
            this.myExecutor.shutdownNow();
        }
        catch (Exception e) {
            this.myLogger.error((Object)"Executor shutdownNow() execution failed: ", (Throwable)e);
        }
    }

    private void safelyShutdown() {
        try {
            this.myExecutor.shutdown();
        }
        catch (Exception e) {
            this.myLogger.error((Object)"Executor shutdown() execution failed: ", (Throwable)e);
        }
    }

    private void executeFTPTransfer(ZipperThread zipper, FileLoadPrepare fileLoadPrepare) {
        if (fileLoadPrepare.getFTPTransferInfo().size() > 0) {
            LogFileFetcherThread fileFetcherThread = this.createLogFileFetcherThread(new CreateTroubleshootingDataParallelFTPListener(this.myFileTransferListener), zipper, (FTPTransferInfo)fileLoadPrepare.getFTPTransferInfo().get(0));
            this.myFileThreads.add(fileFetcherThread);
            this.safelySubmitToExecutor(fileFetcherThread);
        } else {
            this.myLogger.error((Object)"FTPTransferInfo is empty. Skipping FTP Transfer..");
        }
    }

    private void safelySubmitToExecutor(LogFileFetcherThread fileFetcherThread) {
        try {
            if (!this.myExecutor.isShutdown()) {
                this.myExecutedFutures.add(this.myExecutor.submit(fileFetcherThread));
            } else {
                fileFetcherThread.abort();
                this.myFileThreads.remove(fileFetcherThread);
            }
        }
        catch (Exception exception) {
            this.myLogger.error((Object)"Failure in submitting fetcher thread: ", (Throwable)exception);
        }
    }

    private void waitToFinishAllTransfers() {
        for (Future future : this.myExecutedFutures) {
            try {
                future.get();
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Unexpected exception during awaiting for file transfer to end.", (Throwable)e);
            }
        }
    }

    private BTSMessage getResponseFromBTS() {
        TimerService.getInstance().startTimer(this.myTimerActionListener, 650000L);
        this.isOngoingReceive = true;
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber);
        this.isOngoingReceive = false;
        TimerService.getInstance().stopTimer(this.myTimerActionListener);
        return response;
    }

    private ZipperThread initializeZipperThread() {
        ZipperThread zipper = new ZipperThread(this.myFileTransferListener, this.myBTSLogListener, this.myFileName, this.myConnection.getBTSId(), this.myZipFiles, this.myFileNameChecker);
        int priority = zipper.getPriority() - 1;
        if (priority >= 1) {
            zipper.setPriority(priority);
        }
        this.myZipperMapping.put(this.mySeqNumber, new WeakReference<ZipperThread>(zipper));
        zipper.start();
        return zipper;
    }

    private void stopFileTransferWhenTimeout() {
        if (this.intTimerCounter < 0) {
            ++this.intTimerCounter;
        } else {
            this.intTimerCounter = 0;
            this.myFileTransferListener.fileSetTransferFailed(68);
            this.abort();
        }
    }

    protected LogFileFetcherThread createLogFileFetcherThread(FileTransferListener localFileTransferListener, ZipperThread zipper, FTPTransferInfo ftpTransferInfo) {
        LogFileFetcherThread fileFetcherThread = new LogFileFetcherThread(this.myConnection, ftpTransferInfo, zipper, localFileTransferListener, this.mySeqNumber, this.myGetFileRetryDelay);
        return fileFetcherThread;
    }

    @Override
    public boolean abort() {
        if (!this.myRunning) {
            return true;
        }
        if (!this.myIsCancelled) {
            this.myLogger.debug((Object)"Abort called.");
            this.myIsCancelled = true;
            if (this.myConnection == null || this.myFileTransferListener == null) {
                this.myLogger.debug((Object)"BTS connection or File transfer listener is null");
                return true;
            }
            this.myFileThreads.removeIf(LogFileFetcherThread::isDone);
            if (!this.myFileThreads.isEmpty()) {
                this.myFileThreads.stream().forEach(thread -> thread.abort());
            } else {
                LogFileUtils.sendAbortMessageToBTS(this.myConnection, this.mySeqNumber, "");
            }
            this.safelyShutdownNow();
            this.processScenarioAfterSendingAbort();
            this.processScenarioWhenAbortCleanup();
        } else {
            this.myLogger.debug((Object)"Abort called but already aborted. Ignoring.");
        }
        return true;
    }

    private class CreateTroubleshootingDataParallelFTPListener
    extends AbstractCreateTroubleshootingDataFTPListener {
        private int resetCounter;
        private static final int RESET = 60;

        public CreateTroubleshootingDataParallelFTPListener(FileTransferListener fileTransferListener) {
            super(fileTransferListener);
            this.resetCounter = 0;
        }

        @Override
        public void fileTransferStarted(String strFileId, long lSize) {
            CreateTroubleShootingDataParallelScenario.this.myConnection.sendToBTS((BTSMessage)new OperationFeedback(CreateTroubleShootingDataParallelScenario.this.mySeqNumber));
            CreateTroubleShootingDataParallelScenario.this.myFileTransferListener.fileTransferStarted(strFileId, lSize);
        }

        @Override
        public void fileTransferUpdated(String strFileId, float fPercentage) {
            this.resetTimeoutTimer();
        }

        private void resetTimeoutTimer() {
            if (this.resetCounter > 60) {
                TimerService.getInstance().stopTimer(CreateTroubleShootingDataParallelScenario.this.myTimerActionListener);
                TimerService.getInstance().startTimer(CreateTroubleShootingDataParallelScenario.this.myTimerActionListener, 650000L);
                this.resetCounter = 0;
                CreateTroubleShootingDataParallelScenario.this.myLogger.debug((Object)"Resetting timeout timer, download is still ongoing.");
            } else {
                ++this.resetCounter;
            }
        }

        @Override
        public void fileSetTransferFailed(int intFailReason) {
            CreateTroubleShootingDataParallelScenario.this.didLogFileFetcherThrowError = true;
            if (intFailReason == -1) {
                CreateTroubleShootingDataParallelScenario.this.safelyShutdownNow();
            }
            CreateTroubleShootingDataParallelScenario.this.myFileTransferListener.fileSetTransferFailed(intFailReason);
        }
    }
}

