/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.CreateTroubleShootingData;
import com.nokia.em.bts.coreasset.message.FileLoadRequest;
import com.nokia.em.bts.coreasset.message.OperationFeedback;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.AbstractCreateTroubleShootingDataScenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.AbstractCreateTroubleshootingDataFTPListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.BTSLogListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.CreateTroubleShootingDataScenarioInfo;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ExtendedFileTransferListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ExtendedFileTransferWrapper;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileDescriptor;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileUtils;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ZipperThread;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.FileLoadPrepare;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import org.apache.log4j.Logger;

public class CreateTroubleShootingDataScenario
extends AbstractCreateTroubleShootingDataScenario {
    private boolean myFirstAck = true;
    private boolean myLastMsg = false;
    private FileTransferClient myFtpClientAdapter;
    private String myFileToBeTransferred = "";
    private static final int GET_FILE_RETRY_COUNT = 3;
    private static final int GET_FILE_FAILED_DISK_FULL = -1;

    public CreateTroubleShootingDataScenario(BTSConnection connection, BTSLogListener btsLogListener, FileTransferListener fileTransferListener, String strLogCoverage, String strFileName, List<String> modules, boolean zipFiles) {
        this.initialize(connection, btsLogListener, strLogCoverage, strFileName, modules, zipFiles);
        if (fileTransferListener != null) {
            this.myFileTransferListener = new ExtendedFileTransferWrapper(fileTransferListener);
        }
        this.createTimerActionListener();
        this.createOperationFeedBackSenderActionListener();
    }

    public CreateTroubleShootingDataScenario(BTSConnection connection, BTSLogListener btsLogListener, FileTransferListener fileTransferListener, String strLogCoverage, String strFileName, List<String> modules, boolean zipFiles, BTSMessage.Type type) {
        this(connection, btsLogListener, fileTransferListener, strLogCoverage, strFileName, modules, zipFiles);
        this.myType = type;
    }

    public CreateTroubleShootingDataScenario(BTSConnection connection, BTSLogListener btsLogListener, ExtendedFileTransferListener fileTransferListener, String strLogCoverage, String strFileName, List<String> modules, boolean zipFiles) {
        this.initialize(connection, btsLogListener, strLogCoverage, strFileName, modules, zipFiles);
        this.myFileTransferListener = fileTransferListener;
        this.createTimerActionListener();
        this.createOperationFeedBackSenderActionListener();
    }

    public CreateTroubleShootingDataScenario(BTSConnection connection, CreateTroubleShootingDataScenarioInfo info, BTSMessage.Type type) {
        this(connection, info.getBtsLogListener(), info.getExtendedFileTransferListener(), info.getLogCoverage(), info.getFileName(), info.getModules(), info.getIsZipFiles());
        this.myType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myFileTransferListener.fileSetTransferFailed(85);
            return true;
        }
        this.myRunning = true;
        this.myFirstAck = true;
        this.myLastMsg = false;
        this.myIsCancelled = false;
        CreateTroubleshootingDataFTPListener localFileTransferListener = new CreateTroubleshootingDataFTPListener(this.myFileTransferListener);
        this.mySeqNumber = this.myConnection.createScenario();
        ZipperThread zipper = null;
        this.myConnection.sendToBTS((BTSMessage)new CreateTroubleShootingData(this.mySeqNumber, this.myLogCoverage, this.myModules, this.myType));
        TimerService.getInstance().startTimer(this.myTimerActionListener, 650000L);
        this.isOngoingReceive = true;
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber);
        this.isOngoingReceive = false;
        TimerService.getInstance().stopTimer(this.myTimerActionListener);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (this.myIsCancelled) {
                Object object = this.objectLock;
                synchronized (object) {
                    this.objectLock.notify();
                }
                return true;
            }
            if (ack.getAck()) {
                this.myConnection.sendToBTS((BTSMessage)new FileLoadRequest(this.mySeqNumber, 119));
                while (!this.myLastMsg && this.intTimerCounter < 1 && !this.myIsCancelled) {
                    TimerService.getInstance().startTimer(this.myTimerActionListener, 650000L);
                    this.isOngoingReceive = true;
                    response = this.myConnection.receiveFromBTS(this.mySeqNumber);
                    this.isOngoingReceive = false;
                    TimerService.getInstance().stopTimer(this.myTimerActionListener);
                    this.intTimerCounter = 0;
                    if (response instanceof FileLoadPrepare) {
                        FileLoadPrepare fileLoadPrepare = (FileLoadPrepare)response;
                        if (fileLoadPrepare.getCause() == 36 || fileLoadPrepare.getCause() == -1) {
                            if (fileLoadPrepare.getFileRemaining() >= 0) {
                                this.myFileTransferListener.fileTransferCountUpdated(fileLoadPrepare.getFileTotal(), fileLoadPrepare.getFileRemaining());
                            }
                            if (this.myFirstAck) {
                                this.myFileTransferListener.fileSetTransferStarted();
                                this.myFirstAck = false;
                            }
                            if (zipper == null) {
                                zipper = new ZipperThread(this.myFileTransferListener, this.myBTSLogListener, this.myFileName, this.myConnection.getBTSId(), this.myZipFiles);
                                int priority = zipper.getPriority() - 1;
                                if (priority >= 1) {
                                    zipper.setPriority(priority);
                                }
                                this.myZipperMapping.put(this.mySeqNumber, new WeakReference<ZipperThread>(zipper));
                                zipper.start();
                            }
                            if (fileLoadPrepare.getFTPTransferInfo().size() > 0) {
                                FTPTransferInfo ftpInfo = (FTPTransferInfo)fileLoadPrepare.getFTPTransferInfo().get(0);
                                String strFileId = ftpInfo.getFileId();
                                if (strFileId != null && strFileId.trim().length() != 0) {
                                    try {
                                        this.startFileFetching(localFileTransferListener, zipper, ftpInfo, strFileId);
                                    }
                                    catch (DiskSpaceException e) {
                                        this.myFileTransferListener.fileSetTransferFailed(-1);
                                        this.myLogger.debug((Object)"Cancelling request since disk is already full");
                                        return false;
                                    }
                                } else {
                                    this.myLogger.debug((Object)"Null fileId received, aborting.");
                                }
                            }
                            if (!fileLoadPrepare.isLastFile()) continue;
                            this.myLastMsg = true;
                            this.joinZipper(zipper, true, this.mySeqNumber);
                            return true;
                        }
                        this.myFileTransferListener.fileSetTransferFailed(fileLoadPrepare.getCause());
                        this.myLogger.debug((Object)"FileLoadPrepare with unsuccessful _cause was received.");
                        return false;
                    }
                    return this.processScenarioWhenFileLoadPrepareOrTimeoutNotReceived(response);
                }
                if (this.myIsCancelled && !this.isOngoingReceive) {
                    this.isOngoingReceive = true;
                    this.myConnection.receiveFromBTS(this.mySeqNumber);
                    this.isOngoingReceive = false;
                    Object object = this.objectLock;
                    synchronized (object) {
                        this.objectLock.notify();
                    }
                    return true;
                }
                this.joinZipper(zipper, true, this.mySeqNumber);
                return true;
            }
            this.myFileTransferListener.fileSetTransferFailed(ack.getNackReason());
            this.myLogger.debug((Object)"Nack was received.");
            return false;
        }
        this.processScenarioWhenFirstAckNotRecieved(response);
        return false;
    }

    private void initialize(BTSConnection connection, BTSLogListener btsLogListener, String strLogCoverage, String strFileName, List<String> modules, boolean zipFiles) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myBTSLogListener = btsLogListener;
        this.myLogCoverage = strLogCoverage;
        this.myFileName = strFileName;
        this.myModules = modules;
        this.myZipFiles = zipFiles;
    }

    private void startFileFetching(FileTransferListener fileTransferListener, ZipperThread zipper, FTPTransferInfo ftpInfo, String strFileId) throws DiskSpaceException {
        File tempGZIPFile = null;
        this.myFileToBeTransferred = strFileId.trim();
        String actualTechLogFileName = LogFileUtils.getFileNameFromFilePath(strFileId);
        int retryCount = 0;
        while (retryCount < 3 && !this.myIsCancelled) {
            try {
                tempGZIPFile = this.transferFile(fileTransferListener, ftpInfo);
                if (tempGZIPFile != null && tempGZIPFile.length() > 0L) {
                    TimerService.getInstance().stopTimer(this.myOperationFeedbackSender);
                    break;
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Fetching BTS log file error.", (Throwable)e);
                LogFileUtils.processDiskSpaceException(this.myConnection, this.mySeqNumber, ftpInfo.getFileId(), e);
            }
            finally {
                TimerService.getInstance().stopTimer(this.myOperationFeedbackSender);
            }
            this.retryDelay();
            ++retryCount;
        }
        FileLoadCompleted message = LogFileUtils.createFileLoadComplete(this.mySeqNumber, this.myFileToBeTransferred);
        if (!this.myIsCancelled) {
            if (retryCount == 3) {
                this.myLogger.debug((Object)("Unable to get file: " + actualTechLogFileName));
                try {
                    this.myFileTransferListener.fileTransferFailed(ftpInfo.getFileId());
                }
                catch (Exception e) {
                    this.myLogger.error((Object)("Error notifying listener: " + e));
                }
                message.setCause(37);
            } else {
                LogFileDescriptor descriptor = new LogFileDescriptor(actualTechLogFileName, tempGZIPFile);
                zipper.add(descriptor);
            }
            this.myConnection.sendToBTS((BTSMessage)message);
        }
    }

    private void createOperationFeedBackSenderActionListener() {
        this.myOperationFeedbackSender = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateTroubleShootingDataScenario.this.myConnection.sendToBTS((BTSMessage)new OperationFeedback(CreateTroubleShootingDataScenario.this.mySeqNumber));
            }
        };
    }

    private void createTimerActionListener() {
        this.myTimerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (CreateTroubleShootingDataScenario.this.intTimerCounter < 0) {
                    ++CreateTroubleShootingDataScenario.this.intTimerCounter;
                } else {
                    CreateTroubleShootingDataScenario.this.intTimerCounter = 0;
                    CreateTroubleShootingDataScenario.this.myFileTransferListener.fileSetTransferFailed(68);
                    CreateTroubleShootingDataScenario.this.abort();
                }
            }
        };
    }

    private File transferFile(FileTransferListener fileTransferListener, FTPTransferInfo ftpInfo) throws FileTransferException {
        this.myFtpClientAdapter = this.myConnection.getFileTransferFactory().getFileTransferClient();
        this.myFtpClientAdapter.setFTPTransferInfo(ftpInfo);
        return this.myFtpClientAdapter.getFile(fileTransferListener);
    }

    private void retryDelay() {
        try {
            Thread.sleep(this.myGetFileRetryDelay);
        }
        catch (InterruptedException e) {
            this.myLogger.error((Object)"InterruptedException.", (Throwable)e);
        }
    }

    @Override
    protected void setGetFileRetryDelay(int delay) {
        this.myGetFileRetryDelay = delay;
    }

    @Override
    public boolean abort() {
        if (!this.myRunning) {
            return true;
        }
        if (!this.myIsCancelled) {
            this.myLogger.debug((Object)"Abort called.");
            this.myIsCancelled = true;
            if (this.myConnection == null || this.myFileTransferListener == null) {
                this.myLogger.debug((Object)"BTS connection or File transfer listener is null");
                return true;
            }
            try {
                this.myFtpClientAdapter.abort();
            }
            catch (Exception e) {
                this.myLogger.debug((Object)"Error in cancelling technical log files creation: ", (Throwable)e);
            }
            LogFileUtils.sendAbortMessageToBTS(this.myConnection, this.mySeqNumber, this.myFileToBeTransferred);
            this.processScenarioAfterSendingAbort();
            this.processScenarioWhenAbortCleanup();
        } else {
            this.myLogger.debug((Object)"Abort called but already aborted. Ignoring.");
        }
        return true;
    }

    private class CreateTroubleshootingDataFTPListener
    extends AbstractCreateTroubleshootingDataFTPListener {
        public CreateTroubleshootingDataFTPListener(FileTransferListener fileTransferListener) {
            super(fileTransferListener);
        }

        @Override
        public void fileTransferStarted(String strFileId, long lSize) {
            CreateTroubleShootingDataScenario.this.myConnection.sendToBTS((BTSMessage)new OperationFeedback(CreateTroubleShootingDataScenario.this.mySeqNumber));
            TimerService.getInstance().startTimer(CreateTroubleShootingDataScenario.this.myOperationFeedbackSender, 120000L);
            CreateTroubleShootingDataScenario.this.myFileTransferListener.fileTransferStarted(strFileId, lSize);
        }

        @Override
        public void fileSetTransferFailed(int intFailReason) {
            CreateTroubleShootingDataScenario.this.myFileTransferListener.fileSetTransferFailed(intFailReason);
        }
    }
}

