/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusRequest;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ExtendedLoggingListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class GetExtendedLoggingCategoriesScenario
implements Scenario {
    private BTSConnection myConnection;
    private ExtendedLoggingListener myListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private int seqNumber;

    public GetExtendedLoggingCategoriesScenario(BTSConnection connection, ExtendedLoggingListener listener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = listener;
    }

    public GetExtendedLoggingCategoriesScenario(BTSConnection connection, ExtendedLoggingListener listener, BTSMessage.Type type) {
        this(connection, listener);
        this.myType = type;
    }

    @Override
    public void execute() {
        this.myLogger.trace((Object)"Executing.");
        if (this.myRunning) {
            this.myLogger.debug((Object)"Illegal state.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return GetExtendedLoggingCategoriesScenario.this.runScenario();
            }

            protected void finished() {
                GetExtendedLoggingCategoriesScenario.this.myLogger.debug((Object)"Worker finished.");
                GetExtendedLoggingCategoriesScenario.this.myConnection.deleteScenario(GetExtendedLoggingCategoriesScenario.this.seqNumber);
                GetExtendedLoggingCategoriesScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    public Object runScenario() {
        this.myLogger.debug((Object)"Worker construct.");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"No snapshot support.");
            this.myListener.getCategoriesFailed(85);
            return true;
        }
        this.seqNumber = this.myConnection.createScenario();
        this.myConnection.sendToBTS((BTSMessage)new ExtendedLoggingModeStatusRequest(this.seqNumber));
        BTSMessage response = this.myConnection.receiveFromBTS(this.seqNumber, 60000L);
        if (response instanceof ExtendedLoggingModeStatusResponse) {
            ExtendedLoggingModeStatusResponse loggingResponse = (ExtendedLoggingModeStatusResponse)response;
            this.myLogger.debug((Object)"Getting logging categories successful.");
            this.myListener.getCategoriesSuccessful(loggingResponse.getLoggingCategories());
        } else if (response instanceof Ack) {
            this.myLogger.debug((Object)"Getting logging categories failed.");
            this.myListener.getCategoriesFailed(((Ack)response).getNackReason());
        } else if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Getting logging categories timeouted.");
            this.myListener.getCategoriesFailed(68);
        } else {
            this.myLogger.debug((Object)"Got invalid message or broken connection.");
            this.myListener.getCategoriesFailed(28);
        }
        this.myLogger.debug((Object)"Worker construct end.");
        return true;
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"GUI tried to abort, not supported in this scenario.");
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

