/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusEndRequest;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusRequest;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusResponse;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeStatusUpdate;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogCollectingListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class LogCollectingScenario
implements Scenario {
    private BTSConnection myConnection;
    private LogCollectingListener myListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private int mySeqNumber;
    private final int STATUS_TIMEOUT = 5000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public LogCollectingScenario(BTSConnection connection, LogCollectingListener listener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = listener;
    }

    public LogCollectingScenario(BTSConnection connection, LogCollectingListener listener, BTSMessage.Type type) {
        this(connection, listener);
        this.myType = type;
    }

    @Override
    public void execute() {
        this.myLogger.trace((Object)"Executing.");
        if (this.isRunning()) {
            this.myLogger.debug((Object)"Illegal state.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.setIsRunning(true);
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return LogCollectingScenario.this.runScenario();
            }

            protected void finished() {
                LogCollectingScenario.this.myLogger.debug((Object)"Worker finished.");
                LogCollectingScenario.this.setIsRunning(false);
                LogCollectingScenario.this.myConnection.deleteScenario(LogCollectingScenario.this.mySeqNumber);
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        this.myLogger.debug((Object)"Worker construct.");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"No snapshot support.");
            this.myListener.categoriesReceiveFailed(85);
            this.myListener.logFilesReceiveFailed(85);
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        this.myConnection.sendToBTS((BTSMessage)new ExtendedLoggingModeStatusRequest(this.mySeqNumber, this.myType));
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof ExtendedLoggingModeStatusResponse) {
            ExtendedLoggingModeStatusResponse loggingResponse = (ExtendedLoggingModeStatusResponse)response;
            this.myLogger.debug((Object)"Getting log categories and log files successful.");
            this.myListener.categoriesReceived(loggingResponse.getLoggingCategories());
            this.myListener.logFilesReceived(loggingResponse.getLogFiles());
            while (this.isRunning()) {
                response = this.myConnection.receiveFromBTS(this.mySeqNumber, 5000L);
                if (!(response instanceof ExtendedLoggingModeStatusUpdate)) continue;
                ExtendedLoggingModeStatusUpdate loggingUpdate = (ExtendedLoggingModeStatusUpdate)response;
                this.myListener.logFilesReceived(loggingUpdate.getLogFiles());
            }
        } else if (response instanceof Ack) {
            this.myLogger.debug((Object)"Getting log categories and log files failed.");
            this.myListener.categoriesReceiveFailed(((Ack)response).getNackReason());
            this.myListener.logFilesReceiveFailed(((Ack)response).getNackReason());
        } else if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Getting log categories and log files timeouted.");
            this.myListener.categoriesReceiveFailed(68);
            this.myListener.logFilesReceiveFailed(68);
        } else {
            this.myLogger.debug((Object)"Got invalid message or broken connection.");
            this.myListener.categoriesReceiveFailed(28);
            this.myListener.logFilesReceiveFailed(28);
        }
        this.myLogger.debug((Object)"Worker construct end.");
        return true;
    }

    @Override
    public boolean abort() {
        this.setIsRunning(false);
        this.myLogger.debug((Object)"Aborted.");
        this.myConnection.sendToBTS((BTSMessage)new ExtendedLoggingModeStatusEndRequest(this.mySeqNumber));
        return true;
    }

    private synchronized void setIsRunning(boolean value) {
        this.myRunning = value;
    }

    protected synchronized boolean isRunning() {
        return this.myRunning;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

