/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class LogFileDecompressor {
    private static final String TMP = "tmp";
    private static final String FTM = "ftm";
    private static final String TAR = ".tar";
    private static final String TGZ = ".tgz";
    private static final String GZ = ".gz";
    private List<File> myFileList = new ArrayList<File>();
    private List<File> skippedFiles = new ArrayList<File>();
    private Logger myLogger = Logger.getLogger(this.getClass());
    private File myOriginalFile;
    private int myBTSId;
    private String myFilename;
    private final String myOriginalFilename;
    private boolean myIsRecursive = true;
    private BiPredicate<String, Integer> myFileNameChecker;
    private File myTempDir;

    public LogFileDecompressor(File file, String originalFileName, int btsId) throws IOException {
        this(file, originalFileName, btsId, true);
    }

    public LogFileDecompressor(File file, String originalFileName, int btsId, boolean isRecursive) throws IOException {
        this(file, originalFileName, btsId, isRecursive, null);
    }

    public LogFileDecompressor(File file, String originalFileName, int btsId, boolean isRecursive, BiPredicate<String, Integer> fileNameChecker) throws IOException {
        this.myOriginalFile = file;
        this.myBTSId = btsId;
        this.myTempDir = PFileUtils.createTempDir((String)String.valueOf(this.myBTSId));
        this.myFilename = originalFileName;
        this.myOriginalFilename = originalFileName;
        this.myIsRecursive = isRecursive;
        this.myFileNameChecker = fileNameChecker != null ? fileNameChecker : this::isFileNameValid;
        if (Tools.isGZipFile((File)this.myOriginalFile)) {
            this.gunZip(this.myOriginalFile);
        } else if (Tools.isZipFile((File)this.myOriginalFile)) {
            this.unzip(this.myOriginalFile, this.myFilename);
        } else if (!file.getName().equals(originalFileName)) {
            File renamedFile = new File(this.myTempDir, originalFileName);
            renamedFile.deleteOnExit();
            if (renamedFile.exists() && !renamedFile.delete()) {
                this.myLogger.error((Object)("File " + originalFileName + " is already existing and its deletion failed."));
            }
            if (!this.myOriginalFile.renameTo(renamedFile)) {
                this.myLogger.error((Object)("Renaming " + file.getName() + " into " + originalFileName + " failed."));
            }
            this.myFileList.add(renamedFile);
        } else {
            this.myFileList.add(this.myOriginalFile);
        }
        this.myFileList.addAll(this.skippedFiles);
    }

    private Boolean isFileNameValid(String f, Integer id) {
        if (id != null && !f.matches("BTS" + id + "_PART(..*)") && !f.equals("BTS" + id + ".ZIP")) {
            return true;
        }
        return false;
    }

    private void gunZip(File file) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        File outFile = null;
        String fname = file.getName();
        if ((fname.startsWith(FTM) || fname.startsWith(TMP)) && fname.endsWith(TMP)) {
            fname = this.myFilename;
        }
        if (fname.toLowerCase().lastIndexOf(GZ) != -1) {
            fname = fname.substring(0, fname.lastIndexOf(GZ));
        } else if (fname.toLowerCase().lastIndexOf(TGZ) != -1 && (fname = fname.substring(0, fname.lastIndexOf(TGZ))).toLowerCase().lastIndexOf(TAR) == -1) {
            fname = fname.concat(TAR);
        }
        outFile = new File(this.myTempDir, fname);
        outFile.deleteOnExit();
        FileInputStream instream = new FileInputStream(file);
        GZIPInputStream ginstream = new GZIPInputStream(instream);
        FileOutputStream outstream = new FileOutputStream(outFile);
        while ((len = ginstream.read(buf)) > 0) {
            outstream.write(buf, 0, len);
        }
        ginstream.close();
        outstream.close();
        try {
            if (this.myIsRecursive && Tools.isGZipFile((File)outFile)) {
                this.gunZip(outFile);
                this.deleteFileAfterDecompress(outFile);
            } else if (this.myIsRecursive && Tools.isZipFile((File)outFile)) {
                this.unzip(outFile, fname);
                this.deleteFileAfterDecompress(outFile);
            } else {
                this.myFileList.add(outFile);
            }
        }
        catch (IOException e) {
            this.myLogger.error((Object)("Exception happned when decompressing the file: " + outFile.getName() + ". " + e.getMessage()));
            this.myFileList.add(outFile);
        }
    }

    private void unzip(File file, String fileName) throws IOException {
        ZipEntry entry;
        String fileNameUpper = fileName.toUpperCase();
        if (fileNameUpper.endsWith("ZIP") && this.myFileNameChecker.test(fileNameUpper, this.myBTSId)) {
            boolean isATempFile = file.getName().toLowerCase().endsWith(TMP);
            this.myLogger.debug((Object)("Skipped unzipping " + fileName));
            if (!isATempFile && !file.getName().equals(this.myOriginalFilename)) {
                this.skippedFiles.add(file);
            }
            return;
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        File outFile = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        while ((entry = zis.getNextEntry()) != null) {
            int size;
            byte[] buffer = new byte[1024];
            outFile = new File(this.myTempDir, entry.getName());
            outFile.deleteOnExit();
            fos = new FileOutputStream(outFile);
            bos = new BufferedOutputStream(fos, buffer.length);
            while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
            fos.close();
            try {
                if (this.myIsRecursive && Tools.isZipFile((File)outFile)) {
                    this.unzip(outFile, outFile.getName());
                    this.deleteFileAfterDecompress(outFile);
                    continue;
                }
                if (this.myIsRecursive && Tools.isGZipFile((File)outFile)) {
                    this.gunZip(outFile);
                    this.deleteFileAfterDecompress(outFile);
                    continue;
                }
                this.myFileList.add(outFile);
            }
            catch (IOException e) {
                this.myLogger.error((Object)("Exception happned when decompressing the file: " + outFile.getName() + ". " + e.getMessage()));
                this.myFileList.add(outFile);
            }
        }
        zis.close();
    }

    private void deleteFileAfterDecompress(File outFile) {
        if (!this.skippedFiles.contains(outFile) && !outFile.delete()) {
            outFile.deleteOnExit();
        }
    }

    public List<File> getFiles() {
        return this.myFileList;
    }

    public File getOriginalFile() {
        return this.myOriginalFile;
    }
}

