/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileDescriptor;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileUtils;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ZipperThread;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;
import java.io.File;
import java.util.Optional;
import org.apache.log4j.Logger;

public class LogFileFetcherThread
implements Runnable {
    private static final int GET_FILE_RETRY_COUNT = 3;
    static final int GET_FILE_FAILED_DISK_FULL = -1;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private BTSConnection myConnection;
    private FTPTransferInfo myFtpInfo;
    private ZipperThread myZipper;
    private FileTransferListener myFileTransferListener;
    private FileTransferClient myFtpClientAdapter;
    private String myFileToBeTransferred = "";
    private int mySeqNumber;
    private int myGetFileRetryDelay;
    private boolean myIsCancelled = false;
    private boolean myIsDone = false;

    public LogFileFetcherThread(BTSConnection connection, FTPTransferInfo ftpInfo, ZipperThread zipper, FileTransferListener fileTransferListener, int seqNumber, int getFileRetryDelay) {
        this.myConnection = connection;
        this.myFtpInfo = ftpInfo;
        this.myZipper = zipper;
        this.myFileTransferListener = fileTransferListener;
        this.mySeqNumber = seqNumber;
        this.myGetFileRetryDelay = getFileRetryDelay;
        this.myFileToBeTransferred = Optional.ofNullable(this.myFtpInfo.getFileId()).orElse("");
    }

    @Override
    public void run() {
        if (this.myFileToBeTransferred != null && this.myFileToBeTransferred.trim().length() != 0) {
            this.myLogger.debug((Object)("Starting to fetch: " + this.myFileToBeTransferred));
            try {
                this.startFileFetching();
            }
            catch (DiskSpaceException e) {
                this.myFileTransferListener.fileSetTransferFailed(-1);
                this.myLogger.debug((Object)"Cancelling request since disk is already full");
            }
        } else {
            this.myLogger.debug((Object)"Null fileId received, aborting.");
        }
        this.myIsDone = true;
    }

    protected void startFileFetching() throws DiskSpaceException {
        File tempGZIPFile = null;
        this.myFileToBeTransferred = this.myFileToBeTransferred.trim();
        String actualTechLogFileName = LogFileUtils.getFileNameFromFilePath(this.myFileToBeTransferred);
        int retryCount = 0;
        while (retryCount < 3 && !this.myIsCancelled) {
            try {
                tempGZIPFile = this.transferFile();
                if (tempGZIPFile != null && tempGZIPFile.length() > 0L) {
                    break;
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Fetching BTS log file error.", (Throwable)e);
                LogFileUtils.processDiskSpaceException(this.myConnection, this.mySeqNumber, this.myFileToBeTransferred, e);
            }
            this.retryDelay();
            ++retryCount;
        }
        FileLoadCompleted fileLoadCompletedMessage = LogFileUtils.createFileLoadComplete(this.mySeqNumber, this.myFileToBeTransferred);
        if (!this.myIsCancelled) {
            if (retryCount == 3) {
                this.myLogger.debug((Object)("Unable to get file: " + actualTechLogFileName));
                try {
                    this.myFileTransferListener.fileTransferFailed(this.myFtpInfo.getFileId());
                }
                catch (Exception e) {
                    this.myLogger.error((Object)("Error notifying listener: " + e));
                }
                fileLoadCompletedMessage.setCause(37);
            } else {
                LogFileDescriptor descriptor = new LogFileDescriptor(actualTechLogFileName, tempGZIPFile);
                this.myZipper.add(descriptor);
            }
            this.myConnection.sendToBTS((BTSMessage)fileLoadCompletedMessage);
        }
    }

    protected File transferFile() throws FileTransferException {
        this.myFtpClientAdapter = this.myConnection.getFileTransferFactory().getFileTransferClient();
        this.myFtpClientAdapter.setFTPTransferInfo(this.myFtpInfo);
        return this.myFtpClientAdapter.getFile(this.myFileTransferListener);
    }

    private void retryDelay() {
        try {
            Thread.sleep(this.myGetFileRetryDelay);
        }
        catch (InterruptedException e) {
            this.myLogger.error((Object)"InterruptedException.", (Throwable)e);
        }
    }

    public boolean isDone() {
        return this.myIsDone;
    }

    public void abort() {
        if (this.myIsDone || this.myFileToBeTransferred.isEmpty()) {
            return;
        }
        this.myIsCancelled = true;
        try {
            Optional.ofNullable(this.myFtpClientAdapter).ifPresent(FileTransferClient::abort);
        }
        catch (Exception e) {
            this.myLogger.debug((Object)"Error in cancelling technical log files creation: ", (Throwable)e);
        }
        LogFileUtils.sendAbortMessageToBTS(this.myConnection, this.mySeqNumber, this.myFileToBeTransferred);
    }
}

