/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;

public interface LogFileUtils {
    public static final String UNIX_FILE_SEP = "/";
    public static final String WIN_FILE_SEP = "\\";

    public static String getFileNameFromFilePath(String fileName) {
        String actualName = fileName;
        if (fileName.lastIndexOf(UNIX_FILE_SEP) > 0) {
            actualName = fileName.substring(fileName.lastIndexOf(UNIX_FILE_SEP) + 1);
        } else if (fileName.lastIndexOf(WIN_FILE_SEP) > 0) {
            actualName = fileName.substring(fileName.lastIndexOf(WIN_FILE_SEP) + 1);
        }
        return actualName;
    }

    public static FileLoadCompleted createFileLoadComplete(int seqNumber, String fileTobeTransferred) {
        return new FileLoadCompleted(seqNumber, new String[]{fileTobeTransferred}, 119);
    }

    public static void sendAbortMessageToBTS(BTSConnection connection, int seqNumber, String fileTobeTransferred) {
        FileLoadCompleted cancelReq = LogFileUtils.createFileLoadComplete(seqNumber, fileTobeTransferred);
        cancelReq.setCause(120);
        connection.sendToBTS((BTSMessage)cancelReq);
    }

    public static void processDiskSpaceException(BTSConnection connection, int seqNumber, String fileTobeTransferred, Exception exception) throws DiskSpaceException {
        DiskSpaceChecker checker = new DiskSpaceChecker.Builder((Throwable)exception).build();
        if (checker.getCause() instanceof DiskSpaceException) {
            LogFileUtils.sendAbortMessageToBTS(connection, seqNumber, fileTobeTransferred);
            throw (DiskSpaceException)checker.getCause();
        }
    }
}

