/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.RadParamsGetRequest;
import com.nokia.em.bts.coreasset.message.RadParamsGetResponse;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.AbstractRADParamsGetScenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParamsListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import java.util.List;

public class RadParamsGetScenario
extends AbstractRADParamsGetScenario {
    private RadParamsListener myListener;
    private int mySeqNumber;
    private boolean myIsAborted;

    public RadParamsGetScenario(BTSConnection connection, RadParamsListener listener, String btsSwSC) {
        super(connection, btsSwSC);
        this.myListener = listener;
    }

    public RadParamsGetScenario(BTSConnection connection, RadParamsListener listener, String btsSwSC, BTSMessage.Type type) {
        this(connection, listener, btsSwSC);
        this.myType = type;
    }

    public RadParamsGetScenario(BTSConnection connection, RadParamsListener listener, BTSMessage.Type type, String btsSwSC, List<Integer> paramIndexNumbers) {
        this(connection, listener, btsSwSC, type);
        this.myParamIndexNumbers = paramIndexNumbers;
    }

    @Override
    protected Object runScenario() {
        this.myLogger.debug((Object)"Worker construct.");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"No snapshot.");
            this.myListener.paramsGetFailed(85);
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        RadParamsGetRequest radParamsGetRequest = new RadParamsGetRequest(this.mySeqNumber, this.myBtsSwSC, this.myType, this.myParamIndexNumbers);
        this.myConnection.sendToBTS((BTSMessage)radParamsGetRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (this.myIsAborted) {
            this.myLogger.debug((Object)"Worker construct end.");
            return true;
        }
        if (response instanceof RadParamsGetResponse) {
            RadParamsGetResponse radResponse = (RadParamsGetResponse)response;
            this.myLogger.debug((Object)"Params get successful.");
            this.myListener.paramsGetSuccessful(radResponse.getRadParams());
        } else if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Rad params get timed out.");
            this.myListener.paramsGetFailed(68);
        } else {
            this.myLogger.debug((Object)"Got invalid message or broken connection.");
            this.myListener.paramsGetFailed(28);
        }
        this.myLogger.debug((Object)"Worker construct end.");
        return true;
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"Abort for fetch scenario");
        this.myConnection.deleteScenario(this.mySeqNumber);
        this.myIsAborted = true;
        return true;
    }
}

