/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.RadParamsSetRequest;
import com.nokia.em.bts.coreasset.message.RadParamsSetResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParam;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParamsListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RadParamsSetScenario
implements Scenario {
    private BTSConnection myConnection;
    private RadParamsListener myListener;
    private List<RadParam> myRadParams;
    private String mySettingType = "Coreasset_Unknown";
    private boolean myRunning = false;
    private String myBtsSwSC = null;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private int mySeqNumber;

    public RadParamsSetScenario(BTSConnection connection, RadParamsListener listener, String btsSwSC, int settingType, Map<Long, Long> radParams) {
        this(connection, listener, settingType, null);
        this.myRadParams = new ArrayList<RadParam>();
        if (!btsSwSC.equals("hwApi")) {
            this.myLogger.warn((Object)("Possibly wrong parameter from GUI, " + btsSwSC));
        }
        for (long key : radParams.keySet()) {
            long value = radParams.get(key);
            this.myRadParams.add(new RadParam(key, value, btsSwSC));
        }
    }

    public RadParamsSetScenario(BTSConnection connection, RadParamsListener listener, String btsSwSC, int settingType, Map<Long, Long> radParams, BTSMessage.Type type) {
        this(connection, listener, btsSwSC, settingType, radParams);
        this.myType = type;
    }

    public RadParamsSetScenario(BTSConnection connection, RadParamsListener radParamsListener, int settingType, List<RadParam> radParams) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = radParamsListener;
        this.myRadParams = radParams;
        this.setSettingType(settingType);
    }

    public RadParamsSetScenario(BTSConnection connection, RadParamsListener radParamsListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = radParamsListener;
        this.myBtsSwSC = null;
        this.myRadParams = null;
        this.setSettingType(1);
    }

    public RadParamsSetScenario(BTSConnection connection, RadParamsListener radParamsListener, int settingType, List<RadParam> radParams, BTSMessage.Type type) {
        this(connection, radParamsListener, settingType, radParams);
        this.myType = type;
    }

    public RadParamsSetScenario(BTSConnection connection, RadParamsListener listener, String btsSwSC) {
        this(connection, listener, 1, null);
        this.myBtsSwSC = btsSwSC;
    }

    public RadParamsSetScenario(BTSConnection connection, RadParamsListener listener, String btsSwSC, BTSMessage.Type type) {
        this(connection, listener, 1, null);
        this.myBtsSwSC = btsSwSC;
        this.myType = type;
    }

    private void setSettingType(int settingType) {
        if (settingType == 1) {
            this.mySettingType = "factoryDefaults";
        } else if (settingType == 2) {
            this.mySettingType = "dynamicChanges";
        } else if (settingType == 3) {
            this.mySettingType = "persistentChanges";
        } else if (settingType == 4) {
            this.mySettingType = "persistentOverOneReset";
        } else {
            this.myLogger.error((Object)("Invalid settingType, " + settingType + ". Sending '" + "Coreasset_Unknown" + "' to BTS anyway, but results can't be predicted."));
        }
    }

    @Override
    public void execute() {
        this.myLogger.trace((Object)"Executing.");
        if (this.myRunning) {
            this.myLogger.debug((Object)"Illegal state.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        if (this.myRadParams == null && this.myBtsSwSC == null) {
            this.restoreAllValuesAcrossAllDomains();
        } else {
            this.executeStandardSettingScenario();
        }
    }

    private void restoreAllValuesAcrossAllDomains() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return RadParamsSetScenario.this.runRestoreAllScenario();
            }

            protected void finished() {
                RadParamsSetScenario.this.myLogger.debug((Object)"Worker finished.");
                RadParamsSetScenario.this.myConnection.deleteScenario(RadParamsSetScenario.this.mySeqNumber);
                RadParamsSetScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    private void executeStandardSettingScenario() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return RadParamsSetScenario.this.runScenario();
            }

            protected void finished() {
                RadParamsSetScenario.this.myLogger.debug((Object)"Worker finished.");
                RadParamsSetScenario.this.myConnection.deleteScenario(RadParamsSetScenario.this.mySeqNumber);
                RadParamsSetScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"GUI tried to abort, not supported in this scenario.");
        return true;
    }

    private Set<String> getSWSCs(List<RadParam> radParams) {
        HashSet<String> swScs = new HashSet<String>();
        if (radParams != null) {
            for (RadParam someRadParam : radParams) {
                swScs.add(someRadParam.getBtsSWSC());
            }
        } else {
            swScs.add(this.myBtsSwSC);
        }
        return swScs;
    }

    private List<RadParam> getRadParams(String swSc, List<RadParam> allRadParams) {
        LinkedList<RadParam> radParams = new LinkedList<RadParam>();
        if (allRadParams != null) {
            for (RadParam someRadParam : allRadParams) {
                if (!someRadParam.getBtsSWSC().equals(swSc)) continue;
                radParams.add(someRadParam);
            }
        }
        return radParams;
    }

    private boolean isError(int result) {
        return result == 28 || result == 68 || result == 117;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    protected Object runScenario() {
        this.myLogger.debug((Object)"Worker construct.");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"No snapshot.");
            this.myListener.paramsSet(85);
            return true;
        }
        Set<String> swScs = this.getSWSCs(this.myRadParams);
        int result = -1;
        for (String someSwSc : swScs) {
            List<RadParam> radParams = this.getRadParams(someSwSc, this.myRadParams);
            this.mySeqNumber = this.myConnection.createScenario();
            RadParamsSetRequest radParamsSetRequest = new RadParamsSetRequest(this.mySeqNumber, someSwSc, this.mySettingType, radParams, this.myType);
            result = this.processSetRequest(radParamsSetRequest);
            if (this.isError(result)) break;
        }
        this.myListener.paramsSet(result);
        this.myLogger.debug((Object)"Worker construct end.");
        return true;
    }

    protected Object runRestoreAllScenario() {
        this.myLogger.debug((Object)"Worker construct.");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Not applicable in snapshot.");
            this.myListener.paramsSet(85);
            return true;
        }
        int result = -1;
        this.mySeqNumber = this.myConnection.createScenario();
        RadParamsSetRequest radParamsSetRequest = new RadParamsSetRequest(this.mySeqNumber, this.mySettingType, this.myType);
        result = this.processSetRequest(radParamsSetRequest);
        this.myListener.paramsSet(result);
        this.myLogger.debug((Object)"Worker construct end.");
        return true;
    }

    private int processSetRequest(RadParamsSetRequest radParamsSetRequest) {
        this.myConnection.sendToBTS((BTSMessage)radParamsSetRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof RadParamsSetResponse) {
            RadParamsSetResponse radResponse = (RadParamsSetResponse)response;
            this.myLogger.debug((Object)"Params set resp received.");
            return radResponse.getSuccess();
        }
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Rad params set timed out.");
            return 68;
        }
        this.myLogger.debug((Object)"Got invalid message or broken connection.");
        return 28;
    }
}

