/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.UploadBTSTechLogCancelRequest;
import com.nokia.em.bts.coreasset.message.UploadBTSTechLogRequest;
import com.nokia.em.bts.coreasset.message.UploadBTSTechLogResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.BTSLogListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileDescriptor;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ZipperThread;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RequestTechLogFilesScenario
implements Scenario {
    private BTSConnection myConnection;
    private FileTransferListener myFileTransferListener;
    private BTSLogListener myBTSLogListener;
    private String myLogCoverage;
    private String myFileName;
    private boolean myRunning = false;
    private boolean blnLastMsg = false;
    private boolean blnFirstMsg = true;
    private boolean blnFirstAck = true;
    private boolean myUseThreads = false;
    private static final int LOG_TIMEOUT = 650000;
    private static final int TIMER_COUNTER = 1;
    private static final String UNIX_FILE_SEP = "/";
    private static final String WIN_FILE_SEP = "\\";
    private int intTimerCounter = 0;
    private int mySeqNumber;
    private FileTransferClient myFtpClientAdapter;
    private Map myZipperMapping = Collections.synchronizedMap(new HashMap());
    private ActionListener myTimerActionListener = null;
    private boolean blnIsCancelled;
    private Logger myLogger;
    private List<String> myModules;
    private boolean mySendCancelOnAbort = false;
    private boolean myIsWillZipFiles = true;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public RequestTechLogFilesScenario(BTSConnection connection, BTSLogListener btsLogListener, FileTransferListener fileTransferListener, String strLogCoverage, String strFileName, boolean blnUseThreads, boolean sendCancelRequestOnAbort) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFileTransferListener = fileTransferListener;
        this.myBTSLogListener = btsLogListener;
        this.myLogCoverage = strLogCoverage;
        this.myFileName = strFileName;
        this.myUseThreads = blnUseThreads;
        this.mySendCancelOnAbort = sendCancelRequestOnAbort;
        this.myTimerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (RequestTechLogFilesScenario.this.intTimerCounter < 0) {
                    RequestTechLogFilesScenario requestTechLogFilesScenario = RequestTechLogFilesScenario.this;
                    requestTechLogFilesScenario.intTimerCounter = requestTechLogFilesScenario.intTimerCounter + 1;
                } else {
                    RequestTechLogFilesScenario.this.intTimerCounter = 0;
                    RequestTechLogFilesScenario.this.myFileTransferListener.fileSetTransferFailed(68);
                    RequestTechLogFilesScenario.this.abort();
                }
            }
        };
    }

    public RequestTechLogFilesScenario(BTSConnection connection, BTSLogListener btsLogListener, FileTransferListener fileTransferListener, String strLogCoverage, String strFileName, boolean blnUseThreads, boolean sendCancelRequestOnAbort, BTSMessage.Type type) {
        this(connection, btsLogListener, fileTransferListener, strLogCoverage, strFileName, blnUseThreads, sendCancelRequestOnAbort);
        this.myType = type;
    }

    public RequestTechLogFilesScenario(BTSConnection connection, BTSLogListener btsLogListener, FileTransferListener fileTransferListener, String strLogCoverage, String strFileName, boolean blnUseThreads, List<String> modules, boolean sendCancelRequestOnAbort) {
        this(connection, btsLogListener, fileTransferListener, strLogCoverage, strFileName, blnUseThreads, sendCancelRequestOnAbort);
        this.myModules = modules;
    }

    public RequestTechLogFilesScenario(BTSConnection connection, BTSLogListener btsLogListener, FileTransferListener fileTransferListener, String strLogCoverage, String strFileName, boolean blnUseThreads, List<String> modules, boolean sendCancelRequestOnAbort, BTSMessage.Type type) {
        this(connection, btsLogListener, fileTransferListener, strLogCoverage, strFileName, blnUseThreads, modules, sendCancelRequestOnAbort);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.blnFirstAck = true;
        this.blnFirstMsg = true;
        this.blnLastMsg = false;
        this.blnIsCancelled = false;
        final LinkedList lstLogFiles = new LinkedList();
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    RequestTechLogFilesScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    RequestTechLogFilesScenario.this.myFileTransferListener.fileSetTransferFailed(85);
                    return true;
                }
                int seqNumber = RequestTechLogFilesScenario.this.myConnection.createScenario();
                RequestTechLogFilesScenario.this.setTechLogSequenceNumber(seqNumber);
                ZipperThread zipper = null;
                while (!RequestTechLogFilesScenario.this.blnLastMsg && RequestTechLogFilesScenario.this.intTimerCounter < 1 && !RequestTechLogFilesScenario.this.blnIsCancelled) {
                    UploadBTSTechLogRequest techLogRequest = RequestTechLogFilesScenario.this.myModules == null ? new UploadBTSTechLogRequest(seqNumber, RequestTechLogFilesScenario.this.myLogCoverage, RequestTechLogFilesScenario.this.blnFirstMsg) : new UploadBTSTechLogRequest(seqNumber, RequestTechLogFilesScenario.this.myLogCoverage, RequestTechLogFilesScenario.this.blnFirstMsg, RequestTechLogFilesScenario.this.myModules);
                    if (RequestTechLogFilesScenario.this.blnFirstMsg) {
                        RequestTechLogFilesScenario.this.blnFirstMsg = false;
                    }
                    RequestTechLogFilesScenario.this.myConnection.sendToBTS((BTSMessage)techLogRequest);
                    TimerService.getInstance().startTimer(RequestTechLogFilesScenario.this.myTimerActionListener, 650000L);
                    BTSMessage response = RequestTechLogFilesScenario.this.myConnection.receiveFromBTS(seqNumber);
                    if (response instanceof Ack) {
                        Ack ackResponse = (Ack)response;
                        if (ackResponse.getAck()) {
                            if (RequestTechLogFilesScenario.this.blnFirstAck) {
                                RequestTechLogFilesScenario.this.myFileTransferListener.fileSetTransferStarted();
                                RequestTechLogFilesScenario.this.blnFirstAck = false;
                            }
                            response = RequestTechLogFilesScenario.this.myConnection.receiveFromBTS(seqNumber);
                            RequestTechLogFilesScenario.this.intTimerCounter = 0;
                            if (response instanceof UploadBTSTechLogResponse) {
                                FTPTransferInfo ftpInfo;
                                UploadBTSTechLogResponse techLogResponse;
                                block32: {
                                    if (RequestTechLogFilesScenario.this.myTimerActionListener != null) {
                                        TimerService.getInstance().stopTimer(RequestTechLogFilesScenario.this.myTimerActionListener);
                                    }
                                    if (zipper == null) {
                                        zipper = new ZipperThread(RequestTechLogFilesScenario.this.myFileTransferListener, RequestTechLogFilesScenario.this.myBTSLogListener, RequestTechLogFilesScenario.this.myFileName, RequestTechLogFilesScenario.this.myConnection.getBTSId(), RequestTechLogFilesScenario.this.myIsWillZipFiles);
                                        int priority = zipper.getPriority() - 1;
                                        if (priority >= 1) {
                                            zipper.setPriority(priority);
                                        }
                                        RequestTechLogFilesScenario.this.myZipperMapping.put(seqNumber, new WeakReference<ZipperThread>(zipper));
                                        if (RequestTechLogFilesScenario.this.myUseThreads) {
                                            zipper.start();
                                        }
                                    }
                                    File tempGZIPFile = null;
                                    techLogResponse = (UploadBTSTechLogResponse)response;
                                    ftpInfo = null;
                                    try {
                                        ftpInfo = techLogResponse.getFTPTransferInfo();
                                        if (ftpInfo != null) {
                                            String strFileId = ftpInfo.getFileId();
                                            if (strFileId != null && strFileId.trim().length() != 0) {
                                                if (strFileId.lastIndexOf(RequestTechLogFilesScenario.UNIX_FILE_SEP) > 0) {
                                                    strFileId = strFileId.substring(strFileId.lastIndexOf(RequestTechLogFilesScenario.UNIX_FILE_SEP) + 1);
                                                } else if (strFileId.lastIndexOf(RequestTechLogFilesScenario.WIN_FILE_SEP) > 0) {
                                                    strFileId = strFileId.substring(strFileId.lastIndexOf(RequestTechLogFilesScenario.WIN_FILE_SEP) + 1);
                                                }
                                                String actualTechLogFileName = strFileId;
                                                RequestTechLogFilesScenario.this.myFtpClientAdapter = RequestTechLogFilesScenario.this.myConnection.getFileTransferFactory().getFileTransferClient();
                                                RequestTechLogFilesScenario.this.myFtpClientAdapter.setFTPTransferInfo(ftpInfo);
                                                tempGZIPFile = RequestTechLogFilesScenario.this.myFtpClientAdapter.getFile(RequestTechLogFilesScenario.this.myFileTransferListener);
                                                if (tempGZIPFile != null) {
                                                    LogFileDescriptor descriptor = new LogFileDescriptor(actualTechLogFileName, tempGZIPFile);
                                                    if (RequestTechLogFilesScenario.this.myUseThreads) {
                                                        zipper.add(descriptor);
                                                    } else {
                                                        lstLogFiles.add(descriptor);
                                                    }
                                                }
                                            } else {
                                                RequestTechLogFilesScenario.this.myLogger.debug((Object)"Null fileId received, aborting.");
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        RequestTechLogFilesScenario.this.myLogger.debug((Object)("unable to get file: " + e));
                                        if (ftpInfo == null) break block32;
                                        try {
                                            RequestTechLogFilesScenario.this.myFileTransferListener.fileTransferFailed(ftpInfo.getFileId());
                                        }
                                        catch (Exception e1) {
                                            RequestTechLogFilesScenario.this.myLogger.error((Object)("error notifying listener: " + e1));
                                        }
                                    }
                                }
                                if (ftpInfo != null && ftpInfo.getFileId() != null) {
                                    RequestTechLogFilesScenario.this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(seqNumber, new String[]{ftpInfo.getFileId()}));
                                }
                                if (!techLogResponse.isLastMsg()) continue;
                                RequestTechLogFilesScenario.this.blnLastMsg = true;
                                if (RequestTechLogFilesScenario.this.myUseThreads) {
                                    RequestTechLogFilesScenario.this.joinZipper(zipper, true, seqNumber);
                                } else {
                                    boolean transferOk = false;
                                    while (!lstLogFiles.isEmpty()) {
                                        LogFileDescriptor tempFile = (LogFileDescriptor)lstLogFiles.remove(0);
                                        zipper.gunzip(RequestTechLogFilesScenario.this.myBTSLogListener, tempFile);
                                        boolean zipOk = zipper.zipFile(RequestTechLogFilesScenario.this.myBTSLogListener, tempFile);
                                        if (!zipOk) continue;
                                        transferOk = true;
                                    }
                                    if (transferOk) {
                                        zipper.transferOk();
                                    } else {
                                        zipper.transferFailed();
                                    }
                                    zipper.closeFile();
                                    zipper.done(true);
                                }
                                return true;
                            }
                            if (response == null) {
                                RequestTechLogFilesScenario.this.myLogger.debug((Object)"response is null, user cancelled scenario");
                                return false;
                            }
                            RequestTechLogFilesScenario.this.myFileTransferListener.fileSetTransferFailed(28);
                            RequestTechLogFilesScenario.this.myLogger.error((Object)("Wrong reply received from BTS. UploadBTSTechLogResponse or Ack expected, " + response.getClass() + " received."));
                            return false;
                        }
                        RequestTechLogFilesScenario.this.myFileTransferListener.fileSetTransferFailed(ackResponse.getNackReason());
                        RequestTechLogFilesScenario.this.myLogger.debug((Object)"Nack was received.");
                        return false;
                    }
                    if (response == null) {
                        RequestTechLogFilesScenario.this.myLogger.debug((Object)"response is null, user cancelled scenario");
                        return false;
                    }
                    RequestTechLogFilesScenario.this.myFileTransferListener.fileSetTransferFailed(28);
                    RequestTechLogFilesScenario.this.myLogger.debug((Object)("Wrong reply received from BTS. Ack expected, " + response.getClass() + " received."));
                    return false;
                }
                RequestTechLogFilesScenario.this.joinZipper(zipper, true, seqNumber);
                return true;
            }

            protected void finished() {
                RequestTechLogFilesScenario.this.myConnection.deleteScenario(RequestTechLogFilesScenario.this.mySeqNumber);
                RequestTechLogFilesScenario.this.myRunning = true;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (!this.blnIsCancelled) {
            ZipperThread zipper;
            this.myLogger.debug((Object)"Abort called.");
            if (CoreAsset.isSnapshotOpening()) {
                return true;
            }
            this.blnIsCancelled = true;
            if (this.myConnection == null || this.myFileTransferListener == null) {
                this.myLogger.debug((Object)"BTS connection or File transfer listener is null");
                return true;
            }
            try {
                this.myFtpClientAdapter.abort();
            }
            catch (Exception e) {
                this.myLogger.debug((Object)"Error in cancelling technical log files creation: ", (Throwable)e);
            }
            int seqNbrToCancel = this.getTechLogSequenceNumber();
            if (this.mySendCancelOnAbort && !this.blnFirstMsg) {
                this.myConnection.sendToBTS((BTSMessage)new UploadBTSTechLogCancelRequest(seqNbrToCancel));
            }
            this.myConnection.interruptScenario(seqNbrToCancel);
            this.myConnection.deleteScenario(seqNbrToCancel);
            this.myFileTransferListener.fileSetTransferCancelled();
            WeakReference weakReference = (WeakReference)this.myZipperMapping.get(seqNbrToCancel);
            if (weakReference != null && (zipper = (ZipperThread)((Object)weakReference.get())) != null) {
                this.joinZipper(zipper, true, seqNbrToCancel);
            }
            if (this.myTimerActionListener != null) {
                TimerService.getInstance().stopTimer(this.myTimerActionListener);
            }
        } else {
            this.myLogger.debug((Object)"Abort called but already aborted. Ignoring.");
        }
        return true;
    }

    private void setTechLogSequenceNumber(int intSeqNumber) {
        this.mySeqNumber = intSeqNumber;
    }

    private int getTechLogSequenceNumber() {
        return this.mySeqNumber;
    }

    private void joinZipper(ZipperThread zipper, boolean saveFile, int seqNbr) {
        try {
            if (zipper != null) {
                if (!zipper.isStarted()) {
                    zipper.closeFile();
                }
                zipper.done(saveFile);
                zipper.join();
            }
        }
        catch (InterruptedException e) {
            this.myLogger.debug((Object)"Interrupted", (Throwable)e);
        }
        this.myZipperMapping.remove(seqNbr);
    }

    public void setWillZipFiles(boolean willZip) {
        this.myIsWillZipFiles = willZip;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

