/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeRequest;
import com.nokia.em.bts.coreasset.message.ExtendedLoggingModeResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.ExtendedLoggingListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LoggingCategory;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class SetExtendedLoggingCategoriesScenario
implements Scenario {
    private BTSConnection myConnection;
    private ExtendedLoggingListener myListener;
    private List<LoggingCategory> myCategories;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private int mySeqNumber;

    public SetExtendedLoggingCategoriesScenario(BTSConnection connection, ExtendedLoggingListener listener, List<LoggingCategory> categories) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = listener;
        this.myCategories = categories;
    }

    public SetExtendedLoggingCategoriesScenario(BTSConnection connection, ExtendedLoggingListener listener, List<LoggingCategory> categories, BTSMessage.Type type) {
        this(connection, listener, categories);
        this.myType = type;
    }

    @Override
    public void execute() {
        this.myLogger.trace((Object)"Executing.");
        if (this.myRunning) {
            this.myLogger.debug((Object)"Illegal state.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SetExtendedLoggingCategoriesScenario.this.runScenario();
            }

            protected void finished() {
                SetExtendedLoggingCategoriesScenario.this.myLogger.debug((Object)"Worker finished.");
                SetExtendedLoggingCategoriesScenario.this.myConnection.deleteScenario(SetExtendedLoggingCategoriesScenario.this.mySeqNumber);
                SetExtendedLoggingCategoriesScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        this.myLogger.debug((Object)"Worker construct.");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"No snapshot support.");
            this.myListener.getCategoriesFailed(85);
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        this.myConnection.sendToBTS((BTSMessage)new ExtendedLoggingModeRequest(this.mySeqNumber, this.myCategories, this.myType));
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof ExtendedLoggingModeResponse) {
            ExtendedLoggingModeResponse loggingResponse = (ExtendedLoggingModeResponse)response;
            List<LoggingCategory> categories = loggingResponse.getLoggingCategories();
            List categoriesToProcess = categories.stream().filter(category -> this.getRequestCategoryTypes().contains(category.getCategory())).collect(Collectors.toList());
            if (categoriesToProcess.isEmpty()) {
                this.myLogger.debug((Object)"Got invalid logging category");
                this.myListener.setCategoriesFailed(28);
                return true;
            }
            for (LoggingCategory category2 : categoriesToProcess) {
                if ("TtiTracelog".equalsIgnoreCase(category2.getCategory())) {
                    this.processExtendedLoggingModeResponseForTtiTrace(loggingResponse, categories);
                    return true;
                }
                if (!"AaSyslog".equalsIgnoreCase(category2.getCategory()) && !"AaTracelog".equalsIgnoreCase(category2.getCategory())) continue;
                this.processExtendedLoggingModeResponse(loggingResponse, categories);
                return true;
            }
        } else if (response instanceof Ack) {
            this.myLogger.debug((Object)"Setting logging categories failed.");
            this.myListener.setCategoriesFailed(((Ack)response).getNackReason());
        } else if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Setting logging categories timeouted.");
            this.myListener.setCategoriesFailed(68);
        } else {
            this.myLogger.debug((Object)"Got invalid message or broken connection.");
            this.myListener.setCategoriesFailed(28);
        }
        return true;
    }

    private String getRequestCategoryTypes() {
        String requestCategoryTypes = "";
        for (LoggingCategory category : this.myCategories) {
            requestCategoryTypes = String.valueOf(requestCategoryTypes) + category.getCategory() + "|";
        }
        return requestCategoryTypes;
    }

    private void processExtendedLoggingModeResponse(ExtendedLoggingModeResponse loggingResponse, List<LoggingCategory> categories) {
        if (loggingResponse.hasFailureCause()) {
            this.myListener.setCategoriesPartialFailed(categories);
            this.myLogger.error((Object)"Setting extended logging categories failed.");
        } else {
            this.myLogger.debug((Object)"Setting logging categories successful.");
            this.myListener.setCategoriesSuccessful(categories);
        }
    }

    private void processExtendedLoggingModeResponseForTtiTrace(ExtendedLoggingModeResponse loggingResponse, List<LoggingCategory> categories) {
        if (loggingResponse.hasFailureCause()) {
            this.myListener.setCategoriesFailed(categories);
            this.myLogger.error((Object)"Setting extended logging categories failed.");
        } else {
            this.myLogger.debug((Object)"Setting logging categories successful.");
            this.myListener.setCategoriesSuccessful(categories);
        }
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"GUI tried to abort, not supported in this scenario.");
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

