/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.techlogfiles;

import com.nokia.em.bts.coreasset.scenario.techlogfiles.BTSLogListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileDecompressor;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.LogFileDescriptor;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public final class ZipperThread
extends CachedThread {
    private BiPredicate<String, Integer> myFileNameChecker;
    private final List myLogFiles = new ArrayList();
    private final BTSLogListener myBTSLogListener;
    private final FileTransferListener myFileTransferListener;
    private final File myZipFile;
    private ZipOutputStream myZipOutputStream;
    private BufferedOutputStream myBufferedOutputStream;
    private static final int COMPRESS_LEVEL = 9;
    private static final byte[] BUF = new byte[4096];
    private boolean myShouldStop = false;
    private boolean mySave = false;
    private boolean myIsStarted = false;
    private static Object myZipMonitor = new Object();
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass());
    private int myBTSId;
    private boolean myIsWillZipFiles = true;
    private static final String ROOT_DIRECTORY = new File(File.separator).getAbsolutePath();

    public ZipperThread(FileTransferListener fileTransferListener, BTSLogListener BTSLogListener2, String fileName, int btsId) {
        this(fileTransferListener, BTSLogListener2, fileName, btsId, true);
    }

    public ZipperThread(FileTransferListener fileTransferListener, BTSLogListener btsLogListener, String fileName, int btsId, boolean willZipFiles) {
        this.myFileTransferListener = fileTransferListener;
        this.myBTSLogListener = btsLogListener;
        this.myBTSId = btsId;
        this.myZipFile = new File(fileName);
        if (!this.myZipFile.exists() && this.myZipFile.getParentFile() != null && !this.myZipFile.getParentFile().mkdirs()) {
            this.myLogger.error((Object)"Failed to create directory for the zip file");
        }
        this.myIsWillZipFiles = willZipFiles;
    }

    public ZipperThread(FileTransferListener fileTransferListener, BTSLogListener btsLogListener, String fileName, int btsId, boolean willZipFiles, BiPredicate<String, Integer> fileNameChecker) {
        this(fileTransferListener, btsLogListener, fileName, btsId, willZipFiles);
        this.myFileNameChecker = fileNameChecker;
    }

    public File getZipFile() {
        return this.myZipFile;
    }

    public boolean isStarted() {
        return this.myIsStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block19: {
            this.myLogger.debug((Object)"run start.");
            this.myIsStarted = true;
            try {
                try {
                    boolean transferOk = false;
                    block9: while (true) {
                        try {
                            while (true) {
                                ZipperThread zipperThread = this;
                                synchronized (zipperThread) {
                                    while (this.myLogFiles.isEmpty() && !this.myShouldStop) {
                                        ((Object)((Object)this)).wait();
                                    }
                                    if (this.myLogFiles.isEmpty() && this.myShouldStop) {
                                        break block9;
                                    }
                                }
                                LogFileDescriptor tempFile = (LogFileDescriptor)this.myLogFiles.remove(0);
                                this.gunzip(this.myBTSLogListener, tempFile);
                                if (!this.zipFile(this.myBTSLogListener, tempFile)) continue;
                                transferOk = true;
                            }
                        }
                        catch (Exception e) {
                            this.myLogger.error((Object)"File zipping failed", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                    if (transferOk) {
                        this.closeFile();
                        this.transferOk();
                    } else if (this.mySave) {
                        this.transferFailed();
                    }
                    if (!this.mySave) {
                        this.closeFile();
                        if (!this.myZipFile.delete()) {
                            this.myZipFile.deleteOnExit();
                        }
                    }
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Error in extracting and packing retrieved technical log files:", (Throwable)e);
                    this.closeFile();
                    break block19;
                }
            }
            catch (Throwable throwable) {
                this.closeFile();
                throw throwable;
            }
            this.closeFile();
        }
        this.myLogger.debug((Object)"run end.");
    }

    public void closeFile() {
        try {
            if (this.myBufferedOutputStream != null) {
                this.myBufferedOutputStream.close();
            }
        }
        catch (IOException e) {
            this.myLogger.error((Object)"closing file: ", (Throwable)e);
        }
    }

    public void transferFailed() {
        this.myFileTransferListener.fileSetTransferFailed(304);
    }

    public void transferOk() {
        this.myFileTransferListener.fileSetTransferCompleted(this.myZipFile.getAbsolutePath());
    }

    public synchronized void add(LogFileDescriptor file) {
        this.myLogFiles.add(file);
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * Exception decompiling
     */
    public boolean zipFile(BTSLogListener btsLogListener, LogFileDescriptor file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeZipOutput() throws FileNotFoundException {
        this.myZipOutputStream = new ZipOutputStream(new FileOutputStream(this.myZipFile));
        this.myZipOutputStream.setLevel(9);
        this.myBufferedOutputStream = new BufferedOutputStream(this.myZipOutputStream);
    }

    private void addZipEntry(String filename) throws IOException {
        ZipEntry entry = new ZipEntry(filename);
        this.myZipOutputStream.putNextEntry(entry);
    }

    private File initializeBTSLogFile(LogFileDescriptor file, String filename, String copyFilePath) {
        File createNewBTSLogFile = new File(String.valueOf(copyFilePath) + File.separator + filename);
        if (createNewBTSLogFile.exists()) {
            this.myLogger.warn((Object)("File " + filename + " from " + file.getOriginalName() + " is already exisiting."));
        }
        return createNewBTSLogFile;
    }

    private BufferedOutputStream initializeBTSLogFileBOS(File createNewBTSLogFile) throws IOException {
        BufferedOutputStream currentBTSLogFileBOS = null;
        if (createNewBTSLogFile.createNewFile()) {
            currentBTSLogFileBOS = new BufferedOutputStream(new FileOutputStream(createNewBTSLogFile));
        } else {
            this.myLogger.debug((Object)("Cannot create file: " + createNewBTSLogFile.getName()));
        }
        return currentBTSLogFileBOS;
    }

    private long processCopy(BTSLogListener btsLogListener, long lTotalLenght, BufferedOutputStream currentBTSLogFileBOS, int length, long totallength) throws IOException {
        float fPercentage = 0.0f;
        long result = totallength + (long)length;
        if (btsLogListener != null) {
            fPercentage = (float)result / (float)lTotalLenght * 100.0f;
            btsLogListener.fileZipUpdated(fPercentage);
        }
        if (this.myBufferedOutputStream != null && this.myIsWillZipFiles) {
            this.myBufferedOutputStream.write(BUF, 0, length);
        } else if (currentBTSLogFileBOS != null) {
            currentBTSLogFileBOS.write(BUF, 0, length);
        }
        return result;
    }

    private void flushStream(BufferedOutputStream currentBTSLogFileBOS) throws IOException {
        if (this.myBufferedOutputStream != null && this.myIsWillZipFiles) {
            this.myBufferedOutputStream.flush();
        } else if (currentBTSLogFileBOS != null) {
            currentBTSLogFileBOS.flush();
        }
    }

    public boolean gunzip(BTSLogListener btsLogListener, LogFileDescriptor logFileDescriptor) {
        block6: {
            try {
                if (logFileDescriptor != null && logFileDescriptor.getTempFile() != null) break block6;
                return false;
            }
            catch (IOException e) {
                if (btsLogListener != null) {
                    btsLogListener.fileGunzipFailed(logFileDescriptor.getOriginalName());
                }
                this.myLogger.error((Object)("Failed to decompress file " + logFileDescriptor.getRealName()), (Throwable)e);
                return false;
            }
        }
        LogFileDecompressor lfd = new LogFileDecompressor(logFileDescriptor.getTempFile(), logFileDescriptor.getOriginalName(), this.myBTSId, this.myIsWillZipFiles, this.myFileNameChecker);
        List<File> list = lfd.getFiles();
        logFileDescriptor.setUnpackedFiles(list);
        if (list.size() > 0) {
            logFileDescriptor.setRealName(null);
        }
        if (btsLogListener != null) {
            btsLogListener.fileGunzipSucceeded(logFileDescriptor.getOriginalName());
        }
        return true;
    }

    protected synchronized void done(boolean save) {
        this.myShouldStop = true;
        this.mySave = save;
        ((Object)((Object)this)).notifyAll();
    }

    private void closeStreams(InputStream in, OutputStream out, String inName, String outName) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                this.myLogger.error((Object)("Closing file: " + inName + " failed (" + ioe.toString() + ")."));
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                this.myLogger.error((Object)("Closing file: " + outName + " failed (" + ioe.toString() + ")."));
            }
        }
    }
}

