/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.tool;

import java.util.TimeZone;

public final class JreBugFixer {
    public static final String SIMFEROPOL_TIMEZONE_ID = "Europe/Simferopol";
    public static final String KALININGRAD_TIMEZONE_ID = "Europe/Kaliningrad";
    public static final String GM_MINUS_2_TIMEZONE_ID = "Etc/GMT-2";
    public static final String GM_MINUS_3_TIMEZONE_ID = "Etc/GMT-3";
    public static final String GM_MINUS_TIMEZONE_ID = "Etc/GMT-";
    public static final String GM_PLUS_TIMEZONE_ID = "Etc/GMT+";

    private JreBugFixer() {
    }

    public static TimeZone getSimferopplTimeZone(float timeZoneOffset) {
        return JreBugFixer.getSpecificTimeZone(timeZoneOffset, GM_MINUS_3_TIMEZONE_ID);
    }

    public static TimeZone getKaliningradTimeZone(float timeZoneOffset) {
        return JreBugFixer.getSpecificTimeZone(timeZoneOffset, GM_MINUS_2_TIMEZONE_ID);
    }

    protected static TimeZone getSpecificTimeZone(float timeZoneOffset, String defaultTimeZoneID) {
        TimeZone tz = (double)Math.abs(timeZoneOffset - -999.0f) < 1.0E-8 ? TimeZone.getTimeZone(defaultTimeZoneID) : JreBugFixer.getTimeZone(timeZoneOffset);
        return tz;
    }

    public static TimeZone getTimeZone(float timeZoneOffset) {
        String tz = Float.toString(timeZoneOffset).replaceAll("[^1-9]", "");
        return TimeZone.getTimeZone(String.valueOf(timeZoneOffset > 0.0f ? GM_MINUS_TIMEZONE_ID : GM_PLUS_TIMEZONE_ID) + tz);
    }
}

