/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon;

import com.nokia.em.poseidon.plugin.application.Application;
import com.nokia.em.poseidon.plugin.application.ApplicationGrade;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.plugin.conf.Configuration;
import com.nokia.em.poseidon.plugin.conf.ConfigurationManager;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleManager;
import com.nokia.em.poseidon.plugin.object.ObjectRegistry;
import com.nokia.em.poseidon.plugin.operation.OperationRegistry;
import com.nokia.em.poseidon.plugin.properties.UserHomePropertyHandler;
import com.nokia.em.poseidon.plugin.registry.PluginRegistry;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.plugin.service.ServiceRegistry;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class PoseidonRuntime {
    protected Logger myLogger = Logger.getLogger(this.getClass());
    protected PCmdLineParams myParams;
    protected List<PluginRegistry> myRegistries;
    protected String myUserHomeDirectory;
    protected Map<String, Object> myRuntimeProperties = new HashMap<String, Object>();
    protected Set<PropertyChangeListener> myPropertyChangeListeners = new CopyOnWriteArraySet<PropertyChangeListener>();
    protected static PoseidonRuntime theInstance;

    protected PoseidonRuntime() {
        this.createRegistries();
        this.myLogger.trace("PoseidonRuntime initialized.");
    }

    public static synchronized PoseidonRuntime getRuntime() {
        if (theInstance == null) {
            theInstance = new PoseidonRuntime();
        }
        return theInstance;
    }

    public <T> T getService(Class<T> serviceInterface) {
        return this.getRegistry(ServiceRegistry.class).get(serviceInterface);
    }

    public <T> T getService(Class<T> serviceInterface, Object bundleId) {
        T result;
        ServiceRegistry registry = this.getRegistry(ServiceRegistry.class, bundleId);
        if (registry != null && (result = registry.get(serviceInterface)) != null) {
            return result;
        }
        return this.getService(serviceInterface);
    }

    public void addService(Service service, String name, boolean startService) {
        this.myLogger.debug("Adding service " + name + ". Implementing class: " + service.getClass());
        this.getRegistry(ServiceRegistry.class).add(name, service);
        if (startService) {
            this.getRegistry(ServiceRegistry.class).startService(service);
        }
    }

    public void addService(Service service, Object bundleId, String name, boolean startService) {
        this.myLogger.debug("Adding service " + name + "to bundle " + bundleId + ". Implementing class: " + service.getClass());
        ServiceRegistry registry = this.getRegistry(ServiceRegistry.class, bundleId);
        if (registry == null) {
            registry = new ServiceRegistry(bundleId);
            this.myRegistries.add(registry);
        }
        registry.add(name, service);
        if (startService) {
            registry.startService(service);
        }
    }

    public void removeService(Service service) {
        this.myLogger.debug("Removing service from service registry. Implementing class: " + service.getClass());
        this.getRegistry(ServiceRegistry.class).remove(service);
    }

    public void removeService(Service service, Object bundleId) {
        this.myLogger.debug("Removing service from service registry from bundle: " + bundleId + ". Implementing class: " + service.getClass());
        ServiceRegistry registry = this.getRegistry(ServiceRegistry.class, bundleId);
        if (registry != null) {
            registry.remove(service);
        }
    }

    public <T> List<T> getObjects(Class<T> objectInterface) {
        return this.getRegistry(ObjectRegistry.class).getAll(objectInterface);
    }

    public <T> List<T> getObjects(Class<T> objectInterface, Object bundleId) {
        ObjectRegistry registry = this.getRegistry(ObjectRegistry.class, bundleId);
        if (registry != null) {
            return registry.getAll(objectInterface);
        }
        return this.getObjects(objectInterface);
    }

    public <T> T getObject(Class<T> objectInterface) {
        return this.getRegistry(ObjectRegistry.class).get(objectInterface);
    }

    public <T> T getObject(Class<T> objectInterface, Object bundleId) {
        T result;
        ObjectRegistry registry = this.getRegistry(ObjectRegistry.class, bundleId);
        if (registry != null && (result = registry.get(objectInterface)) != null) {
            return result;
        }
        return this.getObject(objectInterface);
    }

    public void addObject(Object object) {
        this.myLogger.debug("Adding pojo to default bundle. Implementing class: " + object.getClass());
        this.getRegistry(ObjectRegistry.class).add(object);
    }

    public void addObject(Object object, Object bundleId) {
        this.myLogger.debug("Adding pojo to bundle" + bundleId + ". Implementing class: " + object.getClass());
        ObjectRegistry registry = this.getRegistry(ObjectRegistry.class, bundleId);
        if (registry == null) {
            registry = new ObjectRegistry(bundleId);
            this.myRegistries.add(registry);
        }
        registry.add(object);
    }

    public void removeObject(Object object) {
        this.myLogger.debug("Removing pojo from registry from default bundle. Implementing class: " + object.getClass());
        this.getRegistry(ObjectRegistry.class).remove(object);
    }

    public void removeObject(Object object, Object bundleId) {
        this.myLogger.debug("Removing pojo from registry from bundle " + bundleId + ". Implementing class: " + object.getClass());
        ObjectRegistry registry = this.getRegistry(ObjectRegistry.class, bundleId);
        if (registry != null) {
            registry.remove(object);
        }
    }

    public <T> T getApplication(Class<T> applicationClass) {
        return this.getRegistry(ApplicationRegistry.class).get(applicationClass);
    }

    public void addApplication(Application application, String appName, boolean startApplication) {
        this.myLogger.debug("Adding application " + appName + ". Implementing class: " + application.getClass());
        this.getRegistry(ApplicationRegistry.class).add(appName, application);
        if (startApplication) {
            LifecycleManager.getInstance().startApplication(appName);
        }
    }

    public void removeApplication(Application application) {
        this.myLogger.debug("Removin application from application registry. Implementing class: " + application.getClass());
        LifecycleManager.getInstance().closeApplication(application);
        this.getRegistry(ApplicationRegistry.class).remove(application);
    }

    public <T extends PluginRegistry> T getRegistry(Class<T> registryClass) {
        for (PluginRegistry registry : this.myRegistries) {
            if (!registryClass.isInstance(registry) || !registry.isDefault()) continue;
            return (T)registry;
        }
        return null;
    }

    public <T extends PluginRegistry> T getRegistry(Class<T> registryClass, Object bundleId) {
        if (bundleId == null) {
            return this.getRegistry(registryClass);
        }
        for (PluginRegistry registry : this.myRegistries) {
            if (!registryClass.isInstance(registry) || !registry.getBundleId().equals(bundleId)) continue;
            return (T)registry;
        }
        return this.createRegistries(registryClass, bundleId);
    }

    private <T extends PluginRegistry> T createRegistries(Class<T> registryClass, Object bundleId) {
        ServiceRegistry registry = null;
        if (registryClass.equals(ServiceRegistry.class)) {
            registry = new ServiceRegistry(bundleId);
            this.myRegistries.add(registry);
        }
        return (T)registry;
    }

    public <T> T getRuntimeProperty(String propertyKey) {
        Object value = this.myRuntimeProperties.get(propertyKey);
        if (value == null) {
            value = this.getPropertyFromApp(ApplicationGrade.MASTER, propertyKey);
        }
        if (value == null) {
            value = this.getPropertyFromApp(ApplicationGrade.SECONDARY, propertyKey);
        }
        return (T)value;
    }

    public void setRuntimeProperty(String key, Object value) {
        this.myLogger.trace("Setting property to Poseidon Runtime. Key: " + key + " Value: " + value);
        Object oldValue = this.myRuntimeProperties.put(key, value);
        if (oldValue == null || !oldValue.equals(value)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, key, oldValue, value);
            for (PropertyChangeListener listener : this.myPropertyChangeListeners) {
                listener.propertyChange(event);
            }
        }
    }

    public void clearRuntimeProperty(String key) {
        this.myLogger.trace("Removing property from Poseidon Runtime. Key: " + key);
        Object oldValue = this.myRuntimeProperties.remove(key);
        if (oldValue != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, key, oldValue, null);
            for (PropertyChangeListener listener : this.myPropertyChangeListeners) {
                listener.propertyChange(event);
            }
        }
    }

    public Map<String, Object> getRuntimeProperties() {
        return Collections.unmodifiableMap(this.myRuntimeProperties);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myLogger.trace("Adding PropertyChangeListener to Poseidon runtime: " + listener);
        this.myPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myLogger.trace("Removing PropertyChangeListener from Poseidon runtime: " + listener);
        this.myPropertyChangeListeners.remove(listener);
    }

    public PCmdLineParams getParameters() {
        return this.myParams;
    }

    public String getUserHome() {
        if (this.myUserHomeDirectory == null) {
            try {
                Configuration currentConfiguration = ConfigurationManager.getInstance().getCurrentConfiguration();
                List<String> userHome = currentConfiguration.parseFromProperties().getValues("userhome");
                if (userHome != null) {
                    new UserHomePropertyHandler().invoke(userHome);
                } else {
                    this.myLogger.debug("User home is not configured in properties, use backup value");
                    this.myUserHomeDirectory = System.getProperty("user.home");
                }
            }
            catch (Exception exc) {
                this.myLogger.error("Failed to set myUserHomeDirectory, using backup value", exc);
                this.myUserHomeDirectory = System.getProperty("user.home");
            }
        }
        return this.myUserHomeDirectory;
    }

    void setParameters(PCmdLineParams params) {
        this.myParams = params;
    }

    void setUserHome(String path) {
        this.myUserHomeDirectory = path;
    }

    protected Object getPropertyFromApp(ApplicationGrade grade, String propertyKey) {
        Object value = null;
        List apps = this.getRegistry(ApplicationRegistry.class).getApplications(ApplicationGrade.MASTER);
        for (Application app : apps) {
            value = app.getDescription().getProperty(propertyKey);
            if (value != null) break;
        }
        return value;
    }

    protected void createRegistries() {
        this.myRegistries = new ArrayList<PluginRegistry>();
        this.myRegistries.add(new ServiceRegistry());
        this.myRegistries.add(new ObjectRegistry());
        this.myRegistries.add(new ApplicationRegistry());
        this.myRegistries.add(new OperationRegistry());
    }

    protected void resetSingleton() {
        this.myUserHomeDirectory = null;
        this.myParams = null;
        this.myRuntimeProperties.clear();
        this.myPropertyChangeListeners.clear();
        for (PluginRegistry registry : this.myRegistries) {
            registry.close();
        }
        this.myRegistries.clear();
        this.createRegistries();
        this.myLogger.trace("PoseidonRuntime reset");
    }
}

