/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.plugin.conf.ConfigurationException;
import com.nokia.em.poseidon.plugin.conf.ConfigurationManager;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleListener;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleManager;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleStatus;
import com.nokia.em.poseidon.plugin.properties.PropertyManager;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.em.poseidon.util.SingletonResetter;
import com.nokia.em.poseidon.util.probe.ProbeManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class PoseidonStarter
implements LifecycleListener {
    private static final String DEFAULT_CONFIGURATION_FILE = "com/nokia/em/poseidon/config/PoseidonConfiguration.xml";
    private static final String REFERENCE_APP_CONFIGURATION_FILE = "com/nokia/em/poseidon/demos/referenceapp/conf.xml";
    private Logger myLogger;
    private static boolean theInitialized;

    protected PoseidonStarter() {
    }

    public static void main(String[] args) throws ConfigurationException {
        PoseidonStarter.init(new PCmdLineParams(args));
        if (PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).getAll().size() == 0) {
            Logger.getLogger(PoseidonStarter.class).debug("Starting ReferenceApplication because there are no applications defined to start in Poseidon.");
            ConfigurationManager.getInstance().insertAndExecuteConfiguration(REFERENCE_APP_CONFIGURATION_FILE);
        }
    }

    public static void init() throws ConfigurationException {
        PoseidonStarter.init(new PCmdLineParams());
    }

    public static void init(PCmdLineParams params) throws ConfigurationException {
        new PoseidonStarter().initialize(params);
    }

    protected void initialize(PCmdLineParams params) throws ConfigurationException {
        ProbeManager.startProbe("Poseidon Startup", "Poseidon Startup Time");
        this.checkLogFileFromCmdLineParams(params);
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug("Initializing Poseidon framework");
        this.checkIfInitialized();
        try {
            PoseidonRuntime.getRuntime().setParameters(params);
            this.logVersion();
            ConfigurationManager.getInstance().insertConfiguration(DEFAULT_CONFIGURATION_FILE);
            PCmdLineParams checkedParams = this.checkForConfFile(PoseidonRuntime.getRuntime().getParameters());
            PropertyManager.getInstance().checkParams(checkedParams);
            this.loadModules(checkedParams.getValues("modules"));
            ConfigurationManager.getInstance().addConfigurationListener(LifecycleManager.getInstance());
            LifecycleManager.getInstance().addLifecycleListener(this);
            ConfigurationManager.getInstance().executeCurrentConfiguration();
            theInitialized = true;
        }
        catch (RuntimeException e) {
            this.handleStartupException(e);
            throw e;
        }
        catch (ConfigurationException e) {
            this.handleStartupException(e);
            throw e;
        }
        this.myLogger.debug("Poseidon framework initialization finished");
        ProbeManager.stopProbe("Poseidon Startup");
    }

    protected void checkLogFileFromCmdLineParams(PCmdLineParams params) {
        if (params.getFirstValue("logfolder") != null) {
            System.setProperty("logfolder", params.getFirstValue("logfolder"));
        }
    }

    protected void checkIfInitialized() {
        if (theInitialized) {
            throw new IllegalStateException("Poseidon framework already initialized. Use PoseidonRuntime, ConfigurationManager or LifecycleManager to manage running Poseidon.");
        }
    }

    public static boolean isInitialized() {
        return theInitialized;
    }

    protected void logVersion() {
        Package poseidonPackage = PoseidonStarter.class.getPackage();
        if (poseidonPackage != null) {
            this.myLogger.debug("Poseidon package title = " + poseidonPackage.getImplementationTitle() + ", vendor = " + poseidonPackage.getImplementationVendor() + ", version = " + poseidonPackage.getImplementationVersion());
        }
    }

    protected PCmdLineParams checkForConfFile(PCmdLineParams parameters) {
        if (!parameters.isDefined("conffile") && !parameters.isDefined("application")) {
            parameters.storeParamValues("conffile", Collections.singletonList("poseidon.xml"));
        }
        return parameters;
    }

    protected void loadModules(List<String> moduleFolders) throws ConfigurationException {
        ArrayList<String> folders = new ArrayList<String>();
        folders.add("modules");
        if (moduleFolders != null) {
            folders.addAll(moduleFolders);
        }
        for (String folderName : folders) {
            File[] files;
            File extensionFolder = new File(folderName);
            if (!extensionFolder.isDirectory() || (files = extensionFolder.listFiles()) == null) continue;
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    ConfigurationManager.getInstance().loadModule(files[i].toString());
                }
                ++i;
            }
        }
    }

    protected void handleStartupException(Exception e) {
        this.myLogger.error("Exception in Poseidon initialization, closing Poseidonand throwing the exception further.", e);
        LifecycleManager.getInstance().closeRequest();
    }

    @Override
    public void lifecycleUpdated(LifecycleStatus event) {
        if (LifecycleStatus.CLOSED.equals((Object)event)) {
            theInitialized = false;
            SingletonResetter.reset(PoseidonRuntime.getRuntime());
            SingletonResetter.reset(ConfigurationManager.getInstance());
            SingletonResetter.reset(PropertyManager.getInstance());
        }
    }
}

