/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.common;

import java.io.File;

public class TransferInfo {
    private long myDataLenght;
    private double myTransferredPercentage;
    private TransferStatus myTransferStatus;
    private Object myTransferTarget;
    private String myUserName;
    private Object myProtocolResponseCode;
    private String myInfoMessage;
    private Object myErrorData;

    public TransferInfo(long dataLength, double percentage, TransferStatus transferStatus, Object transferTarget, String userName, Object protocolResponseCode, String infoMessage) {
        this.myDataLenght = dataLength;
        this.myTransferredPercentage = percentage;
        this.myTransferStatus = transferStatus;
        this.myTransferTarget = transferTarget;
        this.myUserName = userName;
        this.myProtocolResponseCode = protocolResponseCode;
        this.myInfoMessage = infoMessage;
    }

    public TransferInfo(long dataLength, double percentage, TransferStatus transferStatus, Object transferTarget, String userName) {
        this(dataLength, percentage, transferStatus, transferTarget, userName, null, null);
    }

    public TransferStatus getTransferStatus() {
        return this.myTransferStatus;
    }

    public long getContentLength() {
        return this.myDataLenght;
    }

    public double getTransferPercentage() {
        return this.myTransferredPercentage;
    }

    public File getFile() {
        if (this.myTransferTarget instanceof File) {
            return (File)this.myTransferTarget;
        }
        return null;
    }

    public Object getTransferTarget() {
        return this.myTransferTarget;
    }

    public String getUserName() {
        return this.myUserName;
    }

    public Object getProtocolResponseCode() {
        return this.myProtocolResponseCode;
    }

    public String getInfoMessage() {
        return this.myInfoMessage;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" UserName: ");
        builder.append(this.getUserName());
        builder.append("/n");
        builder.append(" FileName: ");
        builder.append(this.getFile().getName());
        builder.append("/n");
        builder.append(" ResponseCode: ");
        builder.append(this.getProtocolResponseCode());
        builder.append("/n");
        builder.append(" TransferStatus: ");
        builder.append((Object)this.getTransferStatus());
        builder.append("/n");
        builder.append(" TransferPercentage: ");
        builder.append(this.getTransferPercentage());
        builder.append("/n");
        builder.append(" ErrorData: ");
        builder.append(this.getErrorData());
        builder.append("/n");
        return builder.toString();
    }

    public Object getErrorData() {
        return this.myErrorData;
    }

    public void setErrorData(Object errorData) {
        this.myErrorData = errorData;
    }

    public static enum TransferStatus {
        TRANSFER_INITIALIZING,
        TRANSFER_ONGOING,
        TRANSFER_COMPLETED,
        TRANSFER_CANCELLED,
        TRANSFER_ERROR;

    }
}

