/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.ftp.PortRange;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public abstract class AbstractConnection {
    protected static final int CTRL_CONNECTION_TIMEOUT = 2000;
    protected Socket mySocket;
    protected static char CR = (char)13;
    protected static char LF = (char)10;
    protected boolean myTimeOutOccured = false;
    private Logger myLogger = Logger.getLogger(AbstractConnection.class);

    protected AbstractConnection() {
    }

    public AbstractConnection(Socket controlSocket) {
        this.mySocket = controlSocket;
    }

    public AbstractConnection(String address, int port) throws IOException {
        this.mySocket = new Socket(address, port);
    }

    public AbstractConnection(InetAddress address, int port, InetAddress localAddr, PortRange portRange) throws IOException {
        int i = portRange.getStart();
        while (i <= portRange.getEnd()) {
            try {
                this.mySocket = new Socket(address, port, localAddr, i);
                this.myLogger.debug("Bind port " + i + " to a data channel. Destination port is " + port);
                break;
            }
            catch (Exception e) {
                this.myLogger.debug("Could not bind data socket for port:" + i + " because" + e);
                ++i;
            }
        }
        if (this.mySocket == null) {
            this.myLogger.debug("No free port on given range. As a last change try to find any free port");
            this.mySocket = new Socket(address, port);
            this.myLogger.debug("Opened port: " + this.mySocket.getLocalPort());
        }
    }

    public void destroy() {
        this.closeSocket(this.mySocket);
        this.mySocket = null;
    }

    public void timeout() {
        this.myTimeOutOccured = true;
    }

    public InetSocketAddress getSocketAddress() {
        SocketAddress address;
        if (this.mySocket != null && (address = this.mySocket.getRemoteSocketAddress()) instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    public InetSocketAddress getLocalSocketAddress() {
        SocketAddress address;
        if (this.mySocket != null && (address = this.mySocket.getLocalSocketAddress()) instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    protected void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void closeServerSocket(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

