/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.ftp.AbstractConnection;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.ftp.TimeOutException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.log4j.Logger;

public class DataConnection
extends AbstractConnection {
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private ServerSocket myServerSocket;
    private boolean myCancel = false;
    private long myTransferredBytes = 0L;
    private Logger myLogger = Logger.getLogger(DataConnection.class);

    public DataConnection(InetAddress bindAddr) throws IOException {
        this.myServerSocket = new ServerSocket(0, 50, bindAddr);
    }

    public DataConnection(PortRange portRange, InetAddress bindAddr) throws IOException {
        int i = portRange.getStart();
        while (i <= portRange.getEnd()) {
            try {
                this.myServerSocket = new ServerSocket(i, 50, bindAddr);
                this.myLogger.debug("Using port " + i + " as a data channel");
                break;
            }
            catch (Exception e) {
                this.myLogger.debug("Could not open data socket for port:" + i);
                ++i;
            }
        }
        if (this.myServerSocket == null) {
            this.myLogger.debug("No free port on given range");
            this.myServerSocket = new ServerSocket(0, 50, bindAddr);
        }
    }

    public DataConnection(String address, int port) throws IOException {
        super(address, port);
        this.createStreams();
    }

    public DataConnection(InetAddress address, int port, InetAddress localAddr, PortRange portRange) throws IOException {
        super(address, port, localAddr, portRange);
        this.createStreams();
    }

    public void waitForClient() throws IOException, FtpException {
        if (this.myServerSocket != null) {
            while (!this.myTimeOutOccured) {
                try {
                    this.mySocket = this.myServerSocket.accept();
                    break;
                }
                catch (InterruptedIOException interruptedIOException) {
                    // empty catch block
                }
            }
            if (this.myTimeOutOccured) {
                throw new TimeOutException("File transfer failed because of timeout exceeded when reading reply from server.");
            }
            this.createStreams();
        }
    }

    public InetSocketAddress getServerSocketAddress() {
        InetSocketAddress serverAddress = null;
        if (this.mySocket == null) {
            return new InetSocketAddress(this.myServerSocket.getInetAddress(), this.myServerSocket.getLocalPort());
        }
        serverAddress = (InetSocketAddress)this.mySocket.getLocalSocketAddress();
        return serverAddress;
    }

    @Override
    public void destroy() {
        this.closeStream(this.myInputStream);
        this.myInputStream = null;
        this.closeStream(this.myOutputStream);
        this.myOutputStream = null;
        this.closeServerSocket(this.myServerSocket);
        this.myServerSocket = null;
        super.destroy();
    }

    public void cancel() {
        this.myCancel = true;
    }

    public synchronized void sendFile(File file) throws IOException {
        this.myCancel = false;
        FileInputStream fileStream = new FileInputStream(file);
        try {
            try {
                this.copyFromStream(fileStream, this.myOutputStream);
            }
            catch (IOException ex) {
                this.myLogger.error("Send file failed at " + this.myTransferredBytes, ex);
                throw ex;
            }
        }
        finally {
            if (this.myOutputStream != null) {
                this.myOutputStream.flush();
            }
            this.closeStream(fileStream);
            this.myCancel = false;
        }
    }

    public synchronized void readFile(File file) throws IOException {
        this.myCancel = false;
        FileOutputStream fileStream = new FileOutputStream(file);
        try {
            try {
                this.copyFromStream(this.myInputStream, fileStream);
            }
            catch (IOException ex) {
                this.myLogger.error("Read file failed at " + this.myTransferredBytes, ex);
                throw ex;
            }
        }
        finally {
            fileStream.flush();
            this.closeStream(fileStream);
            this.myCancel = false;
        }
    }

    public synchronized void sendString(String data) throws IOException {
        this.myCancel = false;
        StringReader inputStream = new StringReader(data);
        OutputStreamWriter outputStream = new OutputStreamWriter(this.myOutputStream);
        try {
            try {
                this.copyFromStream(inputStream, outputStream);
            }
            catch (IOException ex) {
                this.myLogger.error("Send string failed at " + this.myTransferredBytes, ex);
                throw ex;
            }
        }
        finally {
            this.closeWriter(outputStream);
            this.closeReader(inputStream);
            this.myCancel = false;
        }
    }

    public synchronized String readString() throws IOException {
        this.myCancel = false;
        String string = null;
        StringWriter stringStream = new StringWriter();
        try {
            try {
                this.copyFromStream(new InputStreamReader(this.myInputStream), stringStream);
            }
            catch (IOException ex) {
                this.myLogger.error("Read string failed at" + this.myTransferredBytes, ex);
                throw ex;
            }
        }
        finally {
            string = stringStream.toString();
            this.closeWriter(stringStream);
        }
        return string;
    }

    public long getTransferredBytes() {
        return this.myTransferredBytes;
    }

    private void createStreams() throws IOException {
        this.myInputStream = this.mySocket.getInputStream();
        this.myOutputStream = this.mySocket.getOutputStream();
    }

    private void copyFromStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.myTransferredBytes = 0L;
        byte[] buffer = new byte[4000];
        int numBytes = inputStream.read(buffer);
        while (!this.myCancel && numBytes != -1) {
            this.myTransferredBytes += (long)numBytes;
            outputStream.write(buffer, 0, numBytes);
            numBytes = inputStream.read(buffer);
        }
    }

    private void copyFromStream(Reader inputStream, Writer outputStream) throws IOException {
        char[] buffer = new char[4000];
        int numBytes = inputStream.read(buffer);
        while (!this.myCancel && numBytes != -1) {
            outputStream.write(buffer, 0, numBytes);
            numBytes = inputStream.read(buffer);
        }
    }
}

