/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class FileInfo {
    private char[] myRights = new char[10];
    private int myLinks = 0;
    private String myOwner = "XXX";
    private String myGroup = "XXX";
    private long mySize = 0L;
    private Date myDate = new Date();
    private String myName = "XXX";

    public static FileInfo getFileInfo(String infoString) throws Throwable {
        FileInfo info = new FileInfo();
        String token = "";
        StringTokenizer st = new StringTokenizer(infoString, " ");
        boolean parseFailed = false;
        token = st.nextToken();
        info.setRights(token);
        token = st.nextToken();
        info.setLink(Integer.parseInt(token));
        token = st.nextToken();
        info.setOwner(token);
        String restOf = FileInfo.getRestOfTokenizer(st);
        try {
            FileInfo.parseDynamicPart(info, restOf, true);
        }
        catch (Throwable ex) {
            parseFailed = true;
            info.setGroup("");
        }
        if (parseFailed) {
            FileInfo.parseDynamicPart(info, restOf, false);
        }
        return info;
    }

    public void setRights(String rights) throws Exception {
        char flag;
        if (rights == null || rights.length() != 10) {
            throw new IllegalArgumentException("Given rights are not in correct format! Eg. eg. drw-r--r--");
        }
        this.myRights[0] = flag = rights.charAt(0);
        int length = rights.length();
        int i = 1;
        while (i < length) {
            flag = rights.charAt(i);
            if (flag != 'r' && flag != 'w' && flag != 'x' && flag != '-') {
                throw new IllegalArgumentException("Invalid directory flag! 'r', 'w', 'x' and '-' are allowed");
            }
            this.myRights[i] = flag;
            ++i;
        }
    }

    public String getRights() {
        return String.valueOf(this.myRights);
    }

    public void setLink(int links) {
        this.myLinks = links;
    }

    public int getLink() {
        return this.myLinks;
    }

    public void setOwner(String owner) {
        this.myOwner = owner;
    }

    public String getOwner() {
        return this.myOwner;
    }

    public void setGroup(String group) {
        this.myGroup = group;
    }

    public String getGroup() {
        return this.myGroup;
    }

    public void setSize(long size) {
        this.mySize = size;
    }

    public long getSize() {
        return this.mySize;
    }

    public void setDate(Date date) {
        this.myDate = date;
    }

    public Date getDate() {
        return this.myDate;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isDirectory() {
        return this.isTrue(this.myRights[0]);
    }

    public boolean canOwnerRead() {
        return this.isTrue(this.myRights[1]);
    }

    public boolean canOwnerWrite() {
        return this.isTrue(this.myRights[2]);
    }

    public boolean canOwnerExecute() {
        return this.isTrue(this.myRights[3]);
    }

    public boolean canGroupRead() {
        return this.isTrue(this.myRights[4]);
    }

    public boolean canGroupWrite() {
        return this.isTrue(this.myRights[5]);
    }

    public boolean canGroupExecute() {
        return this.isTrue(this.myRights[6]);
    }

    public boolean canAllRead() {
        return this.isTrue(this.myRights[7]);
    }

    public boolean canAllWrite() {
        return this.isTrue(this.myRights[8]);
    }

    public boolean canAllExecute() {
        return this.isTrue(this.myRights[9]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.myRights);
        sb.append(this.myLinks);
        sb.append(this.myOwner);
        sb.append(this.myGroup);
        sb.append(" ");
        sb.append(this.mySize);
        sb.append(this.myDate);
        sb.append(" ");
        sb.append(this.myName);
        return sb.toString();
    }

    private static String getRestOfTokenizer(StringTokenizer st) {
        StringBuffer sb = new StringBuffer(st.countTokens() * 2 - 1);
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(" ");
        }
        return sb.toString();
    }

    private static void parseDynamicPart(FileInfo info, String restOf, boolean isRegular) throws Throwable {
        StringTokenizer st = new StringTokenizer(restOf, " ");
        if (isRegular) {
            info.setGroup(st.nextToken());
        }
        info.setSize(Long.parseLong(st.nextToken()));
        FileInfo.parseRestOf(info, st);
    }

    private static void parseRestOf(FileInfo info, StringTokenizer st) throws Throwable {
        StringBuffer dateBuffer = new StringBuffer();
        String lastString = null;
        dateBuffer.append(st.nextToken());
        dateBuffer.append(" ");
        dateBuffer.append(st.nextToken());
        dateBuffer.append(" ");
        lastString = st.nextToken();
        dateBuffer.append(lastString);
        SimpleDateFormat dateFrm = null;
        dateFrm = lastString.indexOf(":") == -1 ? new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH) : new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
        Date date = dateFrm.parse(dateBuffer.toString());
        info.setDate(date);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(" ");
        }
        info.setName(sb.toString().trim());
    }

    private boolean isTrue(char c) {
        return c != '-';
    }
}

