/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.ftp.ClientControlConnection;
import com.nokia.em.poseidon.comm.ftp.DataConnection;
import com.nokia.em.poseidon.comm.ftp.FileInfo;
import com.nokia.em.poseidon.comm.ftp.FirewallConfiguration;
import com.nokia.em.poseidon.comm.ftp.FtpCommand;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.comm.ftp.FtpReply;
import com.nokia.em.poseidon.comm.ftp.Utility;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FtpClient {
    private static final int theTimeoutTimerDelay = 1000;
    public static final String TYPE_IMAGE = "I";
    public static final String TYPE_ASCII_NON_PRINT = "A N";
    public static final String MODE_STREAM = "S";
    public static final String MODE_BLOCK = "B";
    public static final String MODE_COMPRESSED = "C";
    private static final String NOT_CONNECTED_TO_SERVER = "Ftp.NotConnectedToServer";
    private static final int PROGRESS_INTERVAL = 500;
    private static final Pattern FTP_SIZE_REPLY_PATTERN = Pattern.compile("(\\d+) (\\d+)");
    private InetSocketAddress myServerDataAddress;
    private ClientControlConnection myClientControlConnection;
    private DataConnection myDataConnection;
    private boolean myIsActiveClient = false;
    private boolean myIsConnected = false;
    private boolean myOperationAborted = false;
    private String myCurrentCommand;
    private CachedThread myWorkerThread;
    private boolean myProcessingCommand = false;
    private Timer myProgressTimer;
    private TransferInfo myTransferInfo;
    private TransferListener myFileTransferListener;
    private String myUserName;
    private Logger myLogger = Logger.getLogger(FtpClient.class);
    private long myIdleTimeOut = 0L;
    private TimerService myIdleTimer;
    private TimeoutListener myTimeoutListener;
    private boolean myCommandSend;

    public FtpClient() {
        this.myProgressTimer = new Timer();
        this.myIdleTimer = TimerService.getInstance();
        this.myTimeoutListener = new TimeoutListener();
    }

    public FtpReply connect(String serverAddress, int serverPort) throws FtpException {
        this.myLogger.debug("Connect to: " + serverAddress + ":" + serverPort);
        if (this.myIsConnected) {
            throw new Error("Could not connect. Already connected.");
        }
        this.startProcessingCommand();
        FtpReply reply = null;
        try {
            try {
                reply = this.connectInternal(serverAddress, serverPort);
            }
            catch (Throwable ex) {
                this.myClientControlConnection = null;
                throw new FtpException(ex.getMessage(), ex);
            }
        }
        finally {
            this.stopProcessingCommand();
        }
        this.myServerDataAddress = new InetSocketAddress(serverAddress, serverPort - 1);
        this.myIsConnected = true;
        return reply;
    }

    public FtpReply disconnect() throws FtpException {
        this.myLogger.debug("Disconnect request. Connection status = " + this.myIsConnected);
        if (!this.myIsConnected) {
            throw new FtpException(NOT_CONNECTED_TO_SERVER);
        }
        FtpReply reply = null;
        try {
            try {
                if (this.myWorkerThread != null || this.myCurrentCommand != null && (this.myCurrentCommand.equals("STOR") || this.myCurrentCommand.equals("RETR"))) {
                    reply = this.abort();
                }
                this.sendCommand("QUIT", null);
                reply = this.checkReply();
            }
            catch (FtpReplyException e) {
                throw new FtpException(e.getMessage(), e);
            }
        }
        finally {
            if (this.myClientControlConnection != null) {
                this.myClientControlConnection.destroy();
            }
            this.myIsConnected = false;
            this.stopProcessingCommand();
        }
        return reply;
    }

    public void setActive(boolean active) {
        this.myLogger.debug("New client activity status = " + active);
        this.myIsActiveClient = active;
    }

    public void setIdleTimeOut(long timeOut) {
        this.myIdleTimeOut = timeOut * 1000L;
        if (this.myIdleTimeOut > 0L) {
            this.myIdleTimer.startTimer(this.myTimeoutListener, 1000L, false, 1);
        } else {
            this.myIdleTimer.stopTimer(this.myTimeoutListener);
        }
    }

    public FtpReply getFile(String serverFile, String localFile) throws FtpException {
        this.myLogger.debug("Downloading file from server. Server file: " + serverFile + ", Local file: " + localFile);
        this.startProcessingCommand();
        File newFile = new File(localFile);
        FtpReply reply = null;
        try {
            try {
                long serverFileSize = this.getFileSize(serverFile);
                if (serverFileSize <= 0L) {
                    throw new FtpException("File '" + serverFile + "' has a size of 0 bytes.");
                }
                DiskSpaceChecker.checkDiskSpaceException(newFile, serverFileSize);
                reply = this.sendDataCommand("RETR", new String[]{serverFile});
                this.myDataConnection.readFile(newFile);
                reply = this.checkReply();
            }
            catch (Throwable ex) {
                this.myLogger.error("Error downloading file", ex);
                if (newFile.exists()) {
                    this.myLogger.debug("Deleting temporary file");
                    IOUtils.deleteFile(newFile);
                }
                if (ex instanceof FtpReplyException) {
                    throw new FtpException(ex.getMessage(), ex, ((FtpReplyException)ex).getReply().getCode());
                }
                throw new FtpException(ex.getMessage(), ex);
            }
        }
        finally {
            if (this.myDataConnection != null) {
                this.myDataConnection.destroy();
                this.myDataConnection = null;
            }
            this.stopProcessingCommand();
        }
        return reply;
    }

    public void getFile(final String serverFile, final String localFile, TransferListener listener) {
        this.myLogger.debug("Downloading file from server. Server file: " + serverFile + ", Local file: " + localFile);
        this.myFileTransferListener = listener;
        final int finalSize = this.tryToGetFileSize(serverFile, false);
        this.stopProcessingCommand();
        this.startProcessingCommand();
        this.myWorkerThread = new CachedThread(new Runnable(){

            @Override
            public void run() {
                try {
                    FtpClient.this.asyncGetFile(serverFile, localFile, finalSize);
                }
                catch (Throwable ex) {
                    FtpClient.this.myLogger.warn("Async download failed", ex);
                }
            }
        }, "FTPCLIENTWORKER");
        this.myWorkerThread.start();
    }

    public FtpReply putFile(String localFile, String serverFile) throws FtpException {
        this.myLogger.debug("Sending file to server. Server file: " + serverFile + ", Local file: " + localFile);
        this.startProcessingCommand();
        FtpReply reply = null;
        try {
            try {
                reply = this.sendDataCommand("STOR", new String[]{serverFile});
                this.myDataConnection.sendFile(new File(localFile));
            }
            catch (Throwable ex) {
                this.myLogger.error("Error sending file", ex);
                throw new FtpException(ex.getMessage(), ex);
            }
        }
        finally {
            this.myDataConnection.destroy();
            this.myDataConnection = null;
            this.stopProcessingCommand();
            if (reply.isPositivePreliminary()) {
                reply = this.checkReply();
            }
        }
        return reply;
    }

    public void putFile(final String localFile, final String serverFile, TransferListener listener) {
        this.myLogger.debug("Sending file to server. Server file: " + serverFile + ", Local file: " + localFile);
        this.myFileTransferListener = listener;
        final int size = this.tryToGetFileSize(localFile, true);
        this.startProcessingCommand();
        this.myWorkerThread = new CachedThread(new Runnable(){

            @Override
            public void run() {
                try {
                    FtpClient.this.asyncPutFile(localFile, serverFile, size);
                }
                catch (Throwable ex) {
                    FtpClient.this.myLogger.error("Async send failed", ex);
                }
            }
        }, "FTPCLIENTWORKER");
        this.myWorkerThread.start();
    }

    public FtpReply deleteFile(String serverFile) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("DELE", new String[]{serverFile});
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply removeDirectory(String serverPath) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("RMD", new String[]{serverPath});
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply makeDirectory(String dir) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("MKD", new String[]{dir});
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply changeDirectory(String dir) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("CWD", new String[]{dir});
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply changeToParentDirectory() throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("CDUP", null);
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply abort() throws FtpException {
        this.myOperationAborted = true;
        this.sendCommand("ABOR", null);
        if (this.myWorkerThread != null) {
            try {
                this.myWorkerThread.join();
            }
            catch (Throwable ex) {
                this.myLogger.warn("WorkerThread interrupted unexpectly.");
            }
        }
        FtpReply reply = this.checkReply();
        return reply;
    }

    public FtpReply getHelp(String command) throws FtpException {
        this.sendCommand("HELP", new String[]{command});
        return this.checkReply();
    }

    public FtpReply setTransferType(String type) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("TYPE", new String[]{type});
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply setTransferMode(String mode) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("MODE", new String[]{mode});
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply noOperation() throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("NOOP", null);
        FtpReply reply = this.checkReply();
        this.stopProcessingCommand();
        return reply;
    }

    public FtpReply login(String host, int port, String userName, String password, FirewallConfiguration firewallConf) throws FtpException {
        this.myLogger.debug("Connect to: " + host + ":" + port);
        if (this.myIsConnected) {
            throw new Error("Could not login. Connection already exist.");
        }
        this.startProcessingCommand();
        FtpReply reply = null;
        try {
            try {
                reply = this.connectInternal(host, port);
                reply = this.loginInternal(userName, password);
                this.myIsConnected = true;
            }
            catch (Throwable ex) {
                if (this.myClientControlConnection != null) {
                    this.myClientControlConnection.destroy();
                    this.myClientControlConnection = null;
                }
                this.myIsConnected = false;
                throw new FtpException(ex.getMessage(), ex);
            }
        }
        finally {
            this.stopProcessingCommand();
        }
        return reply;
    }

    public FtpReply login(String userName, String password) throws FtpException {
        this.startProcessingCommand();
        FtpReply reply = null;
        try {
            reply = this.loginInternal(userName, password);
        }
        finally {
            this.stopProcessingCommand();
        }
        return reply;
    }

    public String getDirectory(FtpReply[] outReply) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("PWD", null);
        String str = "";
        try {
            if (outReply == null) {
                str = this.myClientControlConnection.readReply().toString();
            } else {
                outReply[0] = this.myClientControlConnection.readReply();
                str = outReply[0].toString();
            }
        }
        catch (Throwable ex) {
            this.stopProcessingCommand();
            throw new FtpException(NOT_CONNECTED_TO_SERVER, ex);
        }
        this.stopProcessingCommand();
        return str.length() > 4 ? str.substring(4) : "";
    }

    public String getSystem(FtpReply[] outReply) throws FtpException {
        this.startProcessingCommand();
        this.sendCommand("SYST", null);
        String str = "";
        try {
            if (outReply == null) {
                str = this.myClientControlConnection.readReply().toString();
            } else {
                outReply[0] = this.myClientControlConnection.readReply();
                str = outReply[0].toString();
            }
        }
        catch (Throwable ex) {
            this.stopProcessingCommand();
            throw new FtpException(NOT_CONNECTED_TO_SERVER, ex);
        }
        this.stopProcessingCommand();
        if (str.length() > 4) {
            return str.substring(4);
        }
        return "";
    }

    public Collection getFileList(String path, String[] outFileList, FtpReply[] outReply) throws FtpException {
        this.startProcessingCommand();
        FtpReply reply = this.sendDataCommand("LIST", new String[]{path});
        String str = "";
        Collection<FileInfo> parsedFiles = null;
        try {
            try {
                if (outFileList == null) {
                    str = this.myDataConnection.readString();
                } else {
                    outFileList[0] = this.myDataConnection.readString();
                    str = outFileList[0];
                }
                parsedFiles = this.parseFileListing(str);
                reply = this.checkReply();
                if (outReply != null) {
                    outReply[0] = reply;
                }
            }
            catch (Throwable ex) {
                throw new FtpException(ex.getMessage(), ex);
            }
        }
        finally {
            this.myDataConnection.destroy();
            this.myDataConnection = null;
            this.stopProcessingCommand();
        }
        return parsedFiles;
    }

    public Collection<String> getFileNames(String path, String[] outFileNames, FtpReply[] outReply) throws FtpException {
        this.startProcessingCommand();
        FtpReply reply = this.sendDataCommand("NLST", new String[]{path});
        String str = "";
        Collection<String> parsedFileNames = null;
        try {
            try {
                if (outFileNames == null) {
                    str = this.myDataConnection.readString();
                } else {
                    outFileNames[0] = this.myDataConnection.readString();
                    str = outFileNames[0];
                }
                parsedFileNames = this.parseFileNames(str);
                reply = this.checkReply();
                if (outReply != null) {
                    outReply[0] = reply;
                }
            }
            catch (Throwable ex) {
                throw new FtpException(ex.getMessage(), ex);
            }
        }
        finally {
            this.myDataConnection.destroy();
            this.myDataConnection = null;
            this.stopProcessingCommand();
        }
        return parsedFileNames;
    }

    private FtpReply checkReply() throws FtpException {
        FtpReply reply = null;
        try {
            reply = this.myClientControlConnection.readReply();
        }
        catch (Throwable ex) {
            this.stopProcessingCommand();
            throw new FtpException(NOT_CONNECTED_TO_SERVER, ex);
        }
        if (reply == null) {
            this.stopProcessingCommand();
            throw new FtpException(NOT_CONNECTED_TO_SERVER);
        }
        this.myLogger.trace("Reply Received: " + reply.getMessage());
        if (reply.isNegative() && !reply.getCode().equals("426")) {
            this.stopProcessingCommand();
            throw new FtpReplyException(reply.getMessage(), reply);
        }
        return reply;
    }

    private Collection<String> parseFileNames(String listing) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(listing));
        try {
            String token = "";
            while (token != null) {
                token = reader.readLine();
                if (token == null) break;
                list.add(token);
            }
            reader.close();
        }
        catch (Throwable ioe) {
            this.myLogger.error("Failed to read file names.", ioe);
        }
        return list;
    }

    private Collection<FileInfo> parseFileListing(String s) {
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        BufferedReader reader = new BufferedReader(new StringReader(s));
        try {
            String token = "";
            while (token != null) {
                token = reader.readLine();
                if (token == null) break;
                try {
                    list.add(FileInfo.getFileInfo(token));
                }
                catch (Throwable ex) {
                    this.myLogger.error("FtpClient failed to parse fileinfo " + token, ex);
                }
            }
            reader.close();
        }
        catch (Throwable ioe) {
            this.myLogger.error("Failed to read file listing.", ioe);
        }
        return list;
    }

    private FtpReply setPort(String address, int port) throws FtpException {
        String addr = Utility.createAddressString(address, port);
        this.sendCommand("PORT", new String[]{addr});
        return this.checkReply();
    }

    private FtpReply setPassiveMode() throws FtpException {
        this.sendCommand("PASV", null);
        FtpReply reply = this.checkReply();
        String msg = reply.getMessage();
        String strAddress = msg.substring(msg.indexOf(40) + 1, msg.indexOf(41));
        this.myServerDataAddress = Utility.parseAddressString(strAddress);
        return reply;
    }

    private void asyncGetFile(String serverFile, String localFile, int size) {
        block42: {
            File newFile;
            FtpException eventException;
            block44: {
                eventException = null;
                newFile = new File(localFile);
                try {
                    if (!this.isServerFileSizeGreaterThanZero(serverFile)) {
                        throw new FtpException("File '" + serverFile + "' has a size of 0 bytes.");
                    }
                    this.sendDataCommand("RETR", new String[]{serverFile});
                    this.myTransferInfo = new TransferInfo(size, 0.0, TransferInfo.TransferStatus.TRANSFER_ONGOING, newFile, this.myUserName);
                    this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                    this.myProgressTimer.schedule((TimerTask)new ProgressTimerListener(), 500L, 500L);
                    this.myDataConnection.readFile(newFile);
                    if (this.myOperationAborted) {
                        eventException = new FtpException("Operation was cancelled");
                    }
                }
                catch (FtpException pe) {
                    eventException = pe;
                    this.myProgressTimer.cancel();
                    this.myProgressTimer = new Timer();
                    if (eventException != null && newFile.exists()) {
                        IOUtils.deleteFile(newFile);
                    }
                    FtpReply ftpReply = null;
                    if (eventException instanceof FtpReplyException && ((FtpReplyException)eventException).getReply().isNegative()) {
                        ftpReply = ((FtpReplyException)eventException).getReply();
                    } else {
                        try {
                            ftpReply = this.checkReply();
                        }
                        catch (Exception pe2) {
                            this.myLogger.error("Failed to set reply.", pe2);
                        }
                    }
                    String infoMsg = "";
                    String responseCode = null;
                    if (eventException != null) {
                        infoMsg = eventException.getMessage();
                    } else if (ftpReply != null) {
                        infoMsg = ftpReply.getMessage();
                        responseCode = ftpReply.getCode();
                    }
                    this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
                    this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                    if (this.myDataConnection != null) {
                        this.myDataConnection.destroy();
                        this.myDataConnection = null;
                    }
                    this.stopProcessingCommand();
                    this.myOperationAborted = false;
                    this.myWorkerThread = null;
                    break block42;
                }
                catch (Throwable ex) {
                    block43: {
                        try {
                            eventException = new FtpException(ex.getMessage(), ex);
                            this.myProgressTimer.cancel();
                            this.myProgressTimer = new Timer();
                            if (eventException == null || !newFile.exists()) break block43;
                        }
                        catch (Throwable throwable) {
                            this.myProgressTimer.cancel();
                            this.myProgressTimer = new Timer();
                            if (eventException != null && newFile.exists()) {
                                IOUtils.deleteFile(newFile);
                            }
                            FtpReply ftpReply = null;
                            if (eventException instanceof FtpReplyException && ((FtpReplyException)eventException).getReply().isNegative()) {
                                ftpReply = ((FtpReplyException)eventException).getReply();
                            } else {
                                try {
                                    ftpReply = this.checkReply();
                                }
                                catch (Exception pe) {
                                    this.myLogger.error("Failed to set reply.", pe);
                                }
                            }
                            String infoMsg = "";
                            String responseCode = null;
                            if (eventException != null) {
                                infoMsg = eventException.getMessage();
                            } else if (ftpReply != null) {
                                infoMsg = ftpReply.getMessage();
                                responseCode = ftpReply.getCode();
                            }
                            this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
                            this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                            if (this.myDataConnection != null) {
                                this.myDataConnection.destroy();
                                this.myDataConnection = null;
                            }
                            this.stopProcessingCommand();
                            this.myOperationAborted = false;
                            this.myWorkerThread = null;
                            throw throwable;
                        }
                        IOUtils.deleteFile(newFile);
                    }
                    FtpReply ftpReply = null;
                    if (eventException instanceof FtpReplyException && ((FtpReplyException)eventException).getReply().isNegative()) {
                        ftpReply = ((FtpReplyException)eventException).getReply();
                    } else {
                        try {
                            ftpReply = this.checkReply();
                        }
                        catch (Exception pe) {
                            this.myLogger.error("Failed to set reply.", pe);
                        }
                    }
                    String infoMsg = "";
                    String responseCode = null;
                    if (eventException != null) {
                        infoMsg = eventException.getMessage();
                    } else if (ftpReply != null) {
                        infoMsg = ftpReply.getMessage();
                        responseCode = ftpReply.getCode();
                    }
                    this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
                    this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                    if (this.myDataConnection != null) {
                        this.myDataConnection.destroy();
                        this.myDataConnection = null;
                    }
                    this.stopProcessingCommand();
                    this.myOperationAborted = false;
                    this.myWorkerThread = null;
                    break block42;
                }
                this.myProgressTimer.cancel();
                this.myProgressTimer = new Timer();
                if (eventException == null || !newFile.exists()) break block44;
                IOUtils.deleteFile(newFile);
            }
            FtpReply ftpReply = null;
            if (eventException instanceof FtpReplyException && ((FtpReplyException)eventException).getReply().isNegative()) {
                ftpReply = ((FtpReplyException)eventException).getReply();
            } else {
                try {
                    ftpReply = this.checkReply();
                }
                catch (Exception pe) {
                    this.myLogger.error("Failed to set reply.", pe);
                }
            }
            String infoMsg = "";
            String responseCode = null;
            if (eventException != null) {
                infoMsg = eventException.getMessage();
            } else if (ftpReply != null) {
                infoMsg = ftpReply.getMessage();
                responseCode = ftpReply.getCode();
            }
            this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
            this.myFileTransferListener.transferUpdated(this.myTransferInfo);
            if (this.myDataConnection != null) {
                this.myDataConnection.destroy();
                this.myDataConnection = null;
            }
            this.stopProcessingCommand();
            this.myOperationAborted = false;
            this.myWorkerThread = null;
        }
    }

    private void asyncPutFile(String localFile, String serverFile, int size) {
        block28: {
            FtpReply ftpReply;
            File newFile;
            FtpException eventException;
            block30: {
                eventException = null;
                newFile = new File(localFile);
                ftpReply = null;
                try {
                    ftpReply = this.sendDataCommand("STOR", new String[]{serverFile});
                    this.myTransferInfo = new TransferInfo(size, 0.0, TransferInfo.TransferStatus.TRANSFER_ONGOING, newFile, this.myUserName);
                    this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                    this.myProgressTimer.schedule((TimerTask)new ProgressTimerListener(), 500L, 500L);
                    this.myDataConnection.sendFile(newFile);
                }
                catch (FtpException pe) {
                    eventException = pe;
                    this.myProgressTimer.cancel();
                    this.myProgressTimer = new Timer();
                    this.myDataConnection.destroy();
                    this.myDataConnection = null;
                    if (ftpReply != null && ftpReply.isPositivePreliminary()) {
                        try {
                            ftpReply = this.checkReply();
                        }
                        catch (Exception pe2) {
                            this.myLogger.error("Failed to set reply", pe2);
                        }
                    }
                    String infoMsg = "";
                    String responseCode = null;
                    if (eventException != null) {
                        infoMsg = eventException.getMessage();
                    } else if (ftpReply != null) {
                        infoMsg = ftpReply.getMessage();
                        responseCode = ftpReply.getCode();
                    }
                    this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
                    this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                    this.stopProcessingCommand();
                    this.myOperationAborted = false;
                    this.myWorkerThread = null;
                    break block28;
                }
                catch (Throwable ex) {
                    block29: {
                        try {
                            eventException = this.myOperationAborted ? new FtpException("Operation was cancelled") : new FtpException(ex.getMessage(), ex);
                            this.myProgressTimer.cancel();
                            this.myProgressTimer = new Timer();
                            this.myDataConnection.destroy();
                            this.myDataConnection = null;
                            if (ftpReply == null || !ftpReply.isPositivePreliminary()) break block29;
                        }
                        catch (Throwable throwable) {
                            this.myProgressTimer.cancel();
                            this.myProgressTimer = new Timer();
                            this.myDataConnection.destroy();
                            this.myDataConnection = null;
                            if (ftpReply != null && ftpReply.isPositivePreliminary()) {
                                try {
                                    ftpReply = this.checkReply();
                                }
                                catch (Exception pe) {
                                    this.myLogger.error("Failed to set reply", pe);
                                }
                            }
                            String infoMsg = "";
                            String responseCode = null;
                            if (eventException != null) {
                                infoMsg = eventException.getMessage();
                            } else if (ftpReply != null) {
                                infoMsg = ftpReply.getMessage();
                                responseCode = ftpReply.getCode();
                            }
                            this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
                            this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                            this.stopProcessingCommand();
                            this.myOperationAborted = false;
                            this.myWorkerThread = null;
                            throw throwable;
                        }
                        try {
                            ftpReply = this.checkReply();
                        }
                        catch (Exception pe) {
                            this.myLogger.error("Failed to set reply", pe);
                        }
                    }
                    String infoMsg = "";
                    String responseCode = null;
                    if (eventException != null) {
                        infoMsg = eventException.getMessage();
                    } else if (ftpReply != null) {
                        infoMsg = ftpReply.getMessage();
                        responseCode = ftpReply.getCode();
                    }
                    this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
                    this.myFileTransferListener.transferUpdated(this.myTransferInfo);
                    this.stopProcessingCommand();
                    this.myOperationAborted = false;
                    this.myWorkerThread = null;
                    break block28;
                }
                this.myProgressTimer.cancel();
                this.myProgressTimer = new Timer();
                this.myDataConnection.destroy();
                this.myDataConnection = null;
                if (ftpReply == null || !ftpReply.isPositivePreliminary()) break block30;
                try {
                    ftpReply = this.checkReply();
                }
                catch (Exception pe) {
                    this.myLogger.error("Failed to set reply", pe);
                }
            }
            String infoMsg = "";
            String responseCode = null;
            if (eventException != null) {
                infoMsg = eventException.getMessage();
            } else if (ftpReply != null) {
                infoMsg = ftpReply.getMessage();
                responseCode = ftpReply.getCode();
            }
            this.myTransferInfo = new TransferInfo(size, 1.0, eventException == null ? TransferInfo.TransferStatus.TRANSFER_COMPLETED : TransferInfo.TransferStatus.TRANSFER_ERROR, newFile, this.myUserName, responseCode, infoMsg);
            this.myFileTransferListener.transferUpdated(this.myTransferInfo);
            this.stopProcessingCommand();
            this.myOperationAborted = false;
            this.myWorkerThread = null;
        }
    }

    private synchronized void sendCommand(String command, String[] params) throws FtpException {
        if (this.myClientControlConnection == null) {
            this.stopProcessingCommand();
            throw new FtpException(NOT_CONNECTED_TO_SERVER);
        }
        this.myCurrentCommand = command;
        try {
            this.myClientControlConnection.sendCommand(new FtpCommand(command, params));
        }
        catch (Throwable ioe) {
            this.stopProcessingCommand();
            this.myLogger.error("Failed to send command", ioe);
            throw new FtpException(ioe.getMessage(), ioe);
        }
        if (!command.equals("PASS")) {
            this.myLogger.trace("Send Command: " + command);
        } else {
            this.myLogger.trace("Send Command: " + command + " " + FtpClient.getParamsAsString(params));
        }
    }

    private static String getParamsAsString(String[] params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < params.length) {
            sb.append(String.valueOf(params[i]) + ", ");
            ++i;
        }
        String ok = sb.toString();
        if (ok.length() > 2) {
            return ok.substring(0, ok.length() - 2);
        }
        return ok;
    }

    private FtpReply sendDataCommand(String command, String[] params) throws FtpException {
        this.myLogger.trace("Send Data Command: " + command);
        FtpReply reply = null;
        try {
            if (this.myIsActiveClient) {
                reply = this.setPassiveMode();
                this.myDataConnection = new DataConnection(this.myServerDataAddress.getAddress().getHostAddress(), this.myServerDataAddress.getPort());
            } else {
                this.myDataConnection = new DataConnection(null);
                reply = this.setPort(this.myClientControlConnection.getLocalSocketAddress().getAddress().getHostAddress(), this.myDataConnection.getServerSocketAddress().getPort());
            }
        }
        catch (Throwable ex) {
            this.myLogger.error("Send Data Command failed. Command:" + command, ex);
            this.stopProcessingCommand();
            throw new FtpException(ex.getMessage(), ex);
        }
        this.sendCommand(command, params);
        reply = this.checkReply();
        if (!this.myIsActiveClient) {
            try {
                this.myDataConnection.waitForClient();
            }
            catch (Throwable ex) {
                this.stopProcessingCommand();
                throw new FtpException(ex.getMessage(), ex);
            }
        }
        return reply;
    }

    private synchronized void startProcessingCommand() {
        if (this.myProcessingCommand) {
            this.myLogger.warn("Start Processing Command requested, but it is already set");
        }
        this.myProcessingCommand = true;
        this.myCommandSend = true;
    }

    private synchronized void stopProcessingCommand() {
        this.myProcessingCommand = false;
        this.myCurrentCommand = null;
    }

    private FtpReply loginInternal(String userName, String password) throws FtpException {
        this.sendCommand("USER", new String[]{userName});
        FtpReply reply = this.checkReply();
        this.sendCommand("PASS", new String[]{password});
        reply = this.checkReply();
        this.myUserName = userName;
        return reply;
    }

    private FtpReply connectInternal(String serverAddress, int serverPort) throws FtpException, IOException {
        this.myClientControlConnection = new ClientControlConnection(serverAddress, serverPort);
        FtpReply reply = this.checkReply();
        this.myLogger.debug("Connected to " + serverAddress + ":" + serverPort + ", reply =" + reply);
        return reply;
    }

    private int tryToGetFileSize(String path, boolean local) {
        int size = 0;
        try {
            size = (int)this.getFileSizeUsingListCmd(path, local);
        }
        catch (Throwable ex) {
            try {
                size = (int)this.getFileSizeUsingSizeCmd(path);
            }
            catch (Throwable ex2) {
                this.myLogger.warn("Couldn't get size of the file.", ex2);
            }
        }
        return size;
    }

    private long getFileSizeUsingListCmd(String path, boolean local) throws FtpException {
        long size = 0L;
        if (local) {
            File file = new File(path);
            size = file.length();
        } else {
            String[] output = new String[1];
            FtpReply[] outputReply = new FtpReply[1];
            List list = (List)this.getFileList(path, output, outputReply);
            try {
                size = ((FileInfo)list.get(0)).getSize();
            }
            catch (Throwable ex) {
                throw new FtpException("Failed to get file size.", ex);
            }
        }
        return size;
    }

    private long getFileSizeUsingSizeCmd(String path) throws FtpException {
        this.sendCommand("SIZE", new String[]{path});
        FtpReply reply = this.checkReply();
        return Long.parseLong(reply.getReply().substring(4));
    }

    private boolean isServerFileSizeGreaterThanZero(String serverFile) throws FtpException {
        return this.getFileSize(serverFile) > 0L;
    }

    private long getFileSize(String serverFile) throws FtpException {
        this.sendCommand("SIZE", new String[]{serverFile});
        FtpReply reply = this.checkReply();
        return this.getFileSize(reply);
    }

    private long getFileSize(FtpReply reply) {
        Matcher matcher = FTP_SIZE_REPLY_PATTERN.matcher(reply.getReply());
        if (matcher.find()) {
            String size = matcher.group(2);
            try {
                Long val = Long.valueOf(size);
                return val;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static final class FtpReplyException
    extends FtpException {
        private FtpReply myReply;

        private FtpReplyException(String desc, FtpReply reply) {
            super(desc);
            this.myReply = reply;
        }

        private FtpReply getReply() {
            return this.myReply;
        }
    }

    private class ProgressTimerListener
    extends TimerTask {
        private ProgressTimerListener() {
        }

        @Override
        public void run() {
            if (FtpClient.this.myDataConnection != null) {
                double percentage = FtpClient.this.myTransferInfo.getContentLength() > 0L ? (double)FtpClient.this.myDataConnection.getTransferredBytes() / (double)FtpClient.this.myTransferInfo.getContentLength() : 0.0;
                TransferListener transferListener = FtpClient.this.myFileTransferListener;
                TransferInfo transferInfo = new TransferInfo(FtpClient.this.myTransferInfo.getContentLength(), percentage, TransferInfo.TransferStatus.TRANSFER_ONGOING, FtpClient.this.myTransferInfo.getFile(), FtpClient.this.myUserName);
                FtpClient.this.myTransferInfo = transferInfo;
                transferListener.transferUpdated(transferInfo);
            }
        }
    }

    private class TimeoutListener
    implements ActionListener {
        private double myPercentage = 0.0;
        private long myIdleTime = 0L;

        private TimeoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.myIdleTime += 1000L;
            if (FtpClient.this.myDataConnection != null) {
                if (FtpClient.this.myTransferInfo != null) {
                    if (!GeneralUtils.isEqual(FtpClient.this.myTransferInfo.getTransferPercentage(), this.myPercentage)) {
                        this.myIdleTime = 0L;
                        this.myPercentage = FtpClient.this.myTransferInfo.getTransferPercentage();
                    }
                } else if (!GeneralUtils.isEqual(FtpClient.this.myDataConnection.getTransferredBytes(), this.myPercentage)) {
                    this.myIdleTime = 0L;
                    this.myPercentage = FtpClient.this.myDataConnection.getTransferredBytes();
                }
            } else if (FtpClient.this.myCommandSend) {
                this.myIdleTime = 0L;
                FtpClient.this.myCommandSend = false;
            }
            if (this.myIdleTime > FtpClient.this.myIdleTimeOut) {
                if (FtpClient.this.myFileTransferListener != null) {
                    TransferListener transferListener = FtpClient.this.myFileTransferListener;
                    TransferInfo transferInfo = new TransferInfo(FtpClient.this.myTransferInfo.getContentLength(), FtpClient.this.myTransferInfo.getTransferPercentage(), TransferInfo.TransferStatus.TRANSFER_ERROR, FtpClient.this.myTransferInfo.getFile(), FtpClient.this.myTransferInfo.getUserName(), null, "File transfer failed because of timeout exceeded");
                    FtpClient.this.myTransferInfo = transferInfo;
                    transferListener.transferUpdated(transferInfo);
                } else {
                    if (FtpClient.this.myDataConnection != null) {
                        FtpClient.this.myDataConnection.timeout();
                        FtpClient.this.myDataConnection.cancel();
                    }
                    FtpClient.this.myClientControlConnection.timeout();
                }
            } else {
                FtpClient.this.myIdleTimer.startTimer(FtpClient.this.myTimeoutListener, 1000L, false, 1);
            }
        }
    }
}

