/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

public class FtpCommand {
    public static final String USER = "USER";
    public static final String PASSWORD = "PASS";
    public static final String QUIT = "QUIT";
    public static final String PORT = "PORT";
    public static final String PASSIVE = "PASV";
    public static final String TYPE = "TYPE";
    public static final String STRUCTURE = "STRU";
    public static final String MODE = "MODE";
    public static final String RETRIEVE = "RETR";
    public static final String STORE = "STOR";
    public static final String ABORT = "ABOR";
    public static final String LIST = "LIST";
    public static final String DELETE = "DELE";
    public static final String SIZE = "SIZE";
    public static final String NAMELIST = "NLST";
    public static final String SYSTEM = "SYST";
    public static final String NOOPER = "NOOP";
    public static final String CHANGEDIR = "CWD";
    public static final String MAKEDIR = "MKD";
    public static final String REMOVEDIR = "RMD";
    public static final String XCHANGEDIR = "XCWD";
    public static final String DIRUP = "CDUP";
    public static final String XDIRUP = "XCDUP";
    public static final String PRINTDIR = "PWD";
    public static final String XPRINTDIR = "XPWD";
    public static final String HELP = "HELP";
    private String myCommand;
    private String[] myParams;

    public FtpCommand(String command) {
        this(command, null);
    }

    public FtpCommand(String command, String[] params) {
        this.myCommand = command.toUpperCase();
        this.myParams = params;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public String[] getParams() {
        if (this.myParams != null) {
            String[] copy = new String[this.myParams.length];
            System.arraycopy(this.myParams, 0, copy, 0, this.myParams.length);
            return copy;
        }
        return new String[0];
    }

    public boolean compare(String command) {
        return this.myCommand.equalsIgnoreCase(command);
    }

    public String toString() {
        StringBuffer commandB = new StringBuffer(this.myCommand);
        if (this.myParams != null) {
            int i = 0;
            while (i < this.myParams.length) {
                if (this.myParams[i] != null && this.myParams[i].length() != 0) {
                    commandB.append(" ");
                    commandB.append(this.myParams[i]);
                }
                ++i;
            }
        }
        return commandB.toString();
    }
}

