/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

public class FtpReply {
    public static final String OPEN_DATA_CONN_150 = "150";
    public static final String COMMAND_OK_200 = "200";
    public static final String HELP_MESSAGE_214 = "214";
    public static final String SYSTEM_TYPE_215 = "215";
    public static final String SERVICE_READY_220 = "220";
    public static final String SERVICE_CLOSING_221 = "221";
    public static final String CLOSE_DATA_CONN_226 = "226";
    public static final String PASSIVE_MODE_227 = "227";
    public static final String USER_LOGGED_IN_230 = "230";
    public static final String FILE_ACTION_OK_250 = "250";
    public static final String PATH_NAME_257 = "257";
    public static final String USER_OK_NEED_PASS_331 = "331";
    public static final String CANNOT_OPEN_DATA_CONN_425 = "425";
    public static final String CONNECTION_CLOSED_426 = "426";
    public static final String FILE_NOT_AVAILABLE_450 = "450";
    public static final String NOT_ENOUGH_SPACE_452 = "452";
    public static final String INVALID_PARAMS_501 = "501";
    public static final String COMMAND_NOT_IMPL_502 = "502";
    public static final String BAD_SEQUENCE_503 = "503";
    public static final String PARAM_NOT_SUPPORTED_504 = "504";
    public static final String FILE_ALREADY_EXIST_521 = "521";
    public static final String NOT_LOGGED_IN_530 = "530";
    public static final String FILE_NOT_AVAILABLE_550 = "550";
    public static final String FILE_SIZE_213 = "213";
    private String myCode;
    private String myMessage;
    private String myFullReply;

    public FtpReply(String code, String message) {
        this.myCode = code;
        this.myMessage = message;
        this.myFullReply = this.getReplyString(this.myCode, this.myMessage);
    }

    public String getCode() {
        return this.myCode;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public boolean isPositivePreliminary() {
        return this.myCode.charAt(0) == '1';
    }

    public boolean isPositiveCompletion() {
        return this.myCode.charAt(0) == '2';
    }

    public boolean isPositiveIntermediate() {
        return this.myCode.charAt(0) == '3';
    }

    public boolean isPositive() {
        return this.isPositiveCompletion() || this.isPositiveIntermediate();
    }

    public boolean isTransientNegativeCompletion() {
        return this.myCode.charAt(0) == '4';
    }

    public boolean isPermanentNegativeCompletion() {
        return this.myCode.charAt(0) == '5';
    }

    public boolean isNegative() {
        return this.isTransientNegativeCompletion() || this.isPermanentNegativeCompletion();
    }

    public boolean isSyntaxReply() {
        return this.myCode.charAt(1) == '0';
    }

    public boolean isInformationReply() {
        return this.myCode.charAt(1) == '1';
    }

    public boolean isAuthenticationReply() {
        return this.myCode.charAt(1) == '3';
    }

    public boolean isFileSystemReply() {
        return this.myCode.charAt(1) == '5';
    }

    public String toString() {
        return this.myFullReply;
    }

    public String getReply() {
        return this.myFullReply;
    }

    private String getReplyString(String code, String msg) {
        StringBuffer reply = null;
        String lineBreak = System.getProperty("line.separator");
        if (msg != null && msg.length() >= 4 && this.checkMessage(msg) != null) {
            reply = new StringBuffer(this.checkMessage(msg));
        }
        if (reply == null) {
            reply = new StringBuffer();
            reply.append(code);
            if (-1 == msg.indexOf(lineBreak)) {
                reply.append(' ');
                reply.append(msg);
            } else {
                reply.append('-');
                int pos = msg.lastIndexOf(lineBreak);
                reply.append(msg.substring(0, pos + 1));
                reply.append(code);
                reply.append(' ');
                if (msg.length() > pos + 1) {
                    reply.append(msg.substring(pos + 2));
                }
            }
        }
        return reply.toString();
    }

    private String checkMessage(String msg) {
        if (Character.isDigit(msg.charAt(0)) && Character.isDigit(msg.charAt(1)) && Character.isDigit(msg.charAt(2)) && msg.charAt(3) == ' ') {
            return msg;
        }
        return null;
    }
}

