/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.ftp.ServerConfiguration;
import com.nokia.em.poseidon.comm.ftp.ServerListener;
import com.nokia.em.poseidon.comm.ftp.ServerSession;
import com.nokia.em.poseidon.comm.ftp.UserProfile;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FtpServer {
    private static final int SERVER_TIMEOUT = 2000;
    private ServerConfiguration myServerConfig;
    private boolean myIsRunning = false;
    private List mySessions = Collections.synchronizedList(new ArrayList());
    private Thread myServerThread;
    private ServerSocket myServerSocket;
    private List myListeners = Collections.synchronizedList(new ArrayList(5));
    private Logger myLogger = Logger.getLogger(FtpServer.class);

    public FtpServer() {
        this.myServerConfig = new ServerConfiguration();
    }

    public void start() throws FtpException {
        if (!this.isRunning()) {
            this.createServerSocket();
            this.myServerThread = new CachedThread(new Runnable(){

                @Override
                public void run() {
                    FtpServer.this.run();
                }
            }, "FTP Server " + this.myServerConfig.getServerPort());
            this.myServerThread.start();
            this.myLogger.debug("FTP server started; Port: " + this.myServerConfig.getPortRange());
        } else {
            this.myLogger.debug("Could not start FTP server: Server already running");
        }
    }

    public void stop() {
        this.myIsRunning = false;
    }

    public boolean isRunning() {
        return this.myServerThread != null;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.myServerConfig;
    }

    public Collection getSessions() {
        return new ArrayList(this.mySessions);
    }

    public Collection getSession(String userName) {
        ArrayList<ServerSession> sessions = new ArrayList<ServerSession>(5);
        for (ServerSession tmpSession : new ArrayList(this.mySessions)) {
            if (!tmpSession.getUser().getUserName().equals(userName)) continue;
            sessions.add(tmpSession);
        }
        return sessions;
    }

    public UserProfile getUser(String userName) {
        return this.myServerConfig.getUser(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerListener(ServerListener listener) {
        if (listener != null) {
            List list = this.myListeners;
            synchronized (list) {
                if (!this.myListeners.contains(listener)) {
                    this.myListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerListener(ServerListener listener) {
        List list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
        }
    }

    protected void serverSessionClosed(ServerSession session) {
        this.mySessions.remove(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUserLoggedIn(ServerSession session) {
        if (!this.isRunning() || session == null) {
            return;
        }
        List list = this.myListeners;
        synchronized (list) {
            Iterator it = new ArrayList(this.myListeners).iterator();
            while (it.hasNext()) {
                try {
                    ((ServerListener)it.next()).userLoggedIn(session);
                }
                catch (Throwable ex) {
                    this.myLogger.error("Failed to notify userLoggedIn", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUserLoggedOut(UserProfile user, InetSocketAddress address) {
        if (!this.isRunning() || user == null || address == null) {
            return;
        }
        List list = this.myListeners;
        synchronized (list) {
            Iterator it = new ArrayList(this.myListeners).iterator();
            while (it.hasNext()) {
                try {
                    ((ServerListener)it.next()).userLoggedOut(user, address);
                }
                catch (Throwable ex) {
                    this.myLogger.error("Failed to notify userLoggedOut", ex);
                }
            }
        }
    }

    private void run() {
        this.myIsRunning = true;
        this.myLogger.info("FTP server running. Waiting for clients.");
        this.fireServerStarted();
        this.waitForClients();
        this.fireServerStopped();
        this.destroy();
    }

    private void createServerSocket() throws FtpException {
        PortRange range = this.myServerConfig.getPortRange();
        InetAddress addr = this.myServerConfig.getServerAddress();
        this.myLogger.debug("Using port range: " + this.myServerConfig.getPortRange());
        int i = range.getStart();
        while (i <= range.getEnd()) {
            this.myLogger.debug("Trying to open port: " + i);
            try {
                this.myServerSocket = addr == null ? new ServerSocket(i) : new ServerSocket(i, 50, addr);
                this.myLogger.debug("Using port " + i + " as a control channel");
                this.myServerConfig.getPortRange().setSelectedPort(i);
                this.myServerSocket.setSoTimeout(2000);
                break;
            }
            catch (IOException e) {
                this.myLogger.debug("Couldn't create server on port " + i + (addr == null ? "." : " on IP address " + addr.getHostAddress()));
                ++i;
            }
        }
        if (this.myServerSocket == null) {
            throw new FtpException("Could not create FTP server on given port range.");
        }
    }

    private void closeServerSocket(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void waitForClients() {
        Socket controlSocket = null;
        while (this.myIsRunning) {
            try {
                controlSocket = this.myServerSocket.accept();
            }
            catch (InterruptedIOException intEx) {
                continue;
            }
            catch (Throwable ex) {
                this.myLogger.error("Could not accept new client connection.", ex);
                continue;
            }
            if (this.myIsRunning) {
                this.myLogger.debug("New client joined from: " + controlSocket.getRemoteSocketAddress());
                this.createNewServerSession(controlSocket);
                continue;
            }
            try {
                controlSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void createNewServerSession(Socket controlSocket) {
        ServerSession session;
        try {
            session = new ServerSession(this, controlSocket);
        }
        catch (Throwable ex) {
            if (ex instanceof IOException) {
                this.myLogger.error("Could not create new session.", ex);
            } else {
                this.myLogger.fatal("Unexpected error in session initialization.", ex);
            }
            this.closeSocket(controlSocket);
            return;
        }
        this.mySessions.add(session);
        CachedThread newThread = new CachedThread(new Runnable(){

            @Override
            public void run() {
                session.run();
            }
        }, "Session " + controlSocket.getInetAddress().getHostAddress() + " : " + controlSocket.getPort());
        ((Thread)newThread).start();
    }

    private void destroy() {
        this.closeServerSocket(this.myServerSocket);
        this.closeSessions();
        this.myLogger.info("FTP server stopped.");
        this.myListeners.clear();
        this.myIsRunning = false;
        this.myServerThread = null;
        this.myServerSocket = null;
        this.myServerConfig = null;
    }

    private void closeSessions() {
        Iterator it = new ArrayList(this.mySessions).iterator();
        while (it.hasNext()) {
            ((ServerSession)it.next()).close();
        }
        this.mySessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerStarted() {
        List list = this.myListeners;
        synchronized (list) {
            Iterator it = new ArrayList(this.myListeners).iterator();
            while (it.hasNext()) {
                try {
                    ((ServerListener)it.next()).serverStarted();
                }
                catch (Throwable ex) {
                    this.myLogger.error("Failed to notify serverStarted", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerStopped() {
        List list = this.myListeners;
        synchronized (list) {
            Iterator it = new ArrayList(this.myListeners).iterator();
            while (it.hasNext()) {
                try {
                    ((ServerListener)it.next()).serverStopped();
                }
                catch (Throwable ex) {
                    this.myLogger.error("Failed to notify serverStopped", ex);
                }
            }
        }
    }
}

