/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.ftp.FtpServer;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.ftp.ServerListener;
import com.nokia.em.poseidon.comm.ftp.UserProfile;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class FtpServerFactory {
    public static FtpServer createFtpServer() {
        return new FtpServer();
    }

    public static FtpServer createFtpServer(PortRange portRange) {
        return FtpServerFactory.createFtpServer(portRange, null, null, null);
    }

    public static FtpServer createFtpServer(PortRange portRange, InetAddress serverAddress) {
        return FtpServerFactory.createFtpServer(portRange, serverAddress, null, null);
    }

    public static FtpServer createFtpServer(PortRange portRange, InetAddress serverAddress, List<UserProfile> users) {
        return FtpServerFactory.createFtpServer(portRange, serverAddress, users, null);
    }

    public static FtpServer createFtpServer(PortRange portRange, InetAddress serverAddress, ServerListener serverListener, String userName, String password, String homeDir) {
        UserProfile user = new UserProfile(userName, password, homeDir);
        ArrayList<UserProfile> users = new ArrayList<UserProfile>();
        users.add(user);
        return FtpServerFactory.createFtpServer(portRange, serverAddress, users, serverListener);
    }

    public static FtpServer createFtpServer(PortRange portRange, InetAddress serverAddress, ServerListener serverListener, String userName, String password, String homeDir, String accessDir, boolean readRight, boolean writeRight) {
        UserProfile user = new UserProfile(userName, password, homeDir);
        user.createAccessRight(accessDir, readRight, writeRight);
        ArrayList<UserProfile> users = new ArrayList<UserProfile>();
        users.add(user);
        return FtpServerFactory.createFtpServer(portRange, serverAddress, users, serverListener);
    }

    public static FtpServer createFtpServer(PortRange portRange, InetAddress serverAddress, List<UserProfile> users, ServerListener serverListener) {
        FtpServer ftpServer = new FtpServer();
        ftpServer.getServerConfiguration().setServerPortRange(portRange);
        if (serverListener != null) {
            ftpServer.addServerListener(serverListener);
        }
        if (serverAddress != null) {
            ftpServer.getServerConfiguration().setServerAddress(serverAddress);
        }
        if (users != null && users.size() > 0) {
            ftpServer.getServerConfiguration().setUsers(new Vector<UserProfile>(users));
        }
        return ftpServer;
    }
}

