/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.ftp.UserProfile;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ServerConfiguration {
    private PortRange myServerPort = new PortRange(21, 21);
    private InetAddress myServerAddress;
    private Vector myUsers = new Vector();
    private int myProgressInterval = 500;
    private long myTimeout = 1800000L;

    protected ServerConfiguration() {
        this.myServerPort.setSelectedPort(21);
    }

    public void setServerPort(int port) {
        this.myServerPort = new PortRange(port, port);
    }

    public void setServerPortRange(PortRange portRange) {
        this.myServerPort = portRange;
    }

    public PortRange getPortRange() {
        return this.myServerPort;
    }

    public int getServerPort() {
        return this.myServerPort.getSelectedPort();
    }

    public void setServerAddress(InetAddress serverAddr) {
        this.myServerAddress = serverAddr;
    }

    public InetAddress getServerAddress() {
        return this.myServerAddress;
    }

    public void setUsers(Vector users) {
        this.myUsers.clear();
        this.myUsers.addAll(users);
    }

    public UserProfile createUser(String name, String password, String homeDir) {
        UserProfile alreadyUser = this.getUser(name);
        if (alreadyUser == null) {
            UserProfile newUser = new UserProfile(name, password, homeDir);
            this.myUsers.add(newUser);
            return newUser;
        }
        alreadyUser.setPassword(password);
        alreadyUser.setHomeDir(homeDir);
        return alreadyUser;
    }

    public void deleteUser(String name) {
        UserProfile user = this.getUser(name);
        if (user != null) {
            this.myUsers.remove(user);
        }
    }

    public Collection getUsers() {
        return (Collection)this.myUsers.clone();
    }

    public UserProfile getUser(String name) {
        Iterator iter = this.myUsers.iterator();
        UserProfile user = null;
        while (iter.hasNext()) {
            user = (UserProfile)iter.next();
            if (!name.equals(user.getUserName())) continue;
            return user;
        }
        return null;
    }

    public void setProgressInterval(int interval) {
        this.myProgressInterval = interval;
    }

    public int getProgressInterval() {
        return this.myProgressInterval;
    }

    public void setTimeout(long timeout) {
        this.myTimeout = timeout;
    }

    public long getTimeout() {
        return this.myTimeout;
    }
}

