/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.ftp.AbstractConnection;
import com.nokia.em.poseidon.comm.ftp.FtpCommand;
import com.nokia.em.poseidon.comm.ftp.FtpReply;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public class ServerControlConnection
extends AbstractConnection {
    protected boolean myIsRunning = true;
    protected BufferedReader myInputStream;
    protected PrintWriter myOutputStream;

    public ServerControlConnection(Socket controlSocket) throws IOException {
        super(controlSocket);
        this.mySocket.setSoTimeout(2000);
        this.myInputStream = new BufferedReader(new InputStreamReader(this.mySocket.getInputStream()));
        this.myOutputStream = new PrintWriter(this.mySocket.getOutputStream());
    }

    public FtpCommand readCommand() {
        String myCommandString = null;
        while (this.myIsRunning) {
            try {
                myCommandString = this.myInputStream.readLine();
                break;
            }
            catch (InterruptedIOException intEx) {
            }
            catch (Exception intEx) {
                return null;
            }
        }
        if (myCommandString == null || myCommandString.length() < 2) {
            return null;
        }
        if (myCommandString.charAt(0) == '\u00ff') {
            myCommandString = myCommandString.substring(2, myCommandString.length());
        }
        String cmd = null;
        String[] params = new String[1];
        int spaceLocation = myCommandString.indexOf(" ");
        if (spaceLocation == -1) {
            cmd = myCommandString;
        } else {
            cmd = myCommandString.substring(0, spaceLocation).trim();
            params[0] = myCommandString.substring(spaceLocation + 1, myCommandString.length()).trim();
        }
        return new FtpCommand(cmd, params);
    }

    public void sendReply(FtpReply reply) throws IOException {
        if (this.myOutputStream == null) {
            Logger.getLogger(this.getClass()).warn("No connection to client, could not send reply");
            return;
        }
        this.myOutputStream.print(String.valueOf(reply.toString()) + CR + LF);
        if (this.myOutputStream.checkError()) {
            throw new IOException("Connection lost");
        }
    }

    @Override
    public void destroy() {
        this.myIsRunning = false;
        this.closeReader(this.myInputStream);
        this.myInputStream = null;
        this.closeWriter(this.myOutputStream);
        this.myOutputStream = null;
        super.destroy();
    }

    public InetAddress getLocalAddress() {
        return this.mySocket.getLocalAddress();
    }
}

