/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.ftp.DataConnection;
import com.nokia.em.poseidon.comm.ftp.FtpCommand;
import com.nokia.em.poseidon.comm.ftp.FtpReply;
import com.nokia.em.poseidon.comm.ftp.FtpServer;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.ftp.ServerControlConnection;
import com.nokia.em.poseidon.comm.ftp.UserProfile;
import com.nokia.em.poseidon.comm.ftp.Utility;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ServerSession {
    private static final String REPLY_OPEN_DATA_CONN = "File status okay; about to open data connection";
    private static final String REPLY_COMMAND_OK = "Command okay";
    private static final String REPLY_SYST_UNIX = "UNIX Type: L8";
    private static final String REPLY_SERVICE_READY = "Service ready for new user";
    private static final String REPLY_SERVICE_CLOSED = "Service closing control connection.";
    private static final String REPLY_ABORT_PROCESSED = "Abort command was successfully processed";
    private static final String REPLY_PASSIVE_MODE = "Entering passive mode";
    private static final String REPLY_USER_LOGGED_IN = "User logged in, proceed";
    private static final String REPLY_TRANSFER_COMPLETE = "Transfer complete";
    private static final String REPLY_USER_OK_NEED_PASS = "User name okay, need password";
    private static final String REPLY_CANNOT_OPEN_DATA_CONN = "Opening data connection failed.";
    private static final String REPLY_CONNECTION_CLOSED = "Connection closed; transfer aborted.";
    private static final String REPLY_FILE_ACTION_NOT_TAKEN = "Requested file action not taken.";
    private static final String REPLY_INVALID_PARAMS = "Syntax error in parameters or arguments";
    private static final String REPLY_COMMAND_NOT_IMPL = "Command not implemented";
    private static final String REPLY_BAD_SEQUENCE = "Bad sequence of commands";
    private static final String REPLY_PARAM_NOT_SUPPORTED = "Command not implemented for that parameter";
    private static final String REPLY_NOT_LOGGED_IN = "Login failed. Not logged in.";
    private static final String REPLY_ACCESS_DENIED = "Access denied.";
    private static final String REPLY_TYPE_BINARY = "TYPE set to IMAGE (binary)";
    private static final String REPLY_TYPE_ASCII = "TYPE set to ASCII (non-print)";
    private static final String REPLY_DIRECTORY_SIZE_UNAVAILABLE = "Target is a directory.";
    private static final String REPLY_FILE_NOT_FOUND = "File not found.";
    private static final int STATE_NOT_LOGGED_IN = 1;
    private static final int STATE_LOGGING_IN = 2;
    private static final int STATE_AUTHENTICATED = 3;
    private static final int STATE_TRANSFERRING = 4;
    private static final String TIMEOUT_MESSAGE = "File transfer failed because of timeout exceeded";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int theTimeoutTimerDelay = 1000;
    private int myState = 1;
    private FtpServer myFtpServer;
    private ServerControlConnection myServerControlConnection;
    private DataConnection myDataConnection;
    private boolean myIsRunning = false;
    private InetSocketAddress myClientDataAddress;
    private boolean myIsBinaryTransfer = false;
    private boolean myIsActiveSession = true;
    private UserProfile myUser = null;
    private File myCurrentDir = new File("");
    private List<TransferListener> myListeners = Collections.synchronizedList(new ArrayList(5));
    private ProgressTimerListener myProgressListener;
    private TimerService myTimerService;
    private TimeoutListener myTimeOutListener;
    private long myIdleTime;
    private long myTimeout;
    private Thread myWorkerThread;
    private TransferInfo myFileTransferInfo;
    private boolean myFileTransferAborted = false;
    private Logger myLogger = Logger.getLogger(this.getClass());

    ServerSession(FtpServer server, Socket controlSocket) throws IOException {
        this.myFtpServer = server;
        this.myServerControlConnection = new ServerControlConnection(controlSocket);
        this.myClientDataAddress = new InetSocketAddress(this.myServerControlConnection.getSocketAddress().getAddress().getHostAddress(), this.myServerControlConnection.getSocketAddress().getPort());
        this.myTimerService = TimerService.getInstance();
        int interval = this.myFtpServer.getServerConfiguration().getProgressInterval();
        long timeout = this.myFtpServer.getServerConfiguration().getTimeout();
        if (interval != 0) {
            this.myProgressListener = new ProgressTimerListener();
        }
        if (timeout != 0L) {
            this.myTimeout = timeout;
        }
    }

    public UserProfile getUser() {
        return this.myUser;
    }

    public void close() {
        this.myIsRunning = false;
        this.interruptMyWorkerThread();
        if (this.myServerControlConnection != null) {
            this.myServerControlConnection.destroy();
        }
    }

    public InetSocketAddress getClientSocketAddress() {
        return this.myClientDataAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferListener(TransferListener listener) {
        if (listener != null) {
            List<TransferListener> list = this.myListeners;
            synchronized (list) {
                if (!this.myListeners.contains(listener)) {
                    this.myListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransferListener(TransferListener listener) {
        List<TransferListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
        }
    }

    void run() {
        this.initSession();
        this.waitForCommands();
        this.myLogger.debug("Client connection closed");
        this.destroy();
    }

    private void initSession() {
        this.myIsRunning = true;
        if (this.myTimerService != null) {
            this.myTimeOutListener = new TimeoutListener();
            this.myTimerService.startTimer(this.myTimeOutListener, 1000L, false, 1);
        }
        this.sendReply("220", REPLY_SERVICE_READY);
    }

    private void waitForCommands() {
        FtpCommand command = null;
        while (this.myIsRunning) {
            command = this.myServerControlConnection.readCommand();
            if (command == null) break;
            this.checkStateAndProcess(command);
        }
        this.myFtpServer.fireUserLoggedOut(this.getUser(), this.getClientSocketAddress());
    }

    private void checkStateAndProcess(FtpCommand command) {
        this.myIdleTime = 0L;
        if (command.compare("QUIT")) {
            this.myFileTransferAborted = true;
            this.myLogger.trace("ServerSession.checkStateAndProcess: execute QUIT");
            this.processCommand(command);
            return;
        }
        switch (this.myState) {
            case 1: {
                if (command.compare("USER") || command.compare("HELP")) break;
                this.sendReply("530", REPLY_NOT_LOGGED_IN);
                return;
            }
            case 2: {
                if (command.compare("PASS") || command.compare("HELP")) break;
                this.sendReply("503", REPLY_BAD_SEQUENCE);
                return;
            }
            case 3: {
                break;
            }
            case 4: {
                if (command.compare("ABOR") || command.compare("HELP") || command.compare("SYST")) break;
                this.sendReply("503", REPLY_BAD_SEQUENCE);
                return;
            }
        }
        this.processCommand(command);
    }

    private void destroy() {
        this.interruptMyWorkerThread();
        if (this.myServerControlConnection != null) {
            this.myServerControlConnection.destroy();
            this.myServerControlConnection = null;
        }
        this.closeDataConnection();
        this.myFtpServer.serverSessionClosed(this);
        this.myFtpServer = null;
        this.myDataConnection = null;
        this.myClientDataAddress = null;
        this.myCurrentDir = null;
        this.myProgressListener = null;
        if (this.myTimeOutListener != null) {
            this.myTimerService.stopTimer(this.myTimeOutListener);
        }
        this.myTimerService = null;
        this.myWorkerThread = null;
        if (this.myFileTransferInfo != null) {
            this.myFileTransferInfo = null;
        }
    }

    private void processCommand(FtpCommand command) {
        if (command.getCommand().equals("PASS")) {
            this.myLogger.trace("Process command: " + command.getCommand());
        } else {
            this.myLogger.trace("Process command: " + command);
        }
        if (command.compare("USER")) {
            this.cmdUserName(command.getParams());
        } else if (command.compare("PASS")) {
            this.cmdPassword(command.getParams());
        } else if (command.compare("QUIT")) {
            this.cmdQuit();
        } else if (command.compare("PORT")) {
            this.cmdPort(command.getParams());
        } else if (command.compare("PASV")) {
            this.cmdPassive();
        } else if (command.compare("TYPE")) {
            this.cmdType(command.getParams());
        } else if (command.compare("STRU")) {
            this.cmdStructure(command.getParams());
        } else if (command.compare("MODE")) {
            this.cmdMode(command.getParams());
        } else if (command.compare("RETR")) {
            this.startRetrieve(command);
        } else if (command.compare("STOR")) {
            this.startStore(command);
        } else if (command.compare("ABOR")) {
            this.cmdAbort();
        } else if (command.compare("SYST")) {
            this.cmdSystem();
        } else if (command.compare("NOOP")) {
            this.cmdNoOper();
        } else if (command.compare("CWD")) {
            this.cmdChangeDir(command.getParams());
        } else if (command.compare("XCWD")) {
            this.cmdChangeDir(command.getParams());
        } else if (command.compare("CDUP")) {
            this.cmdChangeToParentDir();
        } else if (command.compare("XCDUP")) {
            this.cmdChangeToParentDir();
        } else if (command.compare("LIST")) {
            this.cmdList(command.getParams(), false);
        } else if (command.compare("NLST")) {
            this.cmdList(command.getParams(), true);
        } else if (command.compare("PWD")) {
            this.cmdPrintDir(command.getParams());
        } else if (command.compare("XPWD")) {
            this.cmdPrintDir(command.getParams());
        } else if (command.compare("HELP")) {
            this.cmdHelp(command.getParams());
        } else if (command.compare("SIZE")) {
            this.cmdSize(command.getParams());
        } else {
            this.sendReply("502", REPLY_COMMAND_NOT_IMPL);
            this.myLogger.error("Could not process command, because command " + command.toString() + " not implemented");
        }
    }

    private void sendReply(String code, String message) {
        FtpReply reply = new FtpReply(code, message);
        try {
            this.myServerControlConnection.sendReply(reply);
        }
        catch (NullPointerException npe) {
            this.myLogger.debug("Control connection closed. Failed to send reply: " + reply, npe);
        }
        catch (Throwable ioe) {
            this.myLogger.debug("Failed to send reply: " + reply, ioe);
        }
        this.myLogger.trace("Send reply to client: " + reply.toString());
    }

    private boolean createDataConnection() {
        try {
            if (this.myIsActiveSession) {
                this.myDataConnection = this.myFtpServer.getServerConfiguration().getPortRange() == null ? new DataConnection(this.myClientDataAddress.getAddress().getHostAddress(), this.myClientDataAddress.getPort()) : new DataConnection(this.myClientDataAddress.getAddress(), this.myClientDataAddress.getPort(), this.myServerControlConnection.getLocalAddress(), this.myFtpServer.getServerConfiguration().getPortRange());
                this.sendReply("150", REPLY_OPEN_DATA_CONN);
            } else {
                this.sendReply("150", REPLY_OPEN_DATA_CONN);
                this.myDataConnection.waitForClient();
            }
        }
        catch (Throwable ex) {
            this.myLogger.error("Failed to create data socket. ", ex);
            this.myState = 3;
            this.sendReply("425", REPLY_CANNOT_OPEN_DATA_CONN);
            return false;
        }
        return true;
    }

    private void closeDataConnection() {
        if (this.myDataConnection != null) {
            this.myDataConnection.destroy();
            this.myDataConnection = null;
        }
    }

    private File getAbsoluteUserPath(String path) {
        if (path == null || path.length() == 0) {
            return this.myCurrentDir;
        }
        File absPath = null;
        char firstChar = path.charAt(0);
        absPath = firstChar == '\\' || firstChar == '/' ? new File(this.myUser.getHomeDir(), path) : new File(this.myCurrentDir, path);
        try {
            absPath = absPath.getCanonicalFile();
        }
        catch (Throwable ex) {
            this.myLogger.error("Invalid directory. ", ex);
            return null;
        }
        return absPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileTransferProgressUpdated(TransferInfo transferFile) {
        List<TransferListener> list = this.myListeners;
        synchronized (list) {
            Iterator<TransferListener> it = new ArrayList<TransferListener>(this.myListeners).iterator();
            while (it.hasNext()) {
                try {
                    it.next().transferUpdated(transferFile);
                }
                catch (Throwable ex) {
                    this.myLogger.error("Failed to notify transfer update ", ex);
                }
            }
        }
    }

    private void cmdUserName(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        UserProfile user = this.myFtpServer.getUser(params[0]);
        if (user != null) {
            if (this.myUser != null && this.myUser != user) {
                this.myFtpServer.fireUserLoggedOut(this.myUser, this.getClientSocketAddress());
            }
            this.myUser = user;
            this.myCurrentDir = new File(this.myUser.getHomeDir());
        }
        this.sendReply("331", REPLY_USER_OK_NEED_PASS);
        this.myState = 2;
    }

    private void cmdPassword(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        if (this.myUser == null) {
            this.sendReply("530", REPLY_NOT_LOGGED_IN);
            this.myState = 1;
            return;
        }
        if (this.myUser.getPassword() == null || this.myUser.getPassword().length() == 0 || this.myUser.getPassword().equals(params[0])) {
            this.sendReply("230", REPLY_USER_LOGGED_IN);
            this.myState = 3;
            this.myFtpServer.fireUserLoggedIn(this);
            this.myLogger.debug("New client connection established: " + this.myUser.getUserName() + " from address " + this.myClientDataAddress.getAddress().getHostAddress() + ":" + this.myClientDataAddress.getPort() + " logged in");
        } else {
            this.sendReply("530", REPLY_NOT_LOGGED_IN);
            this.myState = 1;
        }
    }

    private void cmdQuit() {
        this.cancelFileTransfer();
        String userName = "";
        String hostName = "";
        int hostPort = 0;
        if (this.myUser != null) {
            userName = this.myUser.getUserName();
        }
        if (this.myClientDataAddress != null) {
            hostName = this.myClientDataAddress.getAddress().getHostAddress();
            hostPort = this.myClientDataAddress.getPort();
        }
        this.myLogger.debug("Client disconnect: " + userName + " from address " + hostName + ":" + hostPort + " logged out");
        this.sendReply("221", REPLY_SERVICE_CLOSED);
        this.myIsRunning = false;
    }

    private void cmdPort(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        this.myClientDataAddress = Utility.parseAddressString(params[0]);
        if (this.myClientDataAddress == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        this.myIsActiveSession = true;
        this.sendReply("200", REPLY_COMMAND_OK);
    }

    private void cmdPassive() {
        this.closeDataConnection();
        PortRange range = this.myFtpServer.getServerConfiguration().getPortRange();
        try {
            this.myDataConnection = range.getEnd() - range.getStart() > 1 ? new DataConnection(range, this.myServerControlConnection.getLocalAddress()) : new DataConnection(this.myServerControlConnection.getLocalAddress());
        }
        catch (Throwable ex) {
            this.myLogger.error("Could not create server data socket. Command PASV.", ex);
            this.sendReply("425", REPLY_CANNOT_OPEN_DATA_CONN);
            return;
        }
        String address = Utility.createAddressString(this.myDataConnection.getServerSocketAddress().getAddress().getHostAddress(), this.myDataConnection.getServerSocketAddress().getPort());
        String message = "Entering passive mode (" + address + ")";
        this.myIsActiveSession = false;
        this.sendReply("227", message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cmdType(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        String[] parsedParams = params[0].split(" ");
        boolean supported = true;
        boolean binary = false;
        if ("A".equalsIgnoreCase(parsedParams[0])) {
            if (parsedParams.length == 2 && !"N".equalsIgnoreCase(parsedParams[1])) {
                supported = false;
            }
        } else if ("I".equalsIgnoreCase(parsedParams[0])) {
            if (parsedParams.length != 1) {
                this.sendReply("501", REPLY_INVALID_PARAMS);
                return;
            }
            binary = true;
        } else {
            supported = false;
        }
        if (!supported) {
            this.sendReply("504", REPLY_PARAM_NOT_SUPPORTED);
            return;
        }
        this.myIsBinaryTransfer = binary;
        this.sendReply("200", this.myIsBinaryTransfer ? REPLY_TYPE_BINARY : REPLY_TYPE_ASCII);
    }

    private void cmdStructure(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        if ("F".equalsIgnoreCase(params[0])) {
            this.sendReply("200", REPLY_COMMAND_OK);
        } else {
            this.sendReply("504", REPLY_PARAM_NOT_SUPPORTED);
        }
    }

    private void cmdMode(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        if ("S".equalsIgnoreCase(params[0])) {
            this.sendReply("200", REPLY_COMMAND_OK);
        } else {
            this.sendReply("504", REPLY_PARAM_NOT_SUPPORTED);
        }
    }

    private void cmdRetrieve(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        this.myState = 4;
        if (!this.createDataConnection()) {
            return;
        }
        String replyMessage = "";
        String replyCode = "";
        File file = null;
        boolean transferFailed = false;
        try {
            try {
                file = this.getAbsoluteUserPath(params[0]);
                this.myFileTransferInfo = new TransferInfo(file.length(), 0.0, TransferInfo.TransferStatus.TRANSFER_ONGOING, file, this.myUser.getUserName());
                this.fireFileTransferProgressUpdated(this.myFileTransferInfo);
                this.startTimer();
                this.myLogger.trace(" Start sendFile");
                this.myDataConnection.sendFile(file);
                this.myLogger.trace(" SendFile finished");
                if (this.myFileTransferAborted) {
                    replyMessage = REPLY_CONNECTION_CLOSED;
                    replyCode = "426";
                } else {
                    replyMessage = REPLY_TRANSFER_COMPLETE;
                    replyCode = "226";
                }
            }
            catch (Throwable ex) {
                if (this.myFileTransferAborted) {
                    replyMessage = REPLY_CONNECTION_CLOSED;
                    replyCode = "426";
                } else {
                    replyMessage = "Requested file action not taken.:" + params[0];
                    replyCode = "550";
                }
                transferFailed = true;
                this.myLogger.error("Failed to retrieve file", ex);
                try {
                    this.finalizeTransfer(replyCode, replyMessage, false, file, transferFailed);
                }
                catch (Exception e) {
                    this.myLogger.error("Failed to finalize file transfer. There may be some resources what are not released.", e);
                }
                return;
            }
        }
        finally {
            try {
                this.finalizeTransfer(replyCode, replyMessage, false, file, transferFailed);
            }
            catch (Exception e) {
                this.myLogger.error("Failed to finalize file transfer. There may be some resources what are not released.", e);
            }
        }
    }

    private void cmdStore(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        this.myState = 4;
        if (!this.createDataConnection()) {
            return;
        }
        String replyMessage = "";
        String replyCode = "";
        File file = null;
        try {
            file = this.getAbsoluteUserPath(params[0]);
            this.myFileTransferInfo = new TransferInfo(file.length(), 0.0, TransferInfo.TransferStatus.TRANSFER_ONGOING, file, this.myUser.getUserName());
            this.fireFileTransferProgressUpdated(this.myFileTransferInfo);
            this.startTimer();
            this.myLogger.trace("Start readFile");
            this.myDataConnection.readFile(file);
            this.myLogger.trace("ReadFile finished");
            if (this.myFileTransferAborted) {
                replyMessage = REPLY_CONNECTION_CLOSED;
                replyCode = "426";
            } else {
                replyMessage = REPLY_TRANSFER_COMPLETE;
                replyCode = "226";
            }
            this.finalizeTransfer(replyCode, replyMessage, this.myFileTransferAborted, file, this.myFileTransferAborted);
        }
        catch (Throwable ex) {
            if (this.myFileTransferAborted) {
                replyMessage = REPLY_CONNECTION_CLOSED;
                replyCode = "426";
            } else {
                replyMessage = "Requested file action not taken.:" + params[0];
                replyCode = "550";
            }
            this.myLogger.error("Failed to store file. ", ex);
            this.finalizeTransfer(replyCode, replyMessage, true, file, true);
            return;
        }
    }

    private void cmdSize(String[] params) {
        try {
            if (params[0].length() == 0) {
                throw new IllegalArgumentException();
            }
            File file = this.getAbsoluteUserPath(params[0]);
            if (file == null) {
                throw new IllegalArgumentException();
            }
            if (!file.exists()) {
                this.sendReply("550", REPLY_FILE_NOT_FOUND);
            } else if (file.isDirectory()) {
                this.sendReply("501", REPLY_DIRECTORY_SIZE_UNAVAILABLE);
            } else {
                long size = file.length();
                this.sendReply("213", Long.toString(size));
            }
        }
        catch (Throwable e) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
        }
    }

    private void finalizeTransfer(String replyCode, String replyMessage, boolean delete, File file, boolean failed) {
        this.stopTimer();
        if (this.myDataConnection != null && this.myFileTransferInfo != null) {
            double percentage = this.myFileTransferInfo.getContentLength() > 0L ? this.myDataConnection.getTransferredBytes() / this.myFileTransferInfo.getContentLength() : 0L;
            this.myFileTransferInfo = new TransferInfo(this.myFileTransferInfo.getContentLength(), percentage, failed ? TransferInfo.TransferStatus.TRANSFER_ERROR : TransferInfo.TransferStatus.TRANSFER_COMPLETED, this.myFileTransferInfo.getFile(), this.myUser.getUserName(), replyCode, replyMessage);
            this.closeDataConnection();
            this.fireFileTransferProgressUpdated(this.myFileTransferInfo);
        } else if (this.myDataConnection == null) {
            this.fireFileTransferProgressUpdated(new TransferInfo(-1L, -1.0, failed ? TransferInfo.TransferStatus.TRANSFER_ERROR : TransferInfo.TransferStatus.TRANSFER_COMPLETED, file, this.myUser.getUserName(), replyCode, replyMessage));
        }
        this.myState = 3;
        this.sendReply(replyCode, replyMessage);
        if (delete && file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    private void cmdAbort() {
        this.cancelFileTransfer();
        this.sendReply("226", REPLY_ABORT_PROCESSED);
    }

    private void cmdSystem() {
        this.sendReply("215", REPLY_SYST_UNIX);
    }

    private void cmdNoOper() {
        this.sendReply("200", REPLY_COMMAND_OK);
    }

    private void cmdChangeDir(String[] params) {
        if (params == null || params.length == 0 || params[0] == null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        File newPath = this.getAbsoluteUserPath(params[0]);
        if (newPath == null) {
            this.myLogger.error("Could not change directory: Invalid directory " + params[0]);
            this.sendReply("550", REPLY_FILE_ACTION_NOT_TAKEN);
            return;
        }
        if (!this.myUser.canRead(newPath.getAbsolutePath()) || !newPath.exists()) {
            this.myLogger.error("Could not change directory: No access rights to " + newPath.getAbsolutePath());
            this.sendReply("550", REPLY_ACCESS_DENIED);
            return;
        }
        this.myCurrentDir = newPath;
        this.sendReply("250", "Directory changed to " + this.myCurrentDir.getPath());
    }

    private void cmdChangeToParentDir() {
        this.cmdChangeDir(new String[]{".."});
    }

    private void cmdPrintDir(String[] params) {
        if (params != null && params.length != 0 && params[0] != null) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        File homeDir = new File(this.myUser.getHomeDir());
        String currPath = this.myCurrentDir.getPath();
        if (currPath.startsWith(homeDir.getPath())) {
            currPath = String.valueOf((currPath = currPath.substring(homeDir.getPath().length())).startsWith("/") ? "" : "/") + currPath;
        }
        this.sendReply("257", currPath);
    }

    private void cmdList(String[] params, boolean nameList) {
        this.myState = 4;
        File path = null;
        path = params != null && params.length != 0 && params[0] != null ? this.getAbsoluteUserPath(params[0]) : this.getAbsoluteUserPath(null);
        if (this.cmdListHelper(path)) {
            return;
        }
        String fileInfo = this.parseFileInformation(path, nameList);
        if (!this.createDataConnection()) {
            return;
        }
        String replyMessage = "";
        String replyCode = "";
        try {
            try {
                this.myDataConnection.sendString(fileInfo);
                replyMessage = REPLY_TRANSFER_COMPLETE;
                replyCode = "226";
            }
            catch (Throwable ex) {
                this.myLogger.error("Could not list directory. Invalid directory " + params[0], ex);
                replyMessage = "Requested file action not taken.:" + params[0];
                replyCode = "550";
                this.myState = 3;
                this.sendReply(replyCode, replyMessage);
                this.closeDataConnection();
                return;
            }
        }
        finally {
            this.myState = 3;
            this.sendReply(replyCode, replyMessage);
            this.closeDataConnection();
        }
    }

    private void cmdHelp(String[] params) {
        StringBuffer help = new StringBuffer();
        if (params != null && params.length > 0 && params[0] != null) {
            help.append(params[0]);
        } else {
            help.append(" The following commands are recognised:");
            help.append(NEWLINE);
            help.append("     ABOR    CWD    CDUP    HELP    LIST    MODE    NLST");
            help.append(NEWLINE);
            help.append("     NOOP    PASV   PASS    PORT    PWD     QUIT    RETR");
            help.append(NEWLINE);
            help.append("     STOR    STRU   SYST    TYPE    USER    XCWD    XCDUP");
            help.append(NEWLINE);
            help.append("     XPWD    SIZE");
            help.append(NEWLINE);
        }
        this.sendReply("214", help.toString());
    }

    private void startRetrieve(FtpCommand command) {
        final String[] params = command.getParams();
        if (params == null || params.length == 0) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        if (this.checkRights(params[0], false)) {
            return;
        }
        this.myFileTransferAborted = false;
        this.myWorkerThread = new CachedThread(new Runnable(){

            @Override
            public void run() {
                ServerSession.this.cmdRetrieve(params);
            }
        }, "retrieve");
        this.myWorkerThread.start();
    }

    private void startStore(FtpCommand command) {
        final String[] params = command.getParams();
        if (params == null || params.length == 0) {
            this.sendReply("501", REPLY_INVALID_PARAMS);
            return;
        }
        if (this.checkRights(params[0], true)) {
            return;
        }
        this.myFileTransferAborted = false;
        this.myWorkerThread = new CachedThread(new Runnable(){

            @Override
            public void run() {
                ServerSession.this.cmdStore(params);
            }
        }, "store");
        this.myWorkerThread.start();
    }

    private String getFileAsString(File file) {
        StringBuffer fileStr = new StringBuffer();
        StringBuffer tmpStr = new StringBuffer();
        fileStr.append(file.isDirectory() ? (char)'d' : '-');
        tmpStr.append(file.canRead() ? (char)'r' : '-');
        tmpStr.append(file.canWrite() ? (char)'w' : '-');
        tmpStr.append('x');
        fileStr.append(tmpStr);
        fileStr.append(tmpStr);
        fileStr.append(tmpStr);
        fileStr.append(" 1 user group");
        DecimalFormat decFrm = new DecimalFormat("0000000000");
        fileStr.append(this.removeZeros(file, decFrm.format(file.length()), Long.toString(file.length())));
        SimpleDateFormat dateFrm = new SimpleDateFormat(" MMM dd HH:mm", Locale.ENGLISH);
        fileStr.append(dateFrm.format(new Date(file.lastModified())));
        return fileStr.toString();
    }

    private boolean cmdListHelper(File path) {
        if (path == null) {
            this.myState = 3;
            this.myLogger.error("Could not list directory: Invalid directory.");
            this.sendReply("550", REPLY_FILE_ACTION_NOT_TAKEN);
            return true;
        }
        if (!this.myUser.canRead(path.getAbsolutePath()) || !path.exists()) {
            this.myState = 3;
            this.myLogger.error("Could not list directory: No access to " + path.getAbsoluteFile());
            this.sendReply("550", REPLY_FILE_ACTION_NOT_TAKEN);
            return true;
        }
        return false;
    }

    private String parseFileInformation(File path, boolean nameList) {
        StringBuffer filesInfo = new StringBuffer();
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files != null) {
                int idx = 0;
                while (idx < files.length) {
                    if (!nameList) {
                        filesInfo.append(this.getFileAsString(files[idx]));
                        filesInfo.append(' ');
                    }
                    filesInfo.append(files[idx].getName());
                    filesInfo.append(NEWLINE);
                    ++idx;
                }
            }
        } else {
            if (!nameList) {
                filesInfo.append(this.getFileAsString(path));
                filesInfo.append(' ');
            }
            filesInfo.append(path.getName());
            filesInfo.append(NEWLINE);
        }
        return filesInfo.toString();
    }

    private void cancelFileTransfer() {
        if (this.myState == 4) {
            this.myLogger.debug("Cancel file transfer");
            if (this.myDataConnection != null) {
                this.myDataConnection.cancel();
            }
            if (this.myWorkerThread != null) {
                try {
                    this.myWorkerThread.join();
                }
                catch (Throwable ex) {
                    this.myLogger.error("Could not join to wait worker thread. ", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptMyWorkerThread() {
        if (this.myWorkerThread != null) {
            Thread thread = this.myWorkerThread;
            synchronized (thread) {
                this.myFileTransferAborted = true;
                if (this.myDataConnection != null) {
                    this.myDataConnection.cancel();
                }
                try {
                    this.myWorkerThread.join();
                }
                catch (Throwable ex) {
                    this.myLogger.error("Could not join to wait worker thread. ", ex);
                }
            }
        }
    }

    private boolean checkRights(String path, boolean accessRightType) {
        File file = this.getAbsoluteUserPath(path);
        String tempFile = file.getParent();
        if (!accessRightType) {
            if (tempFile == null || !this.myUser.canRead(tempFile)) {
                this.myLogger.error("No read access to " + tempFile);
                this.sendReply("550", REPLY_ACCESS_DENIED);
                return true;
            }
        } else if (tempFile == null || !this.myUser.canWrite(tempFile)) {
            this.myLogger.error("No write access to " + tempFile);
            this.sendReply("550", REPLY_ACCESS_DENIED);
            return true;
        }
        return false;
    }

    private void startTimer() {
        if (this.myProgressListener != null) {
            int interval = this.myFtpServer.getServerConfiguration().getProgressInterval();
            this.myTimerService.startTimer(System.currentTimeMillis(), this.myProgressListener, (long)interval, false, 0, true);
        }
    }

    private void stopTimer() {
        if (this.myProgressListener != null) {
            this.myTimerService.stopTimer(this.myProgressListener);
        }
    }

    private String removeZeros(File f, String str, String len) {
        StringBuffer sb = new StringBuffer(str);
        int size = sb.length();
        int index = 0;
        int j = len.length();
        while (j < size) {
            sb.replace(index, index + 1, " ");
            ++index;
            ++j;
        }
        return sb.toString();
    }

    private class ProgressTimerListener
    implements ActionListener {
        private ProgressTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ServerSession.this.myDataConnection != null) {
                double percentage = ServerSession.this.myFileTransferInfo.getContentLength() > 0L ? (double)ServerSession.this.myDataConnection.getTransferredBytes() / (double)ServerSession.this.myFileTransferInfo.getContentLength() : 0.0;
                TransferInfo transferInfo = new TransferInfo(ServerSession.this.myFileTransferInfo.getContentLength(), percentage, TransferInfo.TransferStatus.TRANSFER_ONGOING, ServerSession.this.myFileTransferInfo.getFile(), ServerSession.this.myUser.getUserName());
                ServerSession.this.myFileTransferInfo = transferInfo;
                ServerSession.this.fireFileTransferProgressUpdated(transferInfo);
            }
        }
    }

    private class TimeoutListener
    implements ActionListener {
        private double myPercentage = 0.0;

        private TimeoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ServerSession serverSession = ServerSession.this;
            serverSession.myIdleTime = serverSession.myIdleTime + 1000L;
            if (ServerSession.this.myIsRunning) {
                return;
            }
            if (ServerSession.this.myDataConnection != null && ServerSession.this.myFileTransferInfo != null && !GeneralUtils.isEqual(ServerSession.this.myFileTransferInfo.getTransferPercentage(), this.myPercentage)) {
                ServerSession.this.myIdleTime = 0L;
                this.myPercentage = ServerSession.this.myFileTransferInfo.getTransferPercentage();
            }
            if (ServerSession.this.myIdleTime > ServerSession.this.myTimeout) {
                if (ServerSession.this.myFileTransferInfo != null) {
                    TransferInfo transferInfo = new TransferInfo(ServerSession.this.myFileTransferInfo.getContentLength(), ServerSession.this.myFileTransferInfo.getTransferPercentage(), TransferInfo.TransferStatus.TRANSFER_ERROR, ServerSession.this.myFileTransferInfo.getFile(), ServerSession.this.myFileTransferInfo.getUserName(), null, ServerSession.TIMEOUT_MESSAGE);
                    ServerSession.this.myFileTransferInfo = transferInfo;
                    ServerSession.this.fireFileTransferProgressUpdated(transferInfo);
                }
                ServerSession.this.close();
            } else {
                ServerSession.this.myTimerService.startTimer(ServerSession.this.myTimeOutListener, 1000L, false, 1);
            }
        }
    }
}

